/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import com.mojang.authlib.GameProfile;
import journeymap.client.Constants;
import journeymap.common.Journeymap;
import journeymap.common.LoaderHooks;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.network.data.model.Location;
import journeymap.common.properties.DimensionProperties;
import journeymap.common.properties.PropertiesManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class JourneyMapTeleport {
    private static final JourneyMapTeleport INSTANCE = new JourneyMapTeleport();

    private JourneyMapTeleport() {
    }

    public static JourneyMapTeleport instance() {
        return INSTANCE;
    }

    public boolean attemptTeleport(Entity entity, Location location) {
        MinecraftServer mcServer = LoaderHooks.getServer();
        boolean creative = false;
        boolean cheatMode = false;
        if (entity == null) {
            Journeymap.getLogger().error("Attempted to teleport null entity.");
            return false;
        }
        if (entity instanceof ServerPlayer) {
            creative = ((ServerPlayer)entity).m_150110_().f_35937_;
            cheatMode = mcServer.m_6846_().m_11303_(new GameProfile(entity.m_20148_(), entity.m_7755_().getString()));
            if (mcServer == null) {
                entity.m_213846_((Component)Constants.getStringTextComponent("Cannot Find World"));
                return false;
            }
            if (this.isTeleportAvailable(entity, location) || creative || cheatMode || Journeymap.isOp((Player)((ServerPlayer)entity))) {
                if (!entity.m_6084_()) {
                    entity.m_213846_((Component)Constants.getStringTextComponent("Cannot teleport when dead."));
                    return false;
                }
                ServerLevel destinationWorld = mcServer.m_129880_(DimensionHelper.getWorldKeyForName(location.getDim()));
                if (destinationWorld == null) {
                    for (ServerLevel world : mcServer.m_129785_()) {
                        if (!location.getDim().equalsIgnoreCase(DimensionHelper.getDimName((Level)world)) && !location.getDim().equalsIgnoreCase(DimensionHelper.getDimKeyName((ResourceKey<Level>)world.m_46472_()))) continue;
                        destinationWorld = world;
                        break;
                    }
                }
                if (destinationWorld == null) {
                    entity.m_213846_((Component)Constants.getStringTextComponent("Could not get world for Dimension " + location.getDim()));
                    return false;
                }
                return this.teleportEntity(destinationWorld, entity, location);
            }
            entity.m_213846_((Component)Constants.getStringTextComponent("Server has disabled JourneyMap teleport usage for your current or destination dimension."));
            return false;
        }
        return false;
    }

    private boolean isTeleportAvailable(Entity entity, Location location) {
        DimensionProperties destinationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getWorldKeyForName(location.getDim()));
        DimensionProperties entityLocationProperty = PropertiesManager.getInstance().getDimProperties(DimensionHelper.getDimension(entity));
        return this.canDimTeleport(destinationProperty) && this.canDimTeleport(entityLocationProperty);
    }

    private boolean canDimTeleport(DimensionProperties properties) {
        if (properties.enabled.get().booleanValue()) {
            return properties.teleportEnabled.get();
        }
        return PropertiesManager.getInstance().getGlobalProperties().teleportEnabled.get();
    }

    private boolean teleportEntity(ServerLevel destinationWorld, Entity player, Location location) {
        boolean changedWorld;
        ServerLevel startWorld = (ServerLevel)player.f_19853_;
        boolean bl = changedWorld = startWorld != destinationWorld;
        if (player instanceof ServerPlayer) {
            if (changedWorld) {
                LoaderHooks.doTeleport((ServerPlayer)player, destinationWorld, location);
            } else {
                player.m_6021_(location.getX(), location.getY(), location.getZ());
            }
        }
        return false;
    }
}

