/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.compatibility.CompatibilityCurio;
import ovh.corail.tombstone.compatibility.IntegrationTOP;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.config.TombstoneModConfig;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.proxy.ClientProxy;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.proxy.ServerProxy;
import ovh.corail.tombstone.registry.ClientModEvents;

@Mod(value="tombstone")
public final class ModTombstone {
    public static final String MOD_ID = "tombstone";
    public static final String MOD_NAME = "Corail Tombstone";
    public static final Logger LOGGER = LogManager.getLogger((String)"tombstone");
    public static final IProxy PROXY = (IProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final EnchantmentCategory TYPE_TOMBSTONE_ALL = EnchantmentCategory.create((String)"type_tombstone_all", p -> p != null && (p.m_6473_() > 0 || p.m_41459_() == 1));

    public ModTombstone() {
        TombstoneAPIProps.COOLDOWN_HANDLER = CooldownHandler.INSTANCE;
        ModLoadingContext context = ModLoadingContext.get();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigTombstone.CLIENT_SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigTombstone.GENERAL_SPEC);
        this.registerSharedConfig(context);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::preInit);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::enqueueIMC);
        context.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ScreenConfig::new));
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (SupportMods.TOP.isLoaded()) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", IntegrationTOP::new);
        }
        if (SupportMods.CURIOS.isLoaded() && ((Boolean)ConfigTombstone.compatibility.curioBundleSupport.get()).booleanValue()) {
            CompatibilityCurio.instance.sendIMC();
        }
    }

    private void registerSharedConfig(ModLoadingContext context) {
        context.getActiveContainer().addConfig((ModConfig)new TombstoneModConfig(SharedConfigTombstone.CONFIG_SPEC, context.getActiveContainer()));
    }

    private void preInit(FMLCommonSetupEvent event) {
        PROXY.preInit();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(ClientModEvents::initModels);
    }
}

