/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;

public record CMessageEffect(int entityId, MobEffectInstance effectInstance) {
    static CMessageEffect fromBytes(FriendlyByteBuf buf) {
        int id = buf.m_130242_();
        MobEffect effect = Optional.ofNullable((MobEffect)buf.m_236816_((IdMap)BuiltInRegistries.f_256974_)).orElse(MobEffects.f_19618_);
        int duration = buf.m_130242_();
        byte amplifier = buf.readByte();
        byte flags = buf.readByte();
        Optional<MobEffectInstance.FactorData> optionalData = Optional.ofNullable((MobEffectInstance.FactorData)buf.m_236868_(b -> (MobEffectInstance.FactorData)b.m_130057_(MobEffectInstance.FactorData.f_216907_)));
        return new CMessageEffect(id, new MobEffectInstance(effect, duration, (int)amplifier, (flags & 1) == 1, (flags & 2) == 2, (flags & 4) == 4, null, optionalData));
    }

    static void toBytes(CMessageEffect msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.entityId);
        buf.m_236818_((IdMap)BuiltInRegistries.f_256974_, (Object)msg.effectInstance.m_19544_());
        buf.m_130130_(msg.effectInstance.m_19557_());
        buf.writeByte(msg.effectInstance.m_19564_());
        buf.writeByte((int)((byte)((msg.effectInstance.m_19571_() ? 1 : 0) + (msg.effectInstance.m_19572_() ? 2 : 0) + (msg.effectInstance.m_19575_() ? 4 : 0))));
        buf.m_236821_((Object)msg.effectInstance.m_216895_().orElse(null), (b, d) -> b.m_130059_(MobEffectInstance.FactorData.f_216907_, d));
    }

    public static class Handler {
        static void handle(final CMessageEffect msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ModTombstone.PROXY.getClientWorld().map(level -> level.m_6815_(msg2.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
                            MobEffectInstance effectInstance = new MobEffectInstance(msg2.effectInstance);
                            entity.m_147215_(effectInstance, null);
                        });
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

