/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ITab;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

@Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class ModTabs {
    public static final ResourceLocation TAB_ID = new ResourceLocation("tombstone");

    @SubscribeEvent
    public static void onCreativeTab(CreativeModeTabEvent.Register event) {
        event.registerCreativeModeTab(TAB_ID, builder -> builder.m_257941_((Component)Component.m_237113_((String)"Corail Tombstone")).m_257737_(() -> new ItemStack((ItemLike)ModBlocks.DECORATIVE_GRAVES.get((Object)GraveModel.TOMBSTONE))).m_257501_((featureFlagSet, toAdd, flag) -> {
            Arrays.stream(GraveModel.values()).forEach(graveModel -> IntStream.rangeClosed(0, 1).mapToObj(textureId -> ItemBlockGrave.createDecorativeStack(graveModel, textureId)).forEach(arg_0 -> ((CreativeModeTab.Output)toAdd).m_246342_(arg_0)));
            ModItems.ITEMS.forEach(item -> {
                if (item instanceof ITab) {
                    ((ITab)item).fillItemCategory(toAdd);
                } else {
                    toAdd.m_246326_((ItemLike)item);
                }
            });
            toAdd.m_246342_(NBTStackHelper.setBoolean(new ItemStack((ItemLike)Items.f_151058_), "enchant", true));
            toAdd.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.bait));
            toAdd.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.frostbite));
            toAdd.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.frostbite, 2));
            toAdd.m_246342_(EffectHelper.createMagicArrows(1, ModEffects.frostbite, 4));
            toAdd.m_246342_(EffectHelper.createMagicArrows(1, MobEffects.f_216964_));
            toAdd.m_246342_(EffectHelper.createCursedArrows(1));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.spectral));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.earthly_garden));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)ModPotions.discretion));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.bait));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.frostbite));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)ModPotions.darkness));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.bait));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.frostbite));
            toAdd.m_246342_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)ModPotions.darkness));
            ModTabs.fillWithEnchantedBook(toAdd);
        }).withSearchBar().m_257652_());
    }

    private static void fillWithEnchantedBook(CreativeModeTab.Output items) {
        ModEnchantments.getEnchantments().values().stream().filter(TombstoneEnchantment::isEnabled).forEach(enchant -> IntStream.rangeClosed(1, Math.min(5, enchant.m_6586_())).forEach(lvl -> items.m_246342_(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance((Enchantment)enchant, lvl)))));
    }
}

