/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BookCategoryModel {
    protected BookModel book;
    protected ResourceLocation id;
    protected String name;
    protected String icon;
    protected int sortNumber = -1;
    protected ResourceLocation background = new ResourceLocation(ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND);
    protected ResourceLocation entryTextures = new ResourceLocation(ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES);
    protected List<BookEntryModel> entries = new ArrayList<BookEntryModel>();
    protected BookConditionModel condition;
    protected boolean showCategoryButton = true;

    private BookCategoryModel() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public BookConditionModel getCondition() {
        return this.condition;
    }

    public boolean isShowCategoryButton() {
        return this.showCategoryButton;
    }

    public List<BookEntryModel> getEntries() {
        return this.entries;
    }

    public BookModel getBook() {
        return this.book;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.name);
        json.addProperty("icon", this.icon);
        json.addProperty("sort_number", (Number)this.sortNumber);
        json.addProperty("background", this.background.toString());
        json.addProperty("entry_textures", this.entryTextures.toString());
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson());
        }
        json.addProperty("show_category_button", Boolean.valueOf(this.showCategoryButton));
        return json;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getSortNumber() {
        return this.sortNumber;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public ResourceLocation getEntryTextures() {
        return this.entryTextures;
    }

    public static final class Builder {
        private final List<BookEntryModel> entries = new ArrayList<BookEntryModel>();
        private BookModel book;
        private ResourceLocation id;
        private String name;
        private String icon;
        private int sortNumber = -1;
        private ResourceLocation background = new ResourceLocation(ModonomiconConstants.Data.Category.DEFAULT_BACKGROUND);
        private ResourceLocation entryTextures = new ResourceLocation(ModonomiconConstants.Data.Category.DEFAULT_ENTRY_TEXTURES);
        private BookConditionModel condition;
        private boolean showCategoryButton = true;

        private Builder() {
        }

        public Builder withBook(BookModel book) {
            this.book = book;
            return this;
        }

        public Builder withId(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder withIcon(ItemLike item) {
            this.icon = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).toString();
            return this;
        }

        public Builder withSortNumber(int sortNumber) {
            this.sortNumber = sortNumber;
            return this;
        }

        public Builder withBackground(ResourceLocation background) {
            this.background = background;
            return this;
        }

        public Builder withEntryTextures(ResourceLocation entryTextures) {
            this.entryTextures = entryTextures;
            return this;
        }

        public Builder withEntries(List<BookEntryModel> entries) {
            this.entries.addAll(entries);
            return this;
        }

        public Builder withEntries(BookEntryModel ... entries) {
            this.entries.addAll(List.of(entries));
            return this;
        }

        public Builder withEntry(BookEntryModel entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder withCondition(BookConditionModel condition) {
            this.condition = condition;
            return this;
        }

        public Builder withShowCategoryButton(boolean showCategoryButton) {
            this.showCategoryButton = showCategoryButton;
            return this;
        }

        public BookCategoryModel build() {
            BookCategoryModel bookCategoryModel = new BookCategoryModel();
            for (BookEntryModel entry : this.entries) {
                entry.category = bookCategoryModel;
                if (entry.id.m_135815_().startsWith(this.id.m_135815_())) continue;
                entry.id = new ResourceLocation(entry.id.m_135827_(), this.id.m_135815_() + "/" + entry.id.m_135815_());
            }
            bookCategoryModel.book = this.book;
            bookCategoryModel.icon = this.icon;
            bookCategoryModel.entryTextures = this.entryTextures;
            bookCategoryModel.background = this.background;
            bookCategoryModel.id = this.id;
            bookCategoryModel.entries = this.entries;
            bookCategoryModel.name = this.name;
            bookCategoryModel.sortNumber = this.sortNumber;
            bookCategoryModel.condition = this.condition;
            bookCategoryModel.showCategoryButton = this.showCategoryButton;
            return bookCategoryModel;
        }

        public BookModel getBook() {
            return this.book;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getIcon() {
            return this.icon;
        }

        public int getSortNumber() {
            return this.sortNumber;
        }

        public ResourceLocation getBackground() {
            return this.background;
        }

        public ResourceLocation getEntryTextures() {
            return this.entryTextures;
        }

        public List<BookEntryModel> getEntries() {
            return this.entries;
        }

        public BookConditionModel getCondition() {
            return this.condition;
        }

        public boolean isShowCategoryButton() {
            return this.showCategoryButton;
        }
    }
}

