/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryParentModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookPageModel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.registries.ForgeRegistries;

public class BookEntryModel {
    protected ResourceLocation id;
    protected BookCategoryModel category;
    protected List<BookEntryParentModel> parents = new ArrayList<BookEntryParentModel>();
    protected String name;
    protected String description = "";
    protected String icon;
    protected int x;
    protected int y;
    protected int entryBackgroundUIndex = 0;
    protected int entryBackgroundVIndex = 0;
    protected boolean hideWhileLocked;
    protected List<BookPageModel> pages = new ArrayList<BookPageModel>();
    protected BookConditionModel condition;
    protected ResourceLocation categoryToOpen;

    public static Builder builder() {
        return new Builder();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("category", this.category.id.toString());
        json.addProperty("name", this.name);
        json.addProperty("description", this.description);
        json.addProperty("icon", this.icon);
        json.addProperty("x", (Number)this.x);
        json.addProperty("y", (Number)this.y);
        json.addProperty("background_u_index", (Number)this.entryBackgroundUIndex);
        json.addProperty("background_v_index", (Number)this.entryBackgroundVIndex);
        json.addProperty("hide_while_locked", Boolean.valueOf(this.hideWhileLocked));
        if (!this.parents.isEmpty()) {
            JsonArray parentsArray = new JsonArray();
            for (BookEntryParentModel parent : this.parents) {
                parentsArray.add((JsonElement)parent.toJson());
            }
            json.add("parents", (JsonElement)parentsArray);
        }
        if (!this.pages.isEmpty()) {
            JsonArray pagesArray = new JsonArray();
            for (BookPageModel page : this.pages) {
                pagesArray.add((JsonElement)page.toJson());
            }
            json.add("pages", (JsonElement)pagesArray);
        }
        if (this.condition != null) {
            json.add("condition", (JsonElement)this.condition.toJson());
        }
        if (this.categoryToOpen != null) {
            json.addProperty("category_to_open", this.categoryToOpen.toString());
        }
        return json;
    }

    public int getEntryBackgroundUIndex() {
        return this.entryBackgroundUIndex;
    }

    public int getEntryBackgroundVIndex() {
        return this.entryBackgroundVIndex;
    }

    public BookConditionModel getCondition() {
        return this.condition;
    }

    public ResourceLocation getCategoryToOpen() {
        return this.categoryToOpen;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public BookCategoryModel getCategory() {
        return this.category;
    }

    public List<BookEntryParentModel> getParents() {
        return this.parents;
    }

    public void addParent(BookEntryParentModel parent) {
        this.parents.add(parent);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isHideWhileLocked() {
        return this.hideWhileLocked;
    }

    public List<BookPageModel> getPages() {
        return this.pages;
    }

    public static final class Builder {
        public ResourceLocation id;
        public BookCategoryModel category;
        public List<BookEntryParentModel> parents = new ArrayList<BookEntryParentModel>();
        public String name;
        public String description = "";
        public String icon;
        public int x;
        public int y;
        public boolean hideWhileLocked;
        public List<BookPageModel> pages = new ArrayList<BookPageModel>();
        public BookConditionModel condition;
        private int entryBackgroundUIndex = 0;
        private int entryBackgroundVIndex = 0;
        private ResourceLocation categoryToOpen;

        private Builder() {
        }

        public Builder withId(ResourceLocation id) {
            this.id = id;
            return this;
        }

        public Builder withCategory(BookCategoryModel category) {
            this.category = category;
            return this;
        }

        public Builder withParents(List<BookEntryParentModel> parents) {
            this.parents = parents;
            return this;
        }

        public Builder withParents(BookEntryParentModel ... parents) {
            this.parents.addAll(List.of(parents));
            return this;
        }

        public Builder withParent(BookEntryParentModel parent) {
            this.parents.add(parent);
            return this;
        }

        public Builder withParent(BookEntryModel parent) {
            this.parents.add(BookEntryParentModel.builder().withEntryId(parent.id).build());
            return this;
        }

        public Builder withParent(Builder parent) {
            this.parents.add(BookEntryParentModel.builder().withEntryId(parent.id).build());
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withIcon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder withIcon(ItemLike item) {
            this.icon = ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()).toString();
            return this;
        }

        public Builder withLocation(Vec2 location) {
            return this.withX((int)location.f_82470_).withY((int)location.f_82471_);
        }

        public Builder withLocation(int x, int y) {
            return this.withX(x).withY(y);
        }

        public Builder withX(int x) {
            this.x = x;
            return this;
        }

        public Builder withY(int y) {
            this.y = y;
            return this;
        }

        public Builder withEntryBackground(int u, int v) {
            this.entryBackgroundUIndex = u;
            this.entryBackgroundVIndex = v;
            return this;
        }

        public Builder hideWhileLocked(boolean hideWhileLocked) {
            this.hideWhileLocked = hideWhileLocked;
            return this;
        }

        public Builder withPages(List<BookPageModel> pages) {
            this.pages = pages;
            return this;
        }

        public Builder withPages(BookPageModel ... pages) {
            this.pages.addAll(List.of(pages));
            return this;
        }

        public Builder withPage(BookPageModel page) {
            this.pages.add(page);
            return this;
        }

        public Builder withCondition(BookConditionModel condition) {
            this.condition = condition;
            return this;
        }

        public Builder withCategoryToOpen(ResourceLocation categoryToOpen) {
            this.categoryToOpen = categoryToOpen;
            return this;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public BookCategoryModel getCategory() {
            return this.category;
        }

        public List<BookEntryParentModel> getParents() {
            return this.parents;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIcon() {
            return this.icon;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getEntryBackgroundUIndex() {
            return this.entryBackgroundUIndex;
        }

        public int getEntryBackgroundVIndex() {
            return this.entryBackgroundVIndex;
        }

        public boolean isHideWhileLocked() {
            return this.hideWhileLocked;
        }

        public List<BookPageModel> getPages() {
            return this.pages;
        }

        public BookConditionModel getCondition() {
            return this.condition;
        }

        public ResourceLocation getCategoryToOpen() {
            return this.categoryToOpen;
        }

        public BookEntryModel build() {
            BookEntryModel bookEntryModel = new BookEntryModel();
            bookEntryModel.description = this.description;
            bookEntryModel.category = this.category;
            bookEntryModel.name = this.name;
            bookEntryModel.icon = this.icon;
            bookEntryModel.x = this.x;
            bookEntryModel.y = this.y;
            bookEntryModel.entryBackgroundUIndex = this.entryBackgroundUIndex;
            bookEntryModel.entryBackgroundVIndex = this.entryBackgroundVIndex;
            bookEntryModel.hideWhileLocked = this.hideWhileLocked;
            bookEntryModel.parents = this.parents;
            bookEntryModel.id = this.id;
            bookEntryModel.pages = this.pages;
            bookEntryModel.condition = this.condition;
            bookEntryModel.categoryToOpen = this.categoryToOpen;
            return bookEntryModel;
        }
    }
}

