/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Triple;

public class Book {
    protected ResourceLocation id;
    protected String name;
    protected String tooltip;
    protected String creativeTab;
    protected ResourceLocation model;
    protected ResourceLocation bookOverviewTexture;
    protected ResourceLocation bookContentTexture;
    protected ResourceLocation craftingTexture;
    protected ResourceLocation turnPageSound;
    protected ConcurrentMap<ResourceLocation, BookCategory> categories;
    protected ConcurrentMap<ResourceLocation, BookEntry> entries;
    protected int defaultTitleColor;
    protected boolean autoAddReadConditions;
    protected boolean generateBookItem;
    protected ResourceLocation customBookItem;
    protected Supplier<ItemStack> bookItem = Suppliers.memoize(() -> {
        if (this.customBookItem != null) {
            Triple<ResourceLocation, Integer, CompoundTag> parsed = ItemStackUtil.parseItemStackString(this.customBookItem.toString());
            return ItemStackUtil.loadFromParsed(parsed);
        }
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MODONOMICON.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("modonomicon:book_id", this.id.toString());
        stack.m_41751_(tag);
        return stack;
    });

    public Book(ResourceLocation id, String name, String tooltip, ResourceLocation model, boolean generateBookItem, ResourceLocation customBookItem, String creativeTab, ResourceLocation bookOverviewTexture, ResourceLocation bookContentTexture, ResourceLocation craftingTexture, ResourceLocation turnPageSound, int defaultTitleColor, boolean autoAddReadConditions) {
        this.id = id;
        this.name = name;
        this.tooltip = tooltip;
        this.model = model;
        this.generateBookItem = generateBookItem;
        this.customBookItem = customBookItem;
        this.creativeTab = creativeTab;
        this.bookOverviewTexture = bookOverviewTexture;
        this.bookContentTexture = bookContentTexture;
        this.craftingTexture = craftingTexture;
        this.turnPageSound = turnPageSound;
        this.defaultTitleColor = defaultTitleColor;
        this.autoAddReadConditions = autoAddReadConditions;
        this.categories = new ConcurrentHashMap<ResourceLocation, BookCategory>();
        this.entries = new ConcurrentHashMap<ResourceLocation, BookEntry>();
    }

    public static Book fromJson(ResourceLocation id, JsonObject json) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        String tooltip = GsonHelper.m_13851_((JsonObject)json, (String)"tooltip", (String)"");
        ResourceLocation model = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"model", (String)ModonomiconConstants.Data.Book.DEFAULT_MODEL));
        boolean generateBookItem = GsonHelper.m_13855_((JsonObject)json, (String)"generate_book_item", (boolean)true);
        ResourceLocation customBookItem = json.has("custom_book_item") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"custom_book_item")) : null;
        String creativeTab = GsonHelper.m_13851_((JsonObject)json, (String)"creative_tab", (String)"misc");
        ResourceLocation bookOverviewTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"book_overview_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_OVERVIEW_TEXTURE));
        ResourceLocation bookContentTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"book_content_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CONTENT_TEXTURE));
        ResourceLocation craftingTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"crafting_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CRAFTING_TEXTURE));
        ResourceLocation turnPageSound = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"turn_page_sound", (String)ModonomiconConstants.Data.Book.DEFAULT_PAGE_TURN_SOUND));
        int defaultTitleColor = GsonHelper.m_13824_((JsonObject)json, (String)"default_title_color", (int)0);
        boolean autoAddReadConditions = GsonHelper.m_13855_((JsonObject)json, (String)"auto_add_read_conditions", (boolean)false);
        return new Book(id, name, tooltip, model, generateBookItem, customBookItem, creativeTab, bookOverviewTexture, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, autoAddReadConditions);
    }

    public static Book fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        String tooltip = buffer.m_130277_();
        ResourceLocation model = buffer.m_130281_();
        boolean generateBookItem = buffer.readBoolean();
        ResourceLocation customBookItem = buffer.readBoolean() ? buffer.m_130281_() : null;
        String creativeTab = buffer.m_130277_();
        ResourceLocation bookOverviewTexture = buffer.m_130281_();
        ResourceLocation bookContentTexture = buffer.m_130281_();
        ResourceLocation craftingTexture = buffer.m_130281_();
        ResourceLocation turnPageSound = buffer.m_130281_();
        int defaultTitleColor = buffer.readInt();
        boolean autoAddReadConditions = buffer.readBoolean();
        return new Book(id, name, tooltip, model, generateBookItem, customBookItem, creativeTab, bookOverviewTexture, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, autoAddReadConditions);
    }

    public ItemStack getBookItem() {
        return this.bookItem.get();
    }

    public boolean autoAddReadConditions() {
        return this.autoAddReadConditions;
    }

    public ResourceLocation getTurnPageSound() {
        return this.turnPageSound;
    }

    public void build() {
        for (BookCategory category : this.categories.values()) {
            for (BookEntry entry : category.getEntries().values()) {
                this.addEntry(entry);
            }
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.build(this);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
    }

    public int getDefaultTitleColor() {
        return this.defaultTitleColor;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void addCategory(BookCategory category) {
        this.categories.putIfAbsent(category.id, category);
    }

    public BookCategory getCategory(ResourceLocation id) {
        return (BookCategory)this.categories.get(id);
    }

    public Map<ResourceLocation, BookCategory> getCategories() {
        return this.categories;
    }

    public List<BookCategory> getCategoriesSorted() {
        return this.categories.values().stream().sorted(Comparator.comparingInt(BookCategory::getSortNumber)).toList();
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.id, entry);
    }

    public BookEntry getEntry(ResourceLocation id) {
        return (BookEntry)this.entries.get(id);
    }

    public Map<ResourceLocation, BookEntry> getEntries() {
        return this.entries;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.bookOverviewTexture;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.m_130070_(this.tooltip);
        buffer.m_130085_(this.model);
        buffer.writeBoolean(this.generateBookItem);
        buffer.writeBoolean(this.customBookItem != null);
        if (this.customBookItem != null) {
            buffer.m_130085_(this.customBookItem);
        }
        buffer.m_130070_(this.creativeTab);
        buffer.m_130085_(this.bookOverviewTexture);
        buffer.m_130085_(this.bookContentTexture);
        buffer.m_130085_(this.craftingTexture);
        buffer.m_130085_(this.turnPageSound);
        buffer.writeInt(this.defaultTitleColor);
        buffer.writeBoolean(this.autoAddReadConditions);
    }

    public ResourceLocation getCustomBookItem() {
        return this.customBookItem;
    }

    public ResourceLocation getCraftingTexture() {
        return this.craftingTexture;
    }

    public ResourceLocation getBookContentTexture() {
        return this.bookContentTexture;
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public boolean generateBookItem() {
        return this.generateBookItem;
    }
}

