/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.client.gui.book;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.error.BookErrorHolder;
import com.klikli_dev.modonomicon.book.error.BookErrorInfo;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class BookErrorScreen
extends Screen {
    public static final int BOOK_BACKGROUND_WIDTH = 272;
    public static final int BOOK_BACKGROUND_HEIGHT = 178;
    private static final ResourceLocation BOOK_CONTENT_TEXTURE = new ResourceLocation("modonomicon", "textures/gui/book_content.png");
    private final Book book;
    private int bookLeft;
    private int bookTop;
    private Component errorText;

    public BookErrorScreen(Book book) {
        super((Component)Component.m_237113_((String)""));
        this.book = book;
        this.f_96541_ = Minecraft.m_91087_();
    }

    public void renderBookBackground(PoseStack poseStack) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BOOK_CONTENT_TEXTURE);
        int x = 0;
        int y = 0;
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)272, (int)178, (int)512, (int)256);
    }

    public void renderError(Component text, PoseStack pPoseStack, int x, int y, int width) {
        for (FormattedCharSequence formattedcharsequence : this.f_96547_.m_92923_((FormattedText)text, width)) {
            this.f_96547_.m_92877_(pPoseStack, formattedcharsequence, (float)x, (float)y, 0);
            Objects.requireNonNull(this.f_96547_);
            y += 9;
        }
    }

    public void prepareError() {
        BookErrorHolder errorHolder = BookErrorManager.get().getErrors(this.book.getId());
        if (errorHolder.getErrors().isEmpty()) {
            this.errorText = Component.m_237115_((String)"modonomicon.gui.no_errors_found");
            Modonomicon.LOGGER.warn("No errors found for book {}, but error screen was opened!", (Object)this.book.getId());
        } else {
            BookErrorInfo firstError = errorHolder.getErrors().get(0);
            Object errorString = firstError.toString();
            if (errorHolder.getErrors().size() > 1) {
                errorString = (String)errorString + "\n\n(" + (errorHolder.getErrors().size() - 1) + " more errors, see log)";
            }
            this.errorText = Component.m_237113_((String)errorString);
        }
    }

    public void m_86412_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        pPoseStack.m_85836_();
        pPoseStack.m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderBookBackground(pPoseStack);
        pPoseStack.m_85849_();
        super.m_86412_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        pPoseStack.m_85836_();
        pPoseStack.m_252880_((float)this.bookLeft, (float)this.bookTop, 0.0f);
        this.renderError(this.errorText, pPoseStack, 15, 15, 242);
        pPoseStack.m_85849_();
    }

    public boolean m_6913_() {
        return true;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.bookLeft = (this.f_96543_ - 272) / 2;
        this.bookTop = (this.f_96544_ - 178) / 2;
        this.prepareError();
    }
}

