/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.registry;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.capability.BookStateCapability;
import com.klikli_dev.modonomicon.capability.BookUnlockCapability;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class CapabilityRegistry {
    public static final ResourceLocation BOOK_UNLOCK_ID = Modonomicon.loc("book_unlock");
    public static final ResourceLocation BOOK_STATE_ID = Modonomicon.loc("book_state");
    public static Capability<BookUnlockCapability> BOOK_UNLOCK = CapabilityManager.get((CapabilityToken)new CapabilityToken<BookUnlockCapability>(){});
    public static Capability<BookStateCapability> BOOK_STATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<BookStateCapability>(){});

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(BookUnlockCapability.class);
        event.register(BookStateCapability.class);
    }

    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getEntity().getCapability(BOOK_UNLOCK).ifPresent(newCap -> event.getOriginal().getCapability(BOOK_UNLOCK).ifPresent(newCap::clone));
            event.getEntity().getCapability(BOOK_STATE).ifPresent(newCap -> event.getOriginal().getCapability(BOOK_STATE).ifPresent(newCap::clone));
        }
    }

    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            if (!((Entity)event.getObject()).getCapability(BOOK_UNLOCK).isPresent()) {
                event.addCapability(BOOK_UNLOCK_ID, (ICapabilityProvider)new BookUnlockCapability.Dispatcher());
            }
            if (!((Entity)event.getObject()).getCapability(BOOK_STATE).isPresent()) {
                event.addCapability(BOOK_STATE_ID, (ICapabilityProvider)new BookStateCapability.Dispatcher());
            }
        }
    }

    public static void onJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BookUnlockCapability.updateAndSyncFor(player);
            BookStateCapability.syncFor(player);
        }
    }
}

