/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class ItemStackUtil {
    public static Triple<ResourceLocation, Integer, CompoundTag> parseItemStackString(String res) {
        String[] tokens;
        String nbt = "";
        int nbtStart = res.indexOf("{");
        if (nbtStart > 0) {
            nbt = res.substring(nbtStart).replaceAll("([^\\\\])'", "$1\"").replaceAll("\\\\'", "'");
            res = res.substring(0, nbtStart);
        }
        String[] upper = res.split("#");
        String count = "1";
        if (upper.length > 1) {
            res = upper[0];
            count = upper[1];
        }
        if ((tokens = res.split(":")).length < 2) {
            throw new RuntimeException("Malformed item ID " + res);
        }
        ResourceLocation key = new ResourceLocation(tokens[0], tokens[1]);
        int countn = Integer.parseInt(count);
        CompoundTag tag = null;
        if (!nbt.isEmpty()) {
            try {
                tag = TagParser.m_129359_((String)nbt);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException("Failed to parse ItemStack JSON", e);
            }
        }
        return ImmutableTriple.of((Object)key, (Object)countn, (Object)tag);
    }

    public static ItemStack loadFromParsed(Triple<ResourceLocation, Integer, CompoundTag> parsed) {
        ResourceLocation key = (ResourceLocation)parsed.getLeft();
        Integer count = (Integer)parsed.getMiddle();
        CompoundTag nbt = (CompoundTag)parsed.getRight();
        Item item = (Item)ForgeRegistries.ITEMS.getValue(key);
        if (item == null) {
            throw new RuntimeException("Unknown item ID: " + key);
        }
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
        if (nbt != null) {
            stack.m_41751_(nbt);
        }
        return stack;
    }
}

