/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.relocated.commonmark.internal.inline;

import com.klikli_dev.relocated.commonmark.node.Emphasis;
import com.klikli_dev.relocated.commonmark.node.Node;
import com.klikli_dev.relocated.commonmark.node.Nodes;
import com.klikli_dev.relocated.commonmark.node.SourceSpans;
import com.klikli_dev.relocated.commonmark.node.StrongEmphasis;
import com.klikli_dev.relocated.commonmark.node.Text;
import com.klikli_dev.relocated.commonmark.parser.delimiter.DelimiterProcessor;
import com.klikli_dev.relocated.commonmark.parser.delimiter.DelimiterRun;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;

    protected EmphasisDelimiterProcessor(char delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        Node emphasis;
        int usedDelimiters;
        if ((openingRun.canClose() || closingRun.canOpen()) && closingRun.originalLength() % 3 != 0 && (openingRun.originalLength() + closingRun.originalLength()) % 3 == 0) {
            return 0;
        }
        if (openingRun.length() >= 2 && closingRun.length() >= 2) {
            usedDelimiters = 2;
            emphasis = new StrongEmphasis(String.valueOf(this.delimiterChar) + this.delimiterChar);
        } else {
            usedDelimiters = 1;
            emphasis = new Emphasis(String.valueOf(this.delimiterChar));
        }
        SourceSpans sourceSpans = SourceSpans.empty();
        sourceSpans.addAllFrom(openingRun.getOpeners(usedDelimiters));
        Text opener = openingRun.getOpener();
        for (Node node : Nodes.between(opener, closingRun.getCloser())) {
            emphasis.appendChild(node);
            sourceSpans.addAll(node.getSourceSpans());
        }
        sourceSpans.addAllFrom(closingRun.getClosers(usedDelimiters));
        emphasis.setSourceSpans(sourceSpans.getSourceSpans());
        opener.insertAfter(emphasis);
        return usedDelimiters;
    }
}

