/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.BlueSkiesScheduler;
import com.legacy.blue_skies.MLSupporter;
import com.legacy.blue_skies.assets.BlueSkiesAssets;
import com.legacy.blue_skies.blocks.util.Composting;
import com.legacy.blue_skies.blocks.util.DispenserBehaviors;
import com.legacy.blue_skies.blocks.util.Flammability;
import com.legacy.blue_skies.blocks.util.MapColors;
import com.legacy.blue_skies.blocks.util.ToolCompat;
import com.legacy.blue_skies.capability.util.ISkiesPlayer;
import com.legacy.blue_skies.client.IncompatHandler;
import com.legacy.blue_skies.client.audio.SkiesMusicHandler;
import com.legacy.blue_skies.client.events.SkiesClientEvents;
import com.legacy.blue_skies.client.gui.screen.AlchemyTableScreen;
import com.legacy.blue_skies.client.gui.screen.ArcsScreen;
import com.legacy.blue_skies.client.gui.screen.BagOfSpoilsScreen;
import com.legacy.blue_skies.client.gui.screen.FoodPrepScreen;
import com.legacy.blue_skies.client.gui.screen.HorizoniteForgeScreen;
import com.legacy.blue_skies.client.gui.screen.MountInventoryScreen;
import com.legacy.blue_skies.client.gui.screen.SnowcapOvenScreen;
import com.legacy.blue_skies.client.gui.screen.SummoningTableScreen;
import com.legacy.blue_skies.client.gui.screen.ToolboxScreen;
import com.legacy.blue_skies.client.init.SkiesAtlases;
import com.legacy.blue_skies.client.init.SkiesBlockLayers;
import com.legacy.blue_skies.client.init.SkiesBlockModels;
import com.legacy.blue_skies.client.init.SkiesItemModelPredicates;
import com.legacy.blue_skies.client.init.SkiesResourcePackHandler;
import com.legacy.blue_skies.commands.BlueSkiesCommand;
import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.data.BlueSkiesDataGen;
import com.legacy.blue_skies.data.objects.tags.SkiesBlockTags;
import com.legacy.blue_skies.data.objects.tags.SkiesEntityTags;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import com.legacy.blue_skies.events.SkiesEvents;
import com.legacy.blue_skies.events.SkiesMappingChanges;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.blue_skies.items.util.FoodPrepUtils;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.registries.SkiesBiomeModifiers;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.registries.SkiesStats;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.registries.SkiesTriggers;
import com.legacy.blue_skies.registries.SkiesWoodTypes;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="blue_skies")
public class BlueSkies {
    public static final String MODID = "blue_skies";
    public static final Logger LOGGER = LogManager.getLogger((String)"ModdingLegacy/blue_skies");
    public static final MLSupporter ML_SUPPORTER = new MLSupporter("blue_skies");
    private static final BlueSkiesScheduler SCHEDULER = new BlueSkiesScheduler();
    protected static boolean isChristmas = false;
    protected static boolean isHalloween = false;
    private static final boolean INDEV = false;
    public static final boolean IDE = BlueSkies.isRunningFromIDE();

    public BlueSkies() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BlueSkiesConfig.COMMON_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> SCHEDULER.start(forgeBus));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            SCHEDULER.runChecks();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BlueSkiesConfig.CLIENT_SPEC);
            BlueSkiesAssets.init();
            modBus.addListener(BlueSkies::clientInit);
            modBus.addListener(SkiesBlockModels::modelRegistry);
            modBus.addListener(SkiesBlockModels::onModelBake);
            modBus.addListener(SkiesResourcePackHandler::packRegistry);
            modBus.addListener(SkiesClientEvents::registerOverlays);
            modBus.addListener(SkiesClientEvents::initDimensionRenderInfo);
            modBus.addListener(SkiesParticles.Register::registerParticleFactories);
            forgeBus.register(SkiesMusicHandler.class);
            forgeBus.register(SkiesClientEvents.class);
        });
        SkiesBlockTags.init();
        SkiesItemTags.init();
        SkiesEntityTags.init();
        SkiesStructures.init();
        SkiesDimensions.init();
        RegistrarHandler.registerHandlers((String)MODID, (IEventBus)modBus, (RegistrarHandler[])new RegistrarHandler[]{SkiesPoiTypes.HANDLER, SkiesStructures.ProcessorLists.HANDLER, SkiesBiomes.HANDLER, SkiesBiomeModifiers.SERIALIZER_HANDLER, SkiesConfiguredCarvers.HANDLER});
        modBus.addListener(BlueSkies::commonInit);
        modBus.addListener(SkiesEntityTypes::onAttributesRegistered);
        modBus.register(SkiesRegistry.class);
        modBus.register(BlueSkiesDataGen.class);
        forgeBus.addListener(BlueSkies::onCommandsRegistered);
        forgeBus.addListener(BlueSkies::onCapsRegistered);
        forgeBus.addListener(BlueSkiesData::addListeners);
        forgeBus.register(SkiesEvents.class);
        forgeBus.register(SkiesPlayerEvents.class);
        forgeBus.register(SkiesMappingChanges.class);
    }

    public static ResourceLocation locate(String key) {
        return new ResourceLocation(MODID, key);
    }

    public static String find(String key) {
        return "blue_skies:" + key;
    }

    public static void commonInit(FMLCommonSetupEvent event) {
        if (BlueSkies.isRunningFromIDE()) {
            LOGGER.warn("Blue Skies is being run from an IDE or via Gradle.");
            LOGGER.warn("If you are planning to make a contribution to Blue Skies, please refer to the LICENSE.md file at the root directory of this repository.");
        } else if (BlueSkies.isIndevBuild()) {
            LOGGER.warn("This is an indev build of Blue Skies. Do NOT expect support with it! Things WILL break. Treat it like a Minecraft snapshot version!");
        }
        event.enqueueWork(() -> {
            SkiesStats.init();
            SkiesTriggers.init();
            DispenserBehaviors.init();
            Composting.init();
            MapColors.init();
            Flammability.init();
        });
        ToolCompat.init();
        PacketHandler.register();
        BlueSkiesData.addSyncedListeners();
    }

    public static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            MenuScreens.m_96206_(SkiesContainers.ARC_INVENTORY, ArcsScreen::new);
            MenuScreens.m_96206_(SkiesContainers.MOUNT_INVENTORY, MountInventoryScreen::new);
            MenuScreens.m_96206_(SkiesContainers.HORIZONITE_FORGE, HorizoniteForgeScreen::new);
            MenuScreens.m_96206_(SkiesContainers.SNOWCAP_OVEN, SnowcapOvenScreen::new);
            MenuScreens.m_96206_(SkiesContainers.SUMMONING_TABLE, SummoningTableScreen::new);
            MenuScreens.m_96206_(SkiesContainers.ALCHEMY_TABLE, AlchemyTableScreen::new);
            MenuScreens.m_96206_(SkiesContainers.TOOLBOX, ToolboxScreen::new);
            MenuScreens.m_96206_(SkiesContainers.FOOD_PREP_TABLE, FoodPrepScreen::new);
            MenuScreens.m_96206_(SkiesContainers.BAG_OF_SPOILS, BagOfSpoilsScreen::new);
            SkiesWoodTypes.init();
            SkiesAtlases.initWoodTypes();
            SkiesBlockLayers.init();
            SkiesItemModelPredicates.init();
        });
        SkiesClientEvents.Panoramas.registerPanoramas();
        FoodPrepUtils.FoodColor.setupColors();
        IncompatHandler.initStartup();
    }

    public static void onCommandsRegistered(RegisterCommandsEvent event) {
        BlueSkiesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static void onCapsRegistered(RegisterCapabilitiesEvent event) {
        event.register(ISkiesPlayer.class);
    }

    private static boolean isRunningFromIDE() {
        String p = System.getProperty(String.format("%s.iside", MODID));
        return Boolean.parseBoolean(p);
    }

    public static Logger makeLogger(Class<?> containerClass) {
        return LogManager.getLogger((String)("ModdingLegacy/blue_skies/" + containerClass.getSimpleName()));
    }

    public static boolean isIndevBuild() {
        return IDE;
    }

    public static void printStackTrace() {
        if (IDE) {
            StackTraceElement[] stackArray = Thread.currentThread().getStackTrace();
            System.out.println("---------- Stack Trace ----------");
            for (StackTraceElement stack : stackArray) {
                System.out.println(stack.getClassName() + " " + stack.getMethodName() + " " + stack.getLineNumber());
            }
        }
    }
}

