/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.menu;

import com.legacy.blue_skies.items.util.FoodPrepUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesContainers;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesTriggers;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FoodPrepMenu
extends AbstractContainerMenu {
    private final Container inputInventory = new SimpleContainer(5){

        public void m_6596_() {
            super.m_6596_();
            FoodPrepMenu.this.m_6199_((Container)this);
            FoodPrepMenu.this.inventoryUpdateListener.run();
        }
    };
    private final Container outputInventory = new SimpleContainer(1);
    private final ContainerLevelAccess worldPosCallable;
    private final List<Slot> inputSlots = new ArrayList<Slot>();
    private final Slot outputSlot;
    private Runnable inventoryUpdateListener = () -> {};
    private long lastOnTake;

    public FoodPrepMenu(int id, Inventory playerInv) {
        this(id, playerInv, ContainerLevelAccess.f_39287_);
    }

    public FoodPrepMenu(int id, Inventory playerInv, final ContainerLevelAccess worldPos) {
        super(SkiesContainers.FOOD_PREP_TABLE, id);
        int i;
        this.worldPosCallable = worldPos;
        for (i = 0; i < 5; ++i) {
            this.inputSlots.add(this.m_38897_(new Slot(this.inputInventory, i, 44 + 18 * i, 18)));
        }
        this.outputSlot = this.m_38897_(new Slot(this.outputInventory, 0, 80, 53){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                if (player instanceof ServerPlayer) {
                    SkiesTriggers.USED_FOOD_PREP.trigger((ServerPlayer)player);
                }
                stack.m_41678_(player.f_19853_, player, stack.m_41613_());
                for (int i = 0; i < FoodPrepMenu.this.inputSlots.size(); ++i) {
                    this.reduceStack(FoodPrepMenu.this.inputSlots.get(i));
                }
                FoodPrepMenu.this.updateOutputSlot();
                worldPos.m_39292_((world, pos) -> {
                    long time = world.m_46467_();
                    if (FoodPrepMenu.this.lastOnTake != time) {
                        world.m_5594_((Player)null, pos, SkiesSounds.BLOCK_FOOD_PREP_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                        FoodPrepMenu.this.lastOnTake = time;
                    }
                });
                this.m_6654_();
            }

            private ItemStack reduceStack(Slot slot) {
                if (slot.m_6657_()) {
                    ItemStack stack = slot.m_7993_();
                    ItemStack containerItem = null;
                    if (stack.m_41720_() == Items.f_42589_) {
                        containerItem = new ItemStack((ItemLike)Items.f_42590_);
                    } else if (stack.m_41720_() instanceof BowlFoodItem || stack.m_41720_() instanceof SuspiciousStewItem) {
                        containerItem = new ItemStack((ItemLike)Items.f_42399_);
                    } else if (stack.hasCraftingRemainingItem()) {
                        containerItem = stack.getCraftingRemainingItem();
                    }
                    if (containerItem != null) {
                        if (stack.m_41613_() == 1) {
                            slot.m_5852_(containerItem);
                            return containerItem;
                        }
                        FoodPrepMenu.this.m_38903_(stack.getCraftingRemainingItem(), 6, 42, false);
                    }
                    return slot.m_6201_(1);
                }
                return ItemStack.f_41583_;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInv, i, 8 + i * 18, 142));
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.worldPosCallable.m_39292_((world, pos) -> this.m_150411_(player, this.inputInventory));
    }

    public boolean m_6875_(Player player) {
        return FoodPrepMenu.m_38889_((ContainerLevelAccess)this.worldPosCallable, (Player)player, (Block)SkiesBlocks.food_prep_table);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack slotStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int containerSize = 6;
            ItemStack stackInSlot = slot.m_7993_();
            Item itemInSlot = stackInSlot.m_41720_();
            slotStack = stackInSlot.m_41777_();
            if (index == containerSize - 1) {
                itemInSlot.m_7836_(stackInSlot, player.f_19853_, player);
                if (!this.m_38903_(stackInSlot, containerSize, containerSize + 36, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stackInSlot, slotStack);
            } else if (index >= 0 && index <= containerSize - 2) {
                if (!this.m_38903_(stackInSlot, containerSize, containerSize + 36, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!this.m_38903_(stackInSlot, 0, containerSize - 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (index >= containerSize && index < containerSize + 27 ? !this.m_38903_(stackInSlot, containerSize + 27, containerSize + 36, false) : index >= containerSize + 27 && index < containerSize + 36 && !this.m_38903_(stackInSlot, containerSize, containerSize + 27, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (stackInSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (stackInSlot.m_41613_() == slotStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stackInSlot);
            this.m_38946_();
        }
        return slotStack;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return slotIn != this.outputSlot && super.m_5882_(stack, slotIn);
    }

    public void m_6199_(Container inventory) {
        this.updateOutputSlot();
    }

    public boolean m_6366_(Player playerIn, int id) {
        this.updateOutputSlot();
        return true;
    }

    private void updateOutputSlot() {
        this.outputSlot.m_5852_(FoodPrepUtils.createFood(this.inputInventory));
        this.m_38946_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInventoryUpdateListener(Runnable listener) {
        this.inventoryUpdateListener = listener;
    }
}

