/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.client.gui.menu.AlchemyTableMenu;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class AlchemyTableScreen
extends AbstractContainerScreen<AlchemyTableMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = BlueSkies.locate("textures/gui/alchemy_table.png");
    private float sliderProgress;
    private boolean clickedOnSroll;
    private int recipeIndexOffset;
    private boolean hasItemsInInputSlot;

    public AlchemyTableScreen(AlchemyTableMenu screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        screenContainer.setInventoryUpdateListener(this::onInventoryUpdate);
        --this.f_97729_;
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
        SkiesClientUtil.bind(BACKGROUND_TEXTURE);
        int left = this.f_97735_;
        int top = this.f_97736_;
        this.m_93228_(matrixStack, left, top, 0, 0, this.f_97726_, this.f_97727_);
        int sliderProgress = (int)(41.0f * this.sliderProgress);
        this.m_93228_(matrixStack, left + 119, top + 15 + sliderProgress, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int leftOffset = this.f_97735_ + 52;
        int topOffset = this.f_97736_ + 14;
        int recipeIndexOffset = this.recipeIndexOffset + 12;
        this.renderRecipeBackground(matrixStack, x, y, leftOffset, topOffset, recipeIndexOffset);
        this.drawRecipesItems(leftOffset, topOffset, recipeIndexOffset);
    }

    protected void m_7025_(PoseStack matrixStack, int hoverX, int hoverY) {
        super.m_7025_(matrixStack, hoverX, hoverY);
        if (this.hasItemsInInputSlot) {
            int guiLeft = this.f_97735_ + 52;
            int guiTop = this.f_97736_ + 14;
            int recipeIndexOffset = this.recipeIndexOffset + 12;
            List<Item> outputs = ((AlchemyTableMenu)this.f_97732_).getOutputItems();
            for (int i = this.recipeIndexOffset; i < recipeIndexOffset && i < ((AlchemyTableMenu)this.f_97732_).getOutputCount(); ++i) {
                int index = i - this.recipeIndexOffset;
                int x = guiLeft + index % 4 * 16;
                int y = guiTop + index / 4 * 18 + 2;
                if (hoverX < x || hoverX >= x + 16 || hoverY < y || hoverY >= y + 18) continue;
                this.m_6057_(matrixStack, new ItemStack((ItemLike)outputs.get(i)), hoverX, hoverY);
            }
        }
    }

    private void renderRecipeBackground(PoseStack matrixStack, int x, int y, int leftOffset, int topOffset, int recipeIndexOffset) {
        for (int i = this.recipeIndexOffset; i < recipeIndexOffset && i < ((AlchemyTableMenu)this.f_97732_).getOutputCount(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int xPos = leftOffset + recipeIndex % 4 * 16;
            int dividedIndex = recipeIndex / 4;
            int yPos = topOffset + dividedIndex * 18 + 2;
            int vOffset = this.f_97727_;
            if (i == ((AlchemyTableMenu)this.f_97732_).getSelectedItem()) {
                vOffset += 18;
            } else if (x >= xPos && y >= yPos && x < xPos + 16 && y < yPos + 18) {
                vOffset += 36;
            }
            this.m_93228_(matrixStack, xPos, yPos - 1, 0, vOffset, 16, 18);
        }
    }

    private void drawRecipesItems(int left, int top, int recipeIndexOffsetMax) {
        List<Item> outputs = ((AlchemyTableMenu)this.f_97732_).getOutputItems();
        for (int i = this.recipeIndexOffset; i < recipeIndexOffsetMax && i < ((AlchemyTableMenu)this.f_97732_).getOutputCount(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int xPos = left + recipeIndex % 4 * 16;
            int recipe = recipeIndex / 4;
            int yPos = top + recipe * 18 + 2;
            this.f_96541_.m_91291_().m_115203_(new ItemStack((ItemLike)outputs.get(i)), xPos, yPos);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.clickedOnSroll = false;
        if (this.hasItemsInInputSlot) {
            int leftOffset = this.f_97735_ + 52;
            int topOffset = this.f_97736_ + 14;
            int recipeIndexOffset = this.recipeIndexOffset + 12;
            for (int l = this.recipeIndexOffset; l < recipeIndexOffset; ++l) {
                int i1 = l - this.recipeIndexOffset;
                double xPos = mouseX - (double)(leftOffset + i1 % 4 * 16);
                double yPos = mouseY - (double)(topOffset + i1 / 4 * 18);
                if (!(xPos >= 0.0) || !(yPos >= 0.0) || !(xPos < 16.0) || !(yPos < 18.0) || !((AlchemyTableMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.f_96541_.f_91072_.m_105208_(((AlchemyTableMenu)this.f_97732_).f_38840_, l);
                return true;
            }
            leftOffset = this.f_97735_ + 119;
            topOffset = this.f_97736_ + 9;
            if (mouseX >= (double)leftOffset && mouseX < (double)(leftOffset + 12) && mouseY >= (double)topOffset && mouseY < (double)(topOffset + 54)) {
                this.clickedOnSroll = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.clickedOnSroll && this.canScroll()) {
            int topOffset = this.f_97736_ + 14;
            int lowerBounds = topOffset + 54;
            this.sliderProgress = ((float)mouseY - (float)topOffset - 7.5f) / ((float)(lowerBounds - topOffset) - 15.0f);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int hiddenRows = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - delta / (double)hiddenRows);
            this.sliderProgress = Mth.m_14036_((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)hiddenRows) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.hasItemsInInputSlot && ((AlchemyTableMenu)this.f_97732_).getOutputCount() > 12;
    }

    protected int getHiddenRows() {
        return (((AlchemyTableMenu)this.f_97732_).getOutputCount() + 4 - 1) / 4 - 3;
    }

    private void onInventoryUpdate() {
        this.hasItemsInInputSlot = ((AlchemyTableMenu)this.f_97732_).hasItemsinInputSlot();
        if (!this.hasItemsInInputSlot) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

