/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities.hostile.boss;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.client.init.SkiesRenderRefs;
import com.legacy.blue_skies.client.models.entities.hostile.boss.ArachnarchModel;
import com.legacy.blue_skies.client.renders.entities.layers.EmissiveRenderLayer;
import com.legacy.blue_skies.entities.hostile.boss.ArachnarchEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArachnarchRenderer<T extends ArachnarchEntity>
extends MobRenderer<T, ArachnarchModel<T>> {
    private static final ResourceLocation TEXTURE = BlueSkies.locate("textures/entity/arachnarch/arachnarch.png");
    private static final ResourceLocation GLOW = BlueSkies.locate("textures/entity/arachnarch/arachnarch_glow.png");
    private static final ResourceLocation TEXTURE_HALLOWEEN = BlueSkies.locate("textures/entity/arachnarch/arachnarch_halloween.png");
    private static final ResourceLocation GLOW_HALLOWEEN = BlueSkies.locate("textures/entity/arachnarch/arachnarch_glow_halloween.png");

    public ArachnarchRenderer(EntityRendererProvider.Context context) {
        super(context, new ArachnarchModel(context.m_174023_(SkiesRenderRefs.ARACHNARCH)), 1.5f);
        this.m_115326_(new EmissiveRenderLayer(this, BlueSkiesConfig.COMMON.isHalloween() ? GLOW_HALLOWEEN : GLOW));
    }

    protected void scale(T entity, PoseStack matrixStackIn, float partialTickTime) {
        Level world = ((ArachnarchEntity)entity).f_19853_;
        BlockPos pos = entity.m_20183_();
        boolean climbing = ((ArachnarchEntity)entity).isBesideClimbableBlock();
        if (!entity.m_20096_() && climbing || ((ArachnarchEntity)entity).isCeilingLocked()) {
            if (!world.m_46859_(pos.m_6630_(2)) && ((ArachnarchEntity)entity).isCeilingLocked()) {
                matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                matrixStackIn.m_252880_(0.0f, 1.85f, 0.0f);
            }
        } else {
            matrixStackIn.m_252880_(0.0f, 0.1f, 0.0f);
        }
        matrixStackIn.m_85841_(1.2f, 1.2f, 1.2f);
        if (((ArachnarchEntity)entity).f_20919_ > 0) {
            matrixStackIn.m_252880_(0.0f, 1.0f, 0.0f);
        }
    }

    protected void setupRotations(T entityLiving, PoseStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
        if (((ArachnarchEntity)entityLiving).deathTicks > 0) {
            rotationYaw += (float)(Math.cos((double)((ArachnarchEntity)entityLiving).f_19797_ * 3.25) * Math.PI * 0.55);
        }
        if (((ArachnarchEntity)entityLiving).clientScreechTime > 0) {
            rotationYaw += (float)(Math.sin((double)((ArachnarchEntity)entityLiving).f_19797_ * 3.25) * Math.PI * 0.55);
        }
        super.m_7523_(entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
    }

    protected float getFlipDegrees(T entityLivingBaseIn) {
        return 180.0f;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return BlueSkiesConfig.COMMON.isHalloween() ? TEXTURE_HALLOWEEN : TEXTURE;
    }
}

