/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.renders.entities.misc;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.init.SkiesRenderRefs;
import com.legacy.blue_skies.client.models.entities.misc.SpearModel;
import com.legacy.blue_skies.entities.projectile.SpearEntity;
import com.legacy.blue_skies.registries.SkiesItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpearRenderer<T extends SpearEntity>
extends EntityRenderer<T> {
    public static final ResourceLocation BLUEBRIGHT_SPEAR = BlueSkies.locate("textures/entity/spear/bluebright_spear.png");
    public static final ResourceLocation STARLIT_SPEAR = BlueSkies.locate("textures/entity/spear/starlit_spear.png");
    public static final ResourceLocation FROSTBRIGHT_SPEAR = BlueSkies.locate("textures/entity/spear/frostbright_spear.png");
    public static final ResourceLocation LUNAR_SPEAR = BlueSkies.locate("textures/entity/spear/lunar_spear.png");
    public static final ResourceLocation DUSK_SPEAR = BlueSkies.locate("textures/entity/spear/dusk_spear.png");
    public static final ResourceLocation MAPLE_SPEAR = BlueSkies.locate("textures/entity/spear/maple_spear.png");
    public static final ResourceLocation CHERRY_SPEAR = BlueSkies.locate("textures/entity/spear/cherry_spear.png");
    public static final ResourceLocation SOULBOUND_SPEAR = BlueSkies.locate("textures/entity/spear/soulbound_spear.png");
    public static final ResourceLocation GLOW = BlueSkies.locate("textures/entity/spear/spear_glow.png");
    public static final ResourceLocation SOULBOUND_GLOW = BlueSkies.locate("textures/entity/spear/soulbound_spear_glow.png");
    private final SpearModel spearModel;
    private final SpearModel soulboundModel;

    public SpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.spearModel = new SpearModel(context.m_174023_(SkiesRenderRefs.SPEAR));
        this.soulboundModel = new SpearModel(context.m_174023_(SkiesRenderRefs.SOULBOUND_SPEAR));
    }

    public void render(T entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        if (((SpearEntity)((Object)entityIn)).f_19797_ < 1) {
            return;
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((SpearEntity)((Object)entityIn)).f_19859_, (float)entityIn.m_146908_()) - 90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)((SpearEntity)((Object)entityIn)).f_19860_, (float)entityIn.m_146909_()) + 90.0f));
        VertexConsumer builder = ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110452_((ResourceLocation)this.getTextureLocation(entityIn)), (boolean)false, (boolean)((SpearEntity)((Object)entityIn)).hasEffect());
        this.getModel(entityIn).m_7695_(matrixStackIn, builder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer glowBuilder = ItemRenderer.m_115222_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110488_((ResourceLocation)this.getGlowTexture(entityIn)), (boolean)false, (boolean)((SpearEntity)((Object)entityIn)).hasEffect());
        this.getModel(entityIn).m_7695_(matrixStackIn, glowBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
        super.m_7392_(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return SpearRenderer.getSpearTexture(((SpearEntity)((Object)entity)).m_7941_().m_41720_());
    }

    public static ResourceLocation getSpearTexture(Item item) {
        if (item.equals(SkiesItems.starlit_spear)) {
            return STARLIT_SPEAR;
        }
        if (item.equals(SkiesItems.frostbright_spear)) {
            return FROSTBRIGHT_SPEAR;
        }
        if (item.equals(SkiesItems.lunar_spear)) {
            return LUNAR_SPEAR;
        }
        if (item.equals(SkiesItems.dusk_spear)) {
            return DUSK_SPEAR;
        }
        if (item.equals(SkiesItems.maple_spear)) {
            return MAPLE_SPEAR;
        }
        if (item.equals(SkiesItems.cherry_spear)) {
            return CHERRY_SPEAR;
        }
        if (item.equals(SkiesItems.soulbound_spear)) {
            return SOULBOUND_SPEAR;
        }
        return BLUEBRIGHT_SPEAR;
    }

    public ResourceLocation getGlowTexture(T entity) {
        return ((SpearEntity)((Object)entity)).m_7941_().m_41720_() == SkiesItems.soulbound_spear ? SOULBOUND_GLOW : GLOW;
    }

    public SpearModel getModel(T entityIn) {
        return ((SpearEntity)((Object)entityIn)).m_7941_().m_41720_() == SkiesItems.soulbound_spear ? this.soulboundModel : this.spearModel;
    }
}

