/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.legacy.blue_skies.registries.SkiesConfiguredCarvers;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesFeaturePlacements;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesBiomeProv {

    public static class Makers {
        protected static final int BRIGHT_FOLIAGE_COLOR = 7059637;
        protected static final int DAWN_FOLIAGE_COLOR = 12485859;

        public static Biome calmingSkies(BootstapContext<?> bootstrap) {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CALMING_SKIES_BLUEBRIGHT_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CALMING_SKIES_STARLIT_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_NOISE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRITTLEBUSH_3);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.POLAR_POSY_3);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CALMING_SKIES_CAVE_DRIPSTONE);
            SkiesFeaturePlacements.addBrightLakes(builder);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, true, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome brightlands(BootstapContext<?> bootstrap) {
            int grassColor = 14016767;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float temp = 0.0f;
            float downfall = 0.8f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.REINDEER, 4, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYNOCEROUS, 1, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRIGHTLANDS_FALLEN_LOG);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRIGHTLANDS_STARLIT_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_3);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CHILLWEED_3);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOWBLOOM_2);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.BRIGHTLANDS_CAVE_GRASS);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.BRIGHTLANDS_GIANT_CAVE_ICICLE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.BRIGHTLANDS_CAVE_WALL);
            SkiesFeaturePlacements.addBrightLakes(builder);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, true, true);
            SkiesFeaturePlacements.addEmeraldOre(builder, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome slushlands(BootstapContext<?> bootstrap) {
            int grassColor = 12119807;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 7252691;
            float temp = 0.5f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHRUMPTY, 2, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SLUSHLANDS_LARGE_SNOWCAP_MUSHROOM);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SLUSHLANDS_SNOWCAP_MUSHROOM);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SLUSHLANDS_CHILLED_LILY);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.PATCHY_SNOW);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRITTLEBUSH_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOWCAP_PINHEAD_8);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.SLUSHLANDS_CAVE_WALL);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SLUSHLANDS_CAVE_BLUEBRIGHT_VINE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SLUSHLANDS_CAVE_PINHEAD);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, false, false);
            SkiesFeaturePlacements.addBrightDoubleGrass(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome frostbittenForest(BootstapContext<?> bootstrap, boolean isClearing) {
            int grassColor = 13288447;
            int foliageColor = 7059637;
            int waterColor = 6583020;
            int waterFogColor = 6583020;
            int skyColor = 6654717;
            float temp = 0.0f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SNOW_OWL, 6, 2, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_BUSH);
            if (isClearing) {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_SMALL_FROSTBRIGHT_TREE);
            } else {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_FROSTBRIGHT_TREE);
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_BLUEBRIGHT_TREE);
            }
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRITTLEBUSH_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CHILLWEED_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOWBLOOM_2);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_CAVE_FROSTBRIGHT_VINE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_CAVE_GRASS);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.FROSTBITTEN_FOREST_CAVE_WALL);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, true, false);
            SkiesFeaturePlacements.addBrightDoubleGrass(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome peekingOcean(BootstapContext<?> bootstrap, boolean isDeep, boolean isBrumbleForest) {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = isDeep ? 4672964 : 6583020;
            int waterFogColor = isDeep ? 4672964 : 6583020;
            int skyColor = 9684223;
            float temp = 0.2f;
            float downfall = 0.4f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20556_, 15, 3, 6));
            spawns.m_48370_(EntityType.f_20556_, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.JELLY_DRIFTER, 5, 1, 3));
            spawns.m_48370_(SkiesEntityTypes.JELLY_DRIFTER, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.GRITTLE_FLATFISH, 5, 2, 3));
            spawns.m_48370_(SkiesEntityTypes.GRITTLE_FLATFISH, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.MUNICIPAL_MONKFISH, 15, 3, 6));
            spawns.m_48370_(SkiesEntityTypes.MUNICIPAL_MONKFISH, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 25, 2, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.WHISTLESHELL_CRAB, 20, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SECLAM, 10, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.PEEKING_OCEAN_BRUMBLE);
            if (isBrumbleForest) {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRUMBLE_FOREST_BRUMBLE_VINE);
            } else {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.PEEKING_OCEAN_SEA_MOSS);
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.PEEKING_OCEAN_BRUMBLE_VINE);
                builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesFeaturePlacements.PEEKING_OCEAN_SPIKE);
            }
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.PEEKING_OCEAN_CAVE_MOSS_CARPET);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.PEEKING_OCEAN_CAVE_DENSE_MOSS_WALL);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.PEEKING_OCEAN_CAVE_MOSS_WALL);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_5);
            SkiesConfiguredCarvers.addOceanCarvers(builder);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, true, false);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome middayShore(BootstapContext<?> bootstrap) {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 6583020;
            int waterFogColor = 6583020;
            int skyColor = 10994416;
            float temp = 0.3f;
            float downfall = 0.4f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.WHISTLESHELL_CRAB, 20, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.MIDDAY_BAYHOP_6);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, false, false);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome snowCoveredPines(BootstapContext<?> bootstrap) {
            int grassColor = 14016767;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float temp = 0.0f;
            float downfall = 0.8f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 8, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.REINDEER, 4, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 6, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYNOCEROUS, 1, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOW_COVERED_PINES_STARLIT_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_2);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRITTLEBUSH_3);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CHILLWEED_3);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOWBLOOM_2);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOW_COVERED_PINES_CAVE_STARLIT_VINE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SNOW_COVERED_PINES_WALL_MOONSTONE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.SNOW_COVERED_PINES_CAVE_WALL);
            SkiesFeaturePlacements.addBrightLakes(builder);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, true, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.SNOW).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome briskMeadow(BootstapContext<?> bootstrap) {
            int grassColor = 0xFFFFFF;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 9684223;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 5, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 8, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 2, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 1, 1, 2));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRISK_MEADOW_BLUEBRIGHT_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRISK_MEADOW_BUSH);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRISK_MEADOW_FLOWER);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_8);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BREWBERRY_3);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.BRISK_MEADOW_CAVE_WALL_STONE_RIMESTONE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.BRISK_MEADOW_CAVE_WALL_RIMESTONE_STONE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BRISK_MEADOW_CAVE_FROSE);
            SkiesFeaturePlacements.addBrightLakes(builder);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, false, false);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48029_(new AmbientParticleSettings((ParticleOptions)SkiesParticles.BRISK_PETAL, 0.012f)).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome polarHighland(BootstapContext<?> bootstrap) {
            int grassColor = 11657944;
            int foliageColor = 7059637;
            int waterColor = 2903689;
            int waterFogColor = 2903689;
            int skyColor = 7252691;
            float temp = 0.3f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.STARDUST_RAM, 5, 2, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.AZULFO, 8, 4, 4));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.ARMORED_FROST_SPIRIT, 3, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.DIOPHYDE_PROWLER, 2, 1, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.POLARGEIST, 1, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, SkiesFeaturePlacements.POLAR_HIGHLAND_ROCK);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.POLAR_HIGHLAND_VEGETATION);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.TURQUOISE_GRASS_NOISE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.POLAR_POSY_6);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.POLAR_HIGHLAND_CAVE_WALL_TARATITE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.POLAR_HIGHLAND_CAVE_GRASS);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.POLAR_HIGHLAND_CAVE_POSY);
            SkiesFeaturePlacements.addBrightLakes(builder);
            SkiesFeaturePlacements.addGeneralBrightFeatures(builder, true, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome unorthodoxValley(BootstapContext<?> bootstrap) {
            int grassColor = 14843647;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 9471171;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 6, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.UNORTHODOX_VALLEY_DUSK_LUNAR_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.UNORTHODOX_VALLEY_CRESCENT_FRUIT_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.UNORTHODOX_VALLEY_BUSH);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.RISING_CREEK_MOONLIT_WATER_LILY);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.NIGHTCRESS_2);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.UNORTHODOX_VALLEY_CAVE_DRIPSTONE);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, true, false);
            SkiesFeaturePlacements.addEmeraldOre(builder, false);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome shadedWoodlands(BootstapContext<?> bootstrap) {
            int grassColor = 13151691;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 0;
            float temp = 1.1f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.FIREFLY, 10, 3, 5));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 4, 4));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.NYCTOFLY, 5, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SHADED_WOODLANDS_LARGE_DUSK_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_MUCKWEED_20);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_MUCKWEED_NOISE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SHADED_WOODLANDS_FLOWER);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.BANEFUL_MUSHROOM_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SHADED_WOODLANDS_CAVE_DUSK_VINE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.SHADED_WOODLANDS_CAVE_WALL);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, false, false);
            SkiesFeaturePlacements.addDawnDoubleGrass(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48023_((Holder)ForgeRegistries.SOUND_EVENTS.getDelegateOrThrow((Object)SkiesSounds.AMBIENT_SHADED_WOODLANDS_LOOP)).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome crystalDunes(BootstapContext<?> bootstrap, boolean hasSpikes) {
            int grassColor = 0xFFA3FF;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15784896;
            float temp = 1.7f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYSTAL_CAMEL, 5, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 2, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesFeaturePlacements.CRYSTAL_DUNES_MOONSTONE_SPIKE);
            if (hasSpikes) {
                builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesFeaturePlacements.CRYSTAL_DUNES_LARGE_MOONSTONE_SPIKE);
            }
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LIGHT_CRYSTALLIZED_GRASS_2);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CRYSTAL_FLOWER_2);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRYSTAL_DUNES_CAVE_MOONSTONE_CRYSTAL);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRYSTAL_DUNES_CAVE_GRASS);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CRYSTAL_DUNES_CAVE_WALL_MOONSTONE);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, false, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome risingCreek(BootstapContext<?> bootstrap) {
            int grassColor = 15844607;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 9471171;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
            spawns.m_48370_(EntityType.f_20519_, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
            spawns.m_48370_(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.HORIZOFIN_TUNID, 5, 3, 5));
            spawns.m_48370_(SkiesEntityTypes.HORIZOFIN_TUNID, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 5, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.RISING_CREEK_MOONLIT_WATER_LILY);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_MUCKWEED_20);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, true, false);
            SkiesFeaturePlacements.addDawnDoubleGrass(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome moonlitReservoir(BootstapContext<?> bootstrap) {
            int grassColor = 9269656;
            int foliageColor = 12485859;
            int waterColor = 4354427;
            int waterFogColor = 4354427;
            int skyColor = 8687555;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CROGRE, 8, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 4, 1, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.NYCTOFLY, 5, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            double fishCost = 0.05;
            double fishBudget = 1.0;
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 5, 1, 5));
            spawns.m_48370_(EntityType.f_20519_, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
            spawns.m_48370_(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
            spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.HORIZOFIN_TUNID, 5, 3, 5));
            spawns.m_48370_(SkiesEntityTypes.HORIZOFIN_TUNID, fishCost, fishBudget);
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.MOONLIT_RESERVOIR_DUSK_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.MOONLIT_RESERVOIR_GLIMMER_REEDS);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.MOONLIT_RESERVOIR_MOONLIT_WATER_LILY);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_MUCKWEED_NOISE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUCENTROOT_2);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.MOONLIT_RESERVOIR_CAVE_GRASS);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.MOONLIT_RESERVOIR_CAVE_WALL);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, true, false);
            SkiesFeaturePlacements.addDawnDoubleGrass(builder);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48023_((Holder)ForgeRegistries.SOUND_EVENTS.getDelegateOrThrow((Object)SkiesSounds.AMBIENT_MOONLIT_RESERVOIR_LOOP)).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome crystalRoughs(BootstapContext<?> bootstrap) {
            int grassColor = 13155070;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 14350335;
            float temp = 1.7f;
            float downfall = 0.0f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CRYSTAL_CAMEL, 2, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 1, 2));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesFeaturePlacements.CRYSTAL_ROUGHS_LUNAR_TREE);
            builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesFeaturePlacements.CRYSTAL_ROUGHS_CRYSTALIZED_TREE);
            builder.m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, SkiesFeaturePlacements.CRYSTAL_ROUGHS_SHORT_MOONSTONE_SPIKE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CRYSTALLIZED_GRASS_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CRYSTAL_FLOWER_2);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRYSTAL_ROUGHS_CAVE_GRASS);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, false, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome sunsetMapleForest(BootstapContext<?> bootstrap) {
            int grassColor = 15829434;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15770516;
            float temp = 1.5f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SLIV, 2, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SUNSET_MAPLE_FOREST_MAPLE_TREE);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_7);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_4);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SUNSET_MAPLE_FOREST_CAVE_WALL_SUNSTONE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.SUNSET_MAPLE_FOREST_CAVE_MAGMA);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SUNSET_MAPLE_FOREST_CAVE_MAPLE_VINE);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, false, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome searingGrassland(BootstapContext<?> bootstrap) {
            int grassColor = 15829396;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15766676;
            float temp = 1.6f;
            float downfall = 0.1f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SLIV, 2, 2, 3));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.EMBERBACK, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SEARING_GRASSLAND_BUSH);
            builder.m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, SkiesFeaturePlacements.SEARING_GRASSLAND_ROCK);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_7);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.FLARE_FLORET_BLAZE_BUD_LUCENTROOT_5);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.SEARING_GRASSLAND_CAVE_WALL_SUNSTONE);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.SEARING_GRASSLAND_CAVE_MAGMA);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.SEARING_GRASSLAND_CAVE_WALL);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, false, true);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48029_(new AmbientParticleSettings((ParticleOptions)SkiesParticles.SEARING_SMOKE, 0.01f)).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        public static Biome crescentOrchard(BootstapContext<?> bootstrap, boolean isLake) {
            int grassColor = 12025574;
            int foliageColor = 12485859;
            int waterColor = 4351611;
            int waterFogColor = 4351611;
            int skyColor = 15774612;
            float temp = 1.3f;
            float downfall = 0.3f;
            MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
            if (isLake) {
                double fishCost = 0.05;
                double fishBudget = 1.0;
                spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.CHARSCALE_MOKI, 5, 3, 5));
                spawns.m_48370_(SkiesEntityTypes.CHARSCALE_MOKI, fishCost, fishBudget);
                spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.HORIZOFIN_TUNID, 3, 3, 5));
                spawns.m_48370_(SkiesEntityTypes.HORIZOFIN_TUNID, fishCost, fishBudget);
            } else {
                spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.COSMIC_FOX, 5, 1, 2));
                spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.SHADE_MONITOR, 8, 2, 3));
            }
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.VENOM_SPIDER, 7, 1, 1));
            spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(SkiesEntityTypes.INFESTED_SWARMER, 7, 1, 1));
            BiomeGenerationSettings.Builder builder = new BiomeGenerationSettings.Builder(bootstrap.m_255420_(Registries.f_256988_), bootstrap.m_255420_(Registries.f_257003_));
            if (!isLake) {
                builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.CRESCENT_ORCHARD_CRESCENT_FRUIT_TREE);
            }
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.LUNAR_GRASS_4);
            builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, SkiesFeaturePlacements.NIGHTCRESS_2);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRESCENT_ORCHARD_CAVE_GRASS);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRESCENT_ORCHARD_CAVE_DIRT);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRESCENT_ORCHARD_CAVE_BLOOM);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRESCENT_ORCHARD_CAVE_NIGHTCRESS);
            builder.m_255155_(GenerationStep.Decoration.UNDERGROUND_DECORATION, SkiesFeaturePlacements.CRESCENT_ORCHARD_CAVE_LUCENTROOT);
            SkiesFeaturePlacements.addDawnLakes(builder);
            SkiesFeaturePlacements.addGeneralDawnFeatures(builder, true, false);
            return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(temp).m_47611_(downfall).m_47603_(Makers.createAmbienceBuilder(grassColor, foliageColor, waterColor, waterFogColor, skyColor).m_48018_()).m_47605_(spawns.m_48381_()).m_47601_(builder.m_255380_()).m_47592_();
        }

        protected static BiomeSpecialEffects.Builder createAmbienceBuilder(int grassColor, int foliageColor, int waterColor, int waterFogColor, int skyColor) {
            return new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48040_(Makers.calcDefaultSkyColor(0.3f)).m_48027_(AmbientMoodSettings.f_47387_).m_48045_(grassColor).m_48043_(foliageColor).m_48034_(waterColor).m_48037_(waterFogColor).m_48040_(skyColor);
        }

        private static int calcDefaultSkyColor(float chance) {
            float thirdChance = chance / 3.0f;
            thirdChance = Mth.m_14036_((float)thirdChance, (float)-1.0f, (float)1.0f);
            return Mth.m_14169_((float)(0.62222224f - thirdChance * 0.05f), (float)(0.5f + thirdChance * 0.1f), (float)1.0f);
        }
    }
}

