/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.entities.util.base.SkiesMonsterEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WhistleshellCrabEntity
extends SkiesMonsterEntity {
    public static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.m_135353_(WhistleshellCrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private float prevSidwaysAnim;
    private float sidewaysAnim;
    private float swingAnim;
    private float prevSwingAnim;
    private boolean playSidewaysAnim;
    private boolean playAttackAnim;
    private int attackTimer;

    public WhistleshellCrabEntity(EntityType<? extends WhistleshellCrabEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 26.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TYPE, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new CrabMeleeAttackGoal((PathfinderMob)this, 1.2f, true));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setCrabType((byte)worldIn.m_213780_().m_188503_(2));
        int height = worldIn.m_6924_(Heightmap.Types.OCEAN_FLOOR, (int)this.m_20185_(), (int)this.m_20189_());
        BlockPos newPos = new BlockPos(this.m_20185_(), (double)height, this.m_20189_());
        if (reason == MobSpawnType.NATURAL && worldIn.m_46801_(this.m_20183_().m_7495_()) && !worldIn.m_46801_(this.m_20183_())) {
            this.m_6021_(newPos.m_123341_(), worldIn.m_45772_(this.m_20191_()) ? (double)newPos.m_123342_() : (double)(newPos.m_123342_() + 5), newPos.m_123343_());
        }
        return spawnDataIn;
    }

    public void m_8119_() {
        boolean walking;
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.prevSidwaysAnim = this.sidewaysAnim;
            this.prevSwingAnim = this.swingAnim;
            this.sidewaysAnim = this.playSidewaysAnim ? Mth.m_14036_((float)(this.sidewaysAnim + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.sidewaysAnim - 1.0f), (float)0.0f, (float)6.0f);
            this.swingAnim = this.playAttackAnim ? Mth.m_14036_((float)(this.swingAnim + 1.0f), (float)0.0f, (float)6.0f) : Mth.m_14036_((float)(this.swingAnim - 1.0f), (float)0.0f, (float)6.0f);
        } else {
            if (this.attackTimer > 0) {
                --this.attackTimer;
            }
            if (this.attackTimer == 0) {
                this.setAttackAnim(false);
            }
        }
        boolean bl = walking = this.getMoveForward() > 0.0f;
        if (walking && this.m_5448_() == null || walking && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) > 3.0f + this.m_5448_().m_20205_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)4);
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)5);
        }
        if (this.m_20072_() && this.f_19797_ % 40 == 0 && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) <= 10.0f && this.m_20096_()) {
            Vec3 vector3d = this.m_20184_();
            Vec3 vector3d1 = new Vec3(this.m_5448_().m_20185_() - this.m_20185_(), this.m_5448_().m_20186_() - this.m_20186_(), this.m_5448_().m_20189_() - this.m_20189_());
            if (vector3d1.m_82556_() > 1.0E-7) {
                vector3d1 = vector3d1.m_82541_().m_82490_(0.4).m_82549_(vector3d.m_82490_(0.2));
            }
            this.m_20334_(vector3d1.f_82479_, vector3d1.f_82480_ + 0.1, vector3d1.f_82481_);
        }
    }

    public void setCrabType(byte type) {
        this.f_19804_.m_135381_(TYPE, (Object)type);
    }

    public byte getCrabType() {
        return (Byte)this.f_19804_.m_135370_(TYPE);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("CrabType", this.getCrabType());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setCrabType(compound.m_128445_("CrabType"));
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.f_19853_.f_46443_) {
            this.setAttackAnim(true);
        }
        return super.m_7327_(entityIn);
    }

    protected float m_6108_() {
        return 0.95f;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return super.m_6469_(source, amount);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.7f;
    }

    public int m_5792_() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getSidewaysAnimationScale(float pctIn) {
        return Mth.m_14179_((float)pctIn, (float)this.prevSidwaysAnim, (float)this.sidewaysAnim) / 6.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAttackAnimationScale(float pctIn) {
        return Mth.m_14179_((float)pctIn, (float)this.prevSwingAnim, (float)this.swingAnim) / 6.0f;
    }

    protected void setAttackAnim(boolean attacking) {
        if (attacking) {
            this.f_19853_.m_7605_((Entity)this, (byte)6);
            this.attackTimer = 10;
            this.playAttackAnim = true;
        } else {
            this.f_19853_.m_7605_((Entity)this, (byte)7);
            this.playAttackAnim = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        switch (id) {
            case 4: {
                this.playSidewaysAnim = true;
                break;
            }
            case 5: {
                this.playSidewaysAnim = false;
                break;
            }
            case 6: {
                this.playAttackAnim = true;
                break;
            }
            case 7: {
                this.playAttackAnim = false;
                break;
            }
            default: {
                super.m_7822_(id);
            }
        }
    }

    class CrabMeleeAttackGoal
    extends MeleeAttackGoal {
        public CrabMeleeAttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public void m_8041_() {
            super.m_8041_();
        }

        protected double m_6639_(LivingEntity attackTarget) {
            return 6.0f + attackTarget.m_20205_();
        }
    }
}

