/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons.ent;

import com.legacy.blue_skies.entities.hostile.SpewterEntity;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntWallEntity;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBoss;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntRootEntity
extends Entity {
    protected static final EntityDataAccessor<Boolean> LARGE = SynchedEntityData.m_135353_(EntRootEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int warmupDelayTicks;
    public int lifeTicks = this.isLarge() ? 80 : 50;
    public int downwardTranslateAmount = 0;
    private boolean sentSpikeEvent;
    private LivingEntity caster;
    private UUID casterUuid;

    public EntRootEntity(EntityType<? extends EntRootEntity> typeIn, Level worldIn) {
        super(typeIn, worldIn);
    }

    public EntRootEntity(Level worldIn, double x, double y, double z, float rotation, int warmupDelay, LivingEntity casterIn, boolean isRootLarge) {
        this(SkiesEntityTypes.ENT_ROOT, worldIn);
        this.warmupDelayTicks = warmupDelay;
        this.setCaster(casterIn);
        this.m_146922_(rotation * 57.295776f);
        this.m_6034_(x, y, z);
        this.lifeTicks = this.isLarge() ? 80 : 50;
        this.setRootIsLarge(isRootLarge);
    }

    public EntRootEntity(PlayMessages.SpawnEntity spawnEntity, Level world) {
        this(SkiesEntityTypes.ENT_ROOT, world);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LARGE, (Object)false);
    }

    public void m_6478_(MoverType type, Vec3 vec) {
        super.m_6478_(type, Vec3.f_82478_);
    }

    public void setCaster(LivingEntity livingIn) {
        this.caster = livingIn;
        this.casterUuid = livingIn == null ? null : livingIn.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void m_7378_(CompoundTag compound) {
        this.setRootIsLarge(compound.m_128471_("Large"));
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("OwnerUUID")) {
            this.casterUuid = compound.m_128342_("OwnerUUID");
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("Large", this.isLarge());
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("OwnerUUID", this.casterUuid);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.lifeTicks <= 5) {
                --this.downwardTranslateAmount;
            }
            --this.lifeTicks;
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks <= -2 && this.lifeTicks > 5) {
                for (LivingEntity livingentity : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) {
                    if (livingentity instanceof EntWallEntity || livingentity instanceof SpewterEntity) continue;
                    this.damage(livingentity);
                }
            }
            if (!this.sentSpikeEvent) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.m_146870_();
            }
        }
        if (!this.f_19853_.m_8055_(this.m_20183_()).m_60812_((BlockGetter)this.f_19853_, this.m_20183_()).m_83281_() || this.getCaster() != null && !this.getCaster().m_6084_()) {
            this.m_146870_();
        }
        if (this.f_19797_ == 1) {
            this.m_5496_(SoundEvents.f_11838_, 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f);
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity caster = this.getCaster();
        int timeUntilHit = 0;
        if (caster instanceof StarlitCrusherEntity) {
            StarlitCrusherEntity crusher = (StarlitCrusherEntity)caster;
            int n = crusher.getDifficultyID() == ISkyBoss.BossLevel.SILVER.getId() ? 8 : (crusher.getDifficultyID() == ISkyBoss.BossLevel.GOLD.getId() ? 10 : (timeUntilHit = crusher.getDifficultyID() >= ISkyBoss.BossLevel.PLATINUM.getId() ? 14 : 0));
        }
        if (target.m_6084_() && !target.m_20147_() && target != caster && target.f_19802_ <= timeUntilHit) {
            float damage;
            float f = damage = this.isLarge() ? 5.0f : 3.0f;
            if (caster == null) {
                if (target.m_6117_() && target.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                    target.m_5810_();
                }
                target.m_6469_(EntityUtil.DamageSources.ROOT, damage);
            } else {
                if (caster.m_7307_((Entity)target)) {
                    return;
                }
                if (target.m_6117_() && target.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
                    target.m_5810_();
                }
                target.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)caster), damage);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.m_5496_(SoundEvents.f_11756_, 1.0f, this.f_19796_.m_188501_() * 0.2f + 0.85f);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19310_) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLifeTicks() {
        return this.lifeTicks;
    }

    public boolean isLarge() {
        return (Boolean)this.f_19804_.m_135370_(LARGE);
    }

    public void setRootIsLarge(boolean staticIn) {
        this.f_19804_.m_135381_(LARGE, (Object)staticIn);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

