/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile.boss.summons.ent;

import com.legacy.blue_skies.data.objects.tags.SkiesEntityTags;
import com.legacy.blue_skies.entities.hostile.boss.StarlitCrusherEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ent.EntRootEntity;
import com.legacy.blue_skies.entities.passive.SnowOwlEntity;
import com.legacy.blue_skies.entities.util.WallExtensionEntity;
import com.legacy.blue_skies.items.tools.SkyAxeItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;

public class EntWallEntity
extends LivingEntity {
    protected static final EntityDataAccessor<Boolean> FACING_Z = SynchedEntityData.m_135353_(EntWallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private LivingEntity caster;
    private UUID casterUuid;
    public int translateAmount = 0;
    private final WallExtensionEntity leftSection = new WallExtensionEntity(this, "left_section", 1.0f, 3.0f);
    private final WallExtensionEntity rightSection = new WallExtensionEntity(this, "right_section", 1.0f, 3.0f);
    private final WallExtensionEntity[] parts = new WallExtensionEntity[]{this.leftSection, this.rightSection};

    public EntWallEntity(EntityType<? extends EntWallEntity> typeIn, Level worldIn) {
        super(typeIn, worldIn);
        this.m_20234_(f_19843_.getAndAdd(this.parts.length + 1) + 1);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].m_20234_(id + i + 1);
        }
    }

    public EntWallEntity(Level worldIn, double x, double y, double z, LivingEntity casterIn) {
        this(SkiesEntityTypes.ENT_WALL, worldIn);
        this.setCaster(casterIn);
        this.m_146926_(0.0f);
        this.m_146922_(0.0f);
        this.f_20885_ = 0.0f;
        this.f_19859_ = 0.0f;
        this.f_19860_ = 0.0f;
        this.f_20885_ = 0.0f;
        this.m_6034_(x + 0.5, y, z + 0.5);
        if (casterIn != null && casterIn instanceof StarlitCrusherEntity) {
            this.m_21051_(Attributes.f_22276_).m_22100_(30.0 + (double)((StarlitCrusherEntity)casterIn).getExtraPlayers() * 10.0);
        }
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, Vec3.f_82478_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FACING_Z, (Object)false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 100.0);
    }

    public void setCaster(LivingEntity livingIn) {
        this.caster = livingIn;
        this.casterUuid = livingIn == null ? null : livingIn.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setFacingZ(compound.m_128471_("IsFacingZ"));
        if (compound.m_128403_("OwnerUUID")) {
            this.casterUuid = compound.m_128342_("OwnerUUID");
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsFacingZ", this.isFacingZ());
        if (this.casterUuid != null) {
            compound.m_128362_("OwnerUUID", this.casterUuid);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_146926_(0.0f);
        this.m_146922_(0.0f);
        this.f_20885_ = 0.0f;
        this.f_19859_ = 0.0f;
        this.f_19860_ = 0.0f;
        this.f_20885_ = 0.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        int x = !this.isFacingZ() ? 0 : 1;
        int z = !this.isFacingZ() ? 1 : 0;
        this.rightSection.m_146884_(this.m_20182_().m_82520_((double)x, 0.0, (double)z));
        this.leftSection.m_146884_(this.m_20182_().m_82520_((double)(-x), 0.0, (double)(-z)));
        for (WallExtensionEntity ex : this.parts) {
            ex.f_19854_ = ex.m_20185_();
            ex.f_19855_ = ex.m_20186_();
            ex.f_19856_ = ex.m_20189_();
            ex.f_19790_ = ex.m_20185_();
            ex.f_19791_ = ex.m_20186_();
            ex.f_19792_ = ex.m_20189_();
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.f_19853_.f_46443_) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_12601_, this.m_6121_(), super.m_6100_());
            if (this.f_19853_ instanceof ServerLevel) {
                for (int i = 0; i < 6; ++i) {
                    this.f_19853_.m_7605_((Entity)this, (byte)4);
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.starlit_log.m_49966_()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 1.5, this.m_20189_(), 20, this.m_20191_().m_82362_() / 4.0, this.m_20191_().m_82376_() / 4.0, this.m_20191_().m_82385_() / 4.0, 0.05);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source == DamageSource.f_19317_) {
            return super.m_6469_(source, amount);
        }
        if (source.m_7640_() instanceof LivingEntity) {
            ItemStack stack = ((LivingEntity)source.m_7640_()).m_21205_();
            if (stack.m_41720_() instanceof SkyAxeItem) {
                this.playDamageEffect();
                return super.m_6469_(source, amount);
            }
            if (source.m_7640_() instanceof Player) {
                ((Player)source.m_7640_()).m_5661_((Component)Component.m_237115_((String)"gui.blue_skies.tooltip.invalid_ent_weapon"), true);
            }
        }
        return false;
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof SnowOwlEntity)) {
            super.m_7324_(entityIn);
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof EntRootEntity) {
            return this.m_7307_((Entity)((EntRootEntity)entityIn).getCaster());
        }
        if (entityIn.m_6095_().m_204039_(SkiesEntityTags.NATURE_ALLIES)) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return super.m_7307_(entityIn) && entityIn != null && entityIn != this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12630_, this.m_5720_(), this.m_6121_(), 0.8f, false);
            }
        } else {
            super.m_7822_(id);
        }
    }

    public void playDamageEffect() {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
                float amount = 0.7f;
                float x = !this.isFacingZ() ? 0.2f : amount;
                float z = !this.isFacingZ() ? amount : 0.2f;
                sl.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, SkiesBlocks.starlit_log.m_49966_()), this.m_20185_(), this.m_20186_() + 1.5, this.m_20189_(), 80, (double)x, (double)amount, (double)z, 0.05);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected float m_6121_() {
        return 2.0f;
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean isFacingZ() {
        return (Boolean)this.f_19804_.m_135370_(FACING_Z);
    }

    public void setFacingZ(boolean facingz) {
        this.f_19804_.m_135381_(FACING_Z, (Object)facingz);
    }

    public Iterable<ItemStack> m_6168_() {
        return NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.parts;
    }
}

