/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.entities.util.base.SkiesMountEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;

public class CrystalCamelEntity
extends SkiesMountEntity {
    private static final EntityDataAccessor<Boolean> CHESTED = SynchedEntityData.m_135353_(CrystalCamelEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public CrystalCamelEntity(EntityType<? extends CrystalCamelEntity> type, Level world) {
        super((EntityType<? extends SkiesMountEntity>)type, world);
        this.f_19793_ = 1.0f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{this.getTameItem()}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.15f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHESTED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Chested", this.hasChest());
        if (this.hasChest()) {
            ListTag listnbt = new ListTag();
            for (int i = 2; i < this.getMountInventory().m_6643_(); ++i) {
                ItemStack itemstack = this.getMountInventory().m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundnbt = new CompoundTag();
                compoundnbt.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundnbt);
                listnbt.add((Object)compoundnbt);
            }
            compound.m_128365_("Items", (Tag)listnbt);
        }
    }

    @Override
    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setChested(compound.m_128471_("Chested"));
        if (this.hasChest()) {
            ListTag listnbt = compound.m_128437_("Items", 10);
            this.initMountInventory();
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt = listnbt.m_128728_(i);
                int j = compoundnbt.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.getMountInventory().m_6643_()) continue;
                this.getMountInventory().m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundnbt));
            }
        }
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(CHESTED);
    }

    public void setChested(boolean chested) {
        this.f_19804_.m_135381_(CHESTED, (Object)chested);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_CRYSTAL_CAMEL_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_CRYSTAL_CAMEL_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_CRYSTAL_CAMEL_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SkiesSounds.ENTITY_CRYSTAL_CAMEL_STEP, 0.15f, 1.0f);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == this.getTameItem();
    }

    public CrystalCamelEntity createChild(AgeableMob ageable) {
        CrystalCamelEntity entitycamel = (CrystalCamelEntity)SkiesEntityTypes.CRYSTAL_CAMEL.m_20615_(this.f_19853_);
        entitycamel.setTamed(this.isTamed());
        return entitycamel;
    }

    public float m_20236_(Pose pose) {
        return this.m_6162_() ? 1.0f : 2.3f;
    }

    public double m_6048_() {
        return this.m_6162_() ? 0.3 : 1.6;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.hasChest() && itemstack.m_204117_(Tags.Items.CHESTS) && !this.m_6162_() && this.isTamed()) {
            itemstack.m_41647_(player, (LivingEntity)this, hand);
            this.setChested(true);
            itemstack.m_41774_(1);
            if (player.f_19853_.f_46443_) {
                player.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_12094_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == this.getTameItem() && !this.isTamed()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.f_19796_.m_188503_(5) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.playTameEffect(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                    this.setTamed(true);
                } else {
                    this.playTameEffect(false);
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            } else if (player.f_19853_.f_46443_) {
                player.f_19853_.m_5594_(player, player.m_20183_(), SoundEvents.f_12096_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6047_() && this.isSaddled() && this.m_20197_().size() < 2) {
            if (!this.f_19853_.f_46443_) {
                player.m_7998_((Entity)this, true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float f = 0.0f;
            float f1 = (float)((!this.m_6084_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            if (this.m_20197_().size() > 1) {
                int i = this.m_20197_().indexOf(passenger);
                if (i == 0) {
                    f = 0.2f;
                } else {
                    this.applyYawToEntity(passenger);
                    f = -0.6f;
                }
                if (passenger instanceof Animal) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vec3 vec3d = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vec3d.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3d.f_82481_);
            if (passenger instanceof Animal && this.m_20197_().size() > 1) {
                int j = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                passenger.m_5618_(((Animal)passenger).f_20883_ + (float)j);
                passenger.m_5616_(passenger.m_6080_() + (float)j);
            }
        }
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.f_19859_ += f1 - f;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + (f1 - f));
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    @Override
    public float m_6113_() {
        return this.m_20160_() ? (this.hasChest() ? 0.17f : 0.2f) : 0.3f;
    }

    @Override
    protected float m_6118_() {
        return this.m_20160_() ? 0.3f : super.m_6118_();
    }

    @Override
    public Item getSaddleItem() {
        return SkiesItems.camel_saddle;
    }

    @Override
    public Item getTameItem() {
        return SkiesItems.scalefruit;
    }

    @Override
    public int getMaxInventorySlots() {
        return 17;
    }
}

