/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.passive;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.BlueSkiesConfig;
import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.entities.util.base.SkiesAnimalEntity;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesSounds;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class ShadeMonitorEntity
extends SkiesAnimalEntity {
    private static final float NATURAL_FESTIVE_CHANCE = 0.4f;
    private static final EntityDataAccessor<Byte> BIOME = SynchedEntityData.m_135353_(ShadeMonitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> FESTIVE_STATUS = SynchedEntityData.m_135353_(ShadeMonitorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ShadeMonitorEntity(EntityType<? extends ShadeMonitorEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(1, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_((TagKey)ItemTags.f_13156_), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIOME, (Object)0);
        this.f_19804_.m_135372_(FESTIVE_STATUS, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setBiome(Biomes.get((Registry<Biome>)this.f_19853_.m_8891_().m_175515_(Registries.f_256952_), (Holder<Biome>)this.f_19853_.m_204166_(this.m_20183_())).getId());
        this.setFestiveStatus(this.f_19796_.m_188501_() < 0.4f ? 1 : 0);
        return spawnDataIn;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("Biome", this.getBiome());
        compound.m_128405_("FestiveStatus", this.getFestiveStatus());
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setBiome(compound.m_128445_("Biome"));
        this.setFestiveStatus(!compound.m_128441_("FestiveStatus") ? (this.f_19796_.m_188501_() < 0.4f ? 1 : 0) : compound.m_128451_("FestiveStatus"));
    }

    public byte getBiome() {
        return (Byte)this.f_19804_.m_135370_(BIOME);
    }

    public void setBiome(byte biome) {
        this.f_19804_.m_135381_(BIOME, (Object)biome);
    }

    public int getFestiveStatus() {
        return (Integer)this.f_19804_.m_135370_(FESTIVE_STATUS);
    }

    public void setFestiveStatus(int flag) {
        this.f_19804_.m_135381_(FESTIVE_STATUS, (Object)flag);
    }

    protected SoundEvent m_7515_() {
        return SkiesSounds.ENTITY_SHADE_MONITOR_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SkiesSounds.ENTITY_SHADE_MONITOR_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_SHADE_MONITOR_DEATH;
    }

    protected float m_6121_() {
        return 1.0f;
    }

    @Override
    public boolean m_6898_(ItemStack stack) {
        return stack.m_41614_() && stack.getFoodProperties((LivingEntity)this).m_38746_() || stack.m_204117_(ItemTags.f_13156_);
    }

    public ShadeMonitorEntity createChild(AgeableMob ageable) {
        byte biome = (double)this.f_19796_.m_188501_() < 0.05 ? Biomes.get((Registry<Biome>)this.f_19853_.m_8891_().m_175515_(Registries.f_256952_), (Holder<Biome>)this.f_19853_.m_204166_(this.m_20183_())).getId() : (this.f_19796_.m_188499_() ? ((ShadeMonitorEntity)ageable).getBiome() : this.getBiome());
        ShadeMonitorEntity child = (ShadeMonitorEntity)SkiesEntityTypes.SHADE_MONITOR.m_20615_(this.f_19853_);
        child.setBiome(biome);
        if (BlueSkiesConfig.COMMON.isHalloween() && this.getFestiveStatus() > 0 && ((ShadeMonitorEntity)ageable).getFestiveStatus() > 0) {
            child.setFestiveStatus(2);
        }
        return child;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.m_6162_() ? 0.3f : 0.6f;
    }

    public boolean m_7327_(Entity entityIn) {
        entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), 2.0f);
        return true;
    }

    public static enum Biomes {
        OVERWORLD(null, "shade_monitor/overworld"),
        SNOWY_BLUE(SkiesBiomeTags.SHADE_MONITOR_SNOWY_BLUE),
        PURPLE(SkiesBiomeTags.SHADE_MONITOR_PURPLE),
        WHITE(SkiesBiomeTags.SHADE_MONITOR_WHITE),
        WHITE_AND_PURPLE(SkiesBiomeTags.SHADE_MONITOR_WHITE_AND_PURPLE),
        RED(SkiesBiomeTags.SHADE_MONITOR_RED),
        PINK(SkiesBiomeTags.SHADE_MONITOR_PINK),
        MUDDY_PURPLE(SkiesBiomeTags.SHADE_MONITOR_MUDDY_PURPLE);

        @Nullable
        private final TagKey<Biome> tagKey;
        private final ResourceLocation texture;

        private Biomes(TagKey<Biome> tagKey, String name) {
            this.tagKey = tagKey;
            this.texture = BlueSkies.locate("textures/entity/" + name + ".png");
        }

        private Biomes(TagKey<Biome> tagKey) {
            this(tagKey, tagKey.f_203868_().m_135815_());
        }

        public byte getId() {
            return (byte)this.ordinal();
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public static Biomes get(Registry<Biome> registry, Holder<Biome> biome) {
            for (Biomes b : Biomes.values()) {
                if (b.tagKey == null || !registry.m_203561_(b.tagKey).m_203333_(biome)) continue;
                return b;
            }
            if (registry.m_203561_(SkiesBiomeTags.EVERDAWN).m_203333_(biome)) {
                return PURPLE;
            }
            return OVERWORLD;
        }

        public static Biomes byId(int id) {
            return id < 0 || id >= Biomes.values().length ? OVERWORLD : Biomes.values()[id];
        }
    }
}

