/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.items.util.IRarityItem;
import com.legacy.blue_skies.items.util.ISpecialTabItem;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LootBagItem
extends Item
implements IRarityItem,
ISpecialTabItem {
    public LootBagItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ResourceLocation lootTableLocation;
        ItemStack stack = player.m_21120_(hand);
        CompoundTag stackNbt = stack.m_41783_();
        if (!player.m_150110_().f_35937_) {
            player.m_21008_(hand, ItemStack.f_41583_);
        }
        if ((lootTableLocation = this.getLootTable(stack)) != null) {
            if (!world.f_46443_) {
                LootTable lootTable = world.m_7654_().m_129898_().m_79217_(lootTableLocation);
                LootContext.Builder lootContext = new LootContext.Builder((ServerLevel)world);
                LootContext ctx = lootContext.m_78975_(LootContextParamSets.f_81410_);
                lootTable.m_230922_(ctx).forEach(item -> world.m_7967_((Entity)new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), item)));
                world.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SkiesSounds.ITEM_BAG_OPEN, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 1.0f);
                player.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        BlueSkies.LOGGER.error("Tag not valid: {}", (Object)stackNbt);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Nullable
    public ResourceLocation getLootTable(ItemStack stack) {
        String lootTable;
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && !(lootTable = nbt.m_128461_("LootTable")).isEmpty()) {
            return new ResourceLocation(lootTable);
        }
        return null;
    }

    public void setLootTable(ItemStack stack, ResourceLocation table) {
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128359_("LootTable", table.toString());
    }

    @Override
    public void fillTabs(CreativeModeTab.Output output) {
        this.fillItemCategoryWithRarity(output, this, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setRarityTag(stack, IRarityItem.SkiesRarity.COMMON);
        output.m_246267_(stack, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> lore, TooltipFlag flag) {
        this.addRarityText(stack, lore);
        if (this.getLootTable(stack) != null && flag.m_7050_()) {
            lore.add((Component)Component.m_237113_((String)this.getLootTable(stack).toString()).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
    }
}

