/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.client.particle.BriskPetalParticle;
import com.legacy.blue_skies.client.particle.DuskParticle;
import com.legacy.blue_skies.client.particle.DustParticle;
import com.legacy.blue_skies.client.particle.EverbrightPortalParticle;
import com.legacy.blue_skies.client.particle.EverdawnPortalParticle;
import com.legacy.blue_skies.client.particle.FallingLeafParticle;
import com.legacy.blue_skies.client.particle.FluctuantSphereBeamParticle;
import com.legacy.blue_skies.client.particle.FluctuantSphereParticle;
import com.legacy.blue_skies.client.particle.FroseSnowParticle;
import com.legacy.blue_skies.client.particle.PoisonParticle;
import com.legacy.blue_skies.client.particle.SearingSmokeParticle;
import com.legacy.blue_skies.client.particle.SkyFlameParticle;
import com.legacy.blue_skies.client.particle.StarFlareParticle;
import com.legacy.blue_skies.client.particle.StarGlimmerParticle;
import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.client.particle.data.StarFlareData;
import com.mojang.serialization.Codec;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegisterEvent;

public class SkiesParticles {
    public static final SimpleParticleType BLUE_FLAME = new SimpleParticleType(false);
    public static final SimpleParticleType BLACK_FLAME = new SimpleParticleType(false);
    public static final SimpleParticleType EVERBRIGHT_PORTAL = new SimpleParticleType(false);
    public static final SimpleParticleType EVERDAWN_PORTAL = new SimpleParticleType(false);
    public static final ParticleType<PoisonData> POISON = new ParticleType<PoisonData>(false, PoisonData.DESERIALIZER){

        public Codec<PoisonData> m_7652_() {
            return PoisonData.CODEC;
        }
    };
    public static final ParticleType<StarFlareData> STAR_FLARE = new ParticleType<StarFlareData>(true, StarFlareData.DESERIALIZER){

        public Codec<StarFlareData> m_7652_() {
            return StarFlareData.CODEC;
        }
    };
    public static final SimpleParticleType DUSK_SMOKE = new SimpleParticleType(false);
    public static final SimpleParticleType FLUCTUANT_SPHERE = new SimpleParticleType(false);
    public static final SimpleParticleType FLUCTUANT_SPHERE_BEAM = new SimpleParticleType(false);
    public static final SimpleParticleType FALLING_LEAF = new SimpleParticleType(false);
    public static final SimpleParticleType DUST = new SimpleParticleType(false);
    public static final SimpleParticleType CRUSHER_DUST = new SimpleParticleType(false);
    public static final SimpleParticleType BRISK_PETAL = new SimpleParticleType(false);
    public static final SimpleParticleType FROSE_SNOW = new SimpleParticleType(false);
    public static final SimpleParticleType SEARING_SMOKE = new SimpleParticleType(false);
    public static final SimpleParticleType STAR_GLIMMER = new SimpleParticleType(false);

    public static void init(RegisterEvent event) {
        SkiesParticles.register(event, "blue_flame", BLUE_FLAME);
        SkiesParticles.register(event, "black_flame", BLACK_FLAME);
        SkiesParticles.register(event, "everbright_portal", EVERBRIGHT_PORTAL);
        SkiesParticles.register(event, "everdawn_portal", EVERDAWN_PORTAL);
        SkiesParticles.register(event, "star_flare", STAR_FLARE);
        SkiesParticles.register(event, "poison", POISON);
        SkiesParticles.register(event, "dusk_smoke", DUSK_SMOKE);
        SkiesParticles.register(event, "fluctuant_sphere", FLUCTUANT_SPHERE);
        SkiesParticles.register(event, "fluctuant_sphere_beam", FLUCTUANT_SPHERE_BEAM);
        SkiesParticles.register(event, "falling_leaf", FALLING_LEAF);
        SkiesParticles.register(event, "dust", DUST);
        SkiesParticles.register(event, "crusher_dust", CRUSHER_DUST);
        SkiesParticles.register(event, "brisk_petal", BRISK_PETAL);
        SkiesParticles.register(event, "frose_snow", FROSE_SNOW);
        SkiesParticles.register(event, "searing_smoke", SEARING_SMOKE);
        SkiesParticles.register(event, "star_glimmer", STAR_GLIMMER);
    }

    private static void register(RegisterEvent event, String key, ParticleType<?> particle) {
        event.register(Registries.f_256890_, BlueSkies.locate(key), () -> particle);
    }

    public static void registerFactories(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)BLUE_FLAME, SkyFlameParticle.Factory::new);
        event.register((ParticleType)BLACK_FLAME, SkyFlameParticle.Factory::new);
        event.register((ParticleType)EVERBRIGHT_PORTAL, EverbrightPortalParticle.Factory::new);
        event.register((ParticleType)EVERDAWN_PORTAL, EverdawnPortalParticle.Factory::new);
        event.register(POISON, PoisonParticle.Factory::new);
        event.register(STAR_FLARE, StarFlareParticle.Factory::new);
        event.register((ParticleType)DUSK_SMOKE, DuskParticle.Factory::new);
        event.register((ParticleType)FLUCTUANT_SPHERE, FluctuantSphereParticle.Factory::new);
        event.register((ParticleType)FLUCTUANT_SPHERE_BEAM, FluctuantSphereBeamParticle.Factory::new);
        event.register((ParticleType)FALLING_LEAF, FallingLeafParticle.Factory::new);
        event.register((ParticleType)DUST, DustParticle.Factory::new);
        event.register((ParticleType)CRUSHER_DUST, DustParticle.Factory::new);
        event.register((ParticleType)BRISK_PETAL, BriskPetalParticle.Factory::new);
        event.register((ParticleType)FROSE_SNOW, FroseSnowParticle.Factory::new);
        event.register((ParticleType)SEARING_SMOKE, SearingSmokeParticle.Factory::new);
        event.register((ParticleType)STAR_GLIMMER, StarGlimmerParticle.Factory::new);
    }

    public static class Register {
        @SubscribeEvent
        public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
            SkiesParticles.registerFactories(event);
        }
    }
}

