/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world;

import com.google.common.collect.Sets;
import com.legacy.blue_skies.world.SkiesBiomeSource;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeBasedChunkGen;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeData;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeIds;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public class SkiesChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final Codec<SkiesChunkGenerator> SKIES_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(chunkGen -> chunkGen.f_62137_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(chunkGen -> chunkGen.m_224341_())).apply((Applicative)instance, instance.stable(SkiesChunkGenerator::new)));
    public static final BlockState AIR = Blocks.f_50016_.m_49966_();
    public static final BlockState WATER = Blocks.f_49990_.m_49966_();
    public SimplexNoise noiseA = null;
    public SimplexNoise noiseB = null;
    public Long seed = null;
    private static final boolean DEBUG = false;
    private static long totalTime = 0L;
    private static long iterations = 0L;

    public SkiesChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    private void setSeed(long seed) {
        this.noiseA = new SimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.LEGACY.m_224687_(seed += (long)this.getSeedModifier())));
        this.noiseB = new SimplexNoise((RandomSource)new WorldgenRandom(WorldgenRandom.Algorithm.LEGACY.m_224687_(seed + 41L)));
        this.seed = seed;
        if (this.f_62137_ instanceof SkiesBiomeSource) {
            ((SkiesBiomeSource)this.f_62137_).setSeed(seed);
        }
    }

    protected int getSeedModifier() {
        return 0;
    }

    public ChunkGeneratorStructureState m_255169_(HolderLookup<StructureSet> structureRegistry, RandomState rand, long serverSeed) {
        this.setSeed(serverSeed);
        return super.m_255169_(structureRegistry, rand, serverSeed);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return SKIES_CODEC;
    }

    public BlockState defaultBlock() {
        return ((NoiseGeneratorSettings)this.m_224341_().get()).f_64440_();
    }

    public int m_214096_(int x, int z, Heightmap.Types heightMap, LevelHeightAccessor level, RandomState randomState) {
        return level.m_141937_() + this.iterateColumn(x, z, new ArrayList<BlockState>(80), heightMap.m_64299_(), level);
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState randomState) {
        ArrayList<BlockState> states = new ArrayList<BlockState>(80);
        this.iterateColumn(x, z, states, null, level);
        return new NoiseColumn(level.m_141937_(), (BlockState[])states.toArray(BlockState[]::new));
    }

    private int iterateColumn(int worldX, int worldZ, List<BlockState> states, @Nullable Predicate<BlockState> stateTest, LevelHeightAccessor level) {
        int terrainHeight = this.getTerrainHeight(worldX, worldZ);
        int maxY = level.m_151558_();
        for (int worldY = level.m_141937_(); worldY < maxY; ++worldY) {
            BiomeData biomeData = BiomeIds.getData(this.getNoisyBiomeId(worldX, worldY, worldZ));
            BlockState state = this.getStateAt(worldX, worldY, worldZ, terrainHeight, biomeData);
            if (stateTest != null && !stateTest.test(state)) break;
            states.add(state);
        }
        return states.size();
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor exc, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.m_224341_().m_203334_()).f_64439_();
        LevelHeightAccessor level = chunkAccess.m_183618_();
        int minY = level.m_141937_();
        int height = level.m_151558_();
        int upperCellCount = Mth.m_14042_((int)(height - minY), (int)noiseSettings.m_189212_());
        if (upperCellCount <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int maxSectionIndex = chunkAccess.m_151564_(upperCellCount * noiseSettings.m_189212_() - 1 + minY);
        int minSectionIndex = chunkAccess.m_151564_(minY);
        HashSet set = Sets.newHashSet();
        for (int i = maxSectionIndex; i >= minSectionIndex; --i) {
            LevelChunkSection section = chunkAccess.m_183278_(i);
            section.m_62981_();
            set.add(section);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"wgen_fill_noise", () -> this.doFill(blender, structureManager, chunkAccess)), Util.m_183991_()).whenCompleteAsync((ca, t) -> {
            for (LevelChunkSection secion : set) {
                secion.m_63006_();
            }
        }, exc);
    }

    private ChunkAccess doFill(Blender blender, StructureManager structureManager, ChunkAccess chunkAccess) {
        int secHeight = 16;
        int secWidth = 16;
        Beardifier beardifier = Beardifier.m_223937_((StructureManager)structureManager, (ChunkPos)chunkAccess.m_7697_());
        Heightmap oceanHM = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap surfaceHM = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkPos = chunkAccess.m_7697_();
        for (int x = 0; x < 16; ++x) {
            int worldX = chunkPos.m_151382_(x);
            for (int z = 0; z < 16; ++z) {
                int worldZ = chunkPos.m_151391_(z);
                int terrainHeight = this.getTerrainHeight(worldX, worldZ);
                int maxGenHeight = Math.max(this.m_6337_(), terrainHeight) + 32;
                block2: for (int sectionY = chunkAccess.m_7103_().length - 1; sectionY > -1; --sectionY) {
                    int worldSectionY = sectionY * 16;
                    LevelChunkSection section = chunkAccess.m_183278_(sectionY);
                    for (int y = 15; y > -1; --y) {
                        int worldY = worldSectionY + y;
                        BiomeData biomeData = BiomeIds.getData(this.getNoisyBiomeId(worldX, worldY, worldZ));
                        BiomeBasedChunkGen biomeBasedGen = biomeData.biomeBasedChunkGen();
                        if (worldY > maxGenHeight && (worldY < biomeBasedGen.minY() - 16 || worldY > biomeBasedGen.maxY() + 16)) continue block2;
                        BlockState state = this.getStateAt(worldX, worldY, worldZ, terrainHeight, biomeData);
                        double beard = beardifier.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(worldX, worldY, worldZ));
                        if (beard > 0.1) {
                            state = this.defaultBlock();
                        }
                        if (state == AIR) continue;
                        section.m_62991_(x, y, z, state, false);
                        oceanHM.m_64249_(x, worldY, z, state);
                        surfaceHM.m_64249_(x, worldY, z, state);
                        if (state.m_60819_().m_76178_()) continue;
                        chunkAccess.m_8113_(new BlockPos(worldX, worldY, worldZ));
                    }
                }
            }
        }
        return chunkAccess;
    }

    private BlockState getStateAt(int worldX, int worldY, int worldZ, int terrainHeight, BiomeData biomeData) {
        BiomeBasedChunkGen bbChunkGen;
        BlockState state = worldY <= terrainHeight ? this.defaultBlock() : (worldY <= this.m_6337_() ? WATER : AIR);
        int variance = biomeData.variance();
        double extraNoiseRange = Math.min(12.0, (double)variance * 0.4);
        if ((double)worldY <= (double)terrainHeight + extraNoiseRange && (double)worldY >= (double)terrainHeight - extraNoiseRange) {
            double nB;
            double nAScale = 0.004;
            double nA = this.noiseA.m_75467_((double)worldX * 0.004, (double)worldY * 0.004 * 0.1, (double)worldZ * 0.004);
            double nRScale = 0.03;
            double nR = this.noiseA.m_75467_((double)worldX * 0.03, (double)worldY * 0.03, (double)worldZ * 0.03);
            if (nA * 0.9 + nR * 0.1 > 0.68) {
                state = this.defaultBlock();
            }
            if (variance > 8 && (nB = this.noiseB.m_75467_((double)worldX * 0.004, (double)worldY * 0.004 * 3.0, (double)worldZ * 0.004)) * 0.8 + nR * 0.2 > 0.7) {
                state = AIR;
            }
        }
        if (worldY >= (bbChunkGen = biomeData.biomeBasedChunkGen()).minY() && worldY <= bbChunkGen.maxY()) {
            state = bbChunkGen.genFunc().apply(state, this, terrainHeight, worldX, worldY, worldZ);
        }
        return state;
    }

    private int getTerrainHeight(int worldX, int worldZ) {
        if (this.f_62137_ instanceof SkiesBiomeSource) {
            return ((SkiesBiomeSource)this.f_62137_).getHeight(worldX, worldZ);
        }
        return 70;
    }

    private int getBiomeId(int worldX, int worldY, int worldZ) {
        if (this.f_62137_ instanceof SkiesBiomeSource) {
            return ((SkiesBiomeSource)this.f_62137_).getBiomeID(worldX, worldY, worldZ);
        }
        return BiomeIds.PLAINS;
    }

    private int getNoisyBiomeId(int worldX, int worldY, int worldZ) {
        double scale = 0.04;
        double x = (double)worldX * scale;
        double y = (double)worldY * scale;
        double z = (double)worldZ * scale;
        int xOffset = (int)Math.round(this.noiseA.m_75467_(x, y, z) * 3.0);
        int zOffset = (int)Math.round(this.noiseB.m_75467_(x, y, z) * 3.0);
        return this.getBiomeId(worldX + xOffset, worldY, worldZ + zOffset);
    }
}

