/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.command;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.jline.utils.Levenshtein;
import ovh.corail.woodcutter.command.WoodcuttingJsonRecipe;
import ovh.corail.woodcutter.compatibility.SupportMods;
import ovh.corail.woodcutter.helper.Helper;
import ovh.corail.woodcutter.helper.LangKey;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommandWoodcutter {
    private final Set<Item> logs = new HashSet<Item>();
    private final Map<Item, WoodCompo> plankToLog = new HashMap<Item, WoodCompo>();
    private static final String MODID_PARAM = "modid";
    private static final String RECIPE_PARAM = "recipe";
    private static final int PACK_FORMAT = 9;
    private static final Predicate<ItemStack> VANILLA_ITEM = stack -> !stack.m_41619_() && "minecraft".equals(Helper.getRegistryNamespace(stack.m_41720_()));
    private static final Predicate<ItemStack> NOT_VANILLA_ITEM = stack -> !stack.m_41619_() && !"minecraft".equals(Helper.getRegistryNamespace(stack.m_41720_()));
    private static final Predicate<String> INVALID_MODID = modid -> modid == null || "minecraft".equals(modid) || !ModList.get().isLoaded(modid) || SupportMods.hasSupport(modid);
    private static final BiPredicate<String, String> ALMOSTLY_SIMILAR_PATH = (s1, s2) -> Levenshtein.distance((CharSequence)s1, (CharSequence)s2, (int)1, (int)0, (int)1, (int)10) <= 3;
    private static final BiFunction<MinecraftServer, String, File> DATAPACK_FOLDER = (server, folder) -> new File(server.m_129843_(LevelResource.f_78180_).toFile(), (String)folder);
    private static final Function<String, File> CONFIG_FOLDER = folder -> new File(FMLPaths.CONFIGDIR.get().toFile(), "corail_woodcutter" + File.separatorChar + folder);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_MODID = (ctx, build) -> SharedSuggestionProvider.m_82981_(ModList.get().applyForEachModContainer(ModContainer::getModId).filter(SupportMods::noSupport).filter(modid -> !"minecraft".equals(modid)), (SuggestionsBuilder)build);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_CRAFTING_RECIPES = (ctx, build) -> SharedSuggestionProvider.m_82957_(((CommandSourceStack)ctx.getSource()).m_81377_().m_129894_().m_44054_(RecipeType.f_44107_).keySet().stream(), (SuggestionsBuilder)build);
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();

    private CommandWoodcutter() {
    }

    private int showUsage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_(LangKey.COMMAND_USAGE.getText(new Object[0]), false);
        return 1;
    }

    private int applyDataPack(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        String zipName = this.getZipName(modid);
        File configDatapackZip = CONFIG_FOLDER.apply(zipName);
        if (!configDatapackZip.exists()) {
            throw LangKey.DATAPACK_NOT_GENERATED.asCommandException(modid);
        }
        File destination = DATAPACK_FOLDER.apply(((CommandSourceStack)context.getSource()).m_81377_(), zipName);
        if (destination.exists()) {
            this.disableDataPack((CommandSourceStack)context.getSource(), modid);
            if (!destination.delete()) {
                throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
            }
        }
        try {
            FileUtils.copyFile((File)configDatapackZip, (File)destination);
            this.discoverNewDataPack(((CommandSourceStack)context.getSource()).m_81377_());
            ((CommandSourceStack)context.getSource()).m_81354_(LangKey.DATAPACK_APPLY_SUCCESS.getText(new Object[0]), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.DATAPACK_APPLY_FAIL.asCommandException(LangKey.FILE_COPY_FAIL.getText(destination.getAbsolutePath()));
        }
    }

    private int removeDataPack(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        File destination = DATAPACK_FOLDER.apply(((CommandSourceStack)context.getSource()).m_81377_(), this.getZipName(modid));
        if (!destination.exists()) {
            throw LangKey.DATAPACK_REMOVE_ABSENT.asCommandException(new Object[0]);
        }
        this.disableDataPack((CommandSourceStack)context.getSource(), modid);
        if (!destination.delete()) {
            throw LangKey.DATAPACK_REMOVE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(destination.getAbsolutePath()));
        }
        ((CommandSourceStack)context.getSource()).m_81354_(LangKey.DATAPACK_REMOVE_SUCCESS.getText(new Object[0]), false);
        return 1;
    }

    private int generateDataPack(CommandContext<CommandSourceStack> context) {
        String modid = StringArgumentType.getString(context, (String)MODID_PARAM);
        if (INVALID_MODID.test(modid)) {
            throw LangKey.INVALID_MODID.asCommandException(new Object[0]);
        }
        MinecraftServer server = ((CommandSourceStack)context.getSource()).m_81377_();
        this.initPlanksToLogs(server);
        Map<String, WoodcuttingJsonRecipe> recipes = this.getJsonRecipes(this.getCraftingRecipes(server, recipe -> modid.equals(recipe.m_6423_().m_135827_()) && NOT_VANILLA_ITEM.test(recipe.m_8043_())));
        if (recipes.isEmpty()) {
            throw LangKey.NO_VALID_RECIPE_FOR_MODID.asCommandException(modid);
        }
        File datapackFolder = CONFIG_FOLDER.apply("corail_woodcutter_" + modid);
        File dataFolder = new File(datapackFolder, "data");
        File recipeFolder = new File(dataFolder, "corail_woodcutter_" + modid + File.separatorChar + "recipes");
        if (recipeFolder.exists()) {
            try {
                FileUtils.cleanDirectory((File)recipeFolder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!recipeFolder.exists() && !recipeFolder.mkdirs()) {
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FOLDER_CREATE_FAIL.getText(recipeFolder.getAbsolutePath()));
        }
        for (Map.Entry<String, WoodcuttingJsonRecipe> entry : recipes.entrySet()) {
            File file = new File(recipeFolder, entry.getKey() + ".json");
            if (file.exists() && !file.delete()) {
                throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_DELETE_FAIL.getText(file.getAbsolutePath()));
            }
            if (this.toFile(file, entry.getValue().withConditions(new WoodcuttingJsonRecipe.ConditionMod(modid), new WoodcuttingJsonRecipe.ConditionMod("corail_woodcutter"), new WoodcuttingJsonRecipe.ConditionItem(entry.getValue().result)))) continue;
            throw LangKey.DATAPACK_GENERATE_FAIL.asCommandException(LangKey.FILE_WRITE_FAIL.getText(file.getAbsolutePath()));
        }
        if (!this.addMcMeta(datapackFolder, modid)) {
            throw LangKey.MCMETA_CREATE_FAIL.asCommandException(new Object[0]);
        }
        try {
            this.toZip(datapackFolder.toPath(), modid);
            ((CommandSourceStack)context.getSource()).m_81354_(LangKey.DATAPACK_GENERATE_SUCCESS.getText(recipes.size()), false);
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw LangKey.ZIP_CREATE_FAIL.asCommandException(new Object[0]);
        }
    }

    private WoodCompo getWoodCompo(NonNullList<Ingredient> ingredients) {
        Function<Predicate, Ingredient> findIngredient = predic -> ingredients.stream().filter(ing -> !ing.m_43947_() && Arrays.stream(ing.m_43908_()).allMatch((Predicate<ItemStack>)predic)).findFirst().orElse(null);
        Ingredient plankIngredient = findIngredient.apply(stack -> this.plankToLog.containsKey(stack.m_41720_()));
        if (plankIngredient != null) {
            HashSet<Item> planks = new HashSet<Item>();
            int vanillaPlanks = 0;
            for (ItemStack stack2 : plankIngredient.m_43908_()) {
                if (!planks.add(stack2.m_41720_()) || !VANILLA_ITEM.test(stack2) || ++vanillaPlanks <= 1) continue;
                return WoodCompo.ANY_WOOD;
            }
            if (planks.size() == 1) {
                return this.plankToLog.get(planks.iterator().next());
            }
            WoodCompo compo = this.plankToLog.get(planks.iterator().next());
            return this.getTagForIngredient(plankIngredient).map(tag -> new WoodCompo((ResourceLocation)tag, true, compo.logName(), compo.isLogTag())).orElse(compo);
        }
        Ingredient ingredient = Optional.ofNullable(findIngredient.apply(stack -> this.logs.contains(stack.m_41720_()))).orElse(findIngredient.apply(stack -> Helper.isInTag(stack.m_41720_(), (TagKey<Item>)ItemTags.f_13175_)));
        if (ingredient != null) {
            String itemName = Helper.getRegistryName(ingredient.m_43908_()[0].m_41720_()).replaceAll("_log|_stem|_slab", "_plank");
            WoodCompo compo = this.plankToLog.entrySet().stream().filter(entry -> ALMOSTLY_SIMILAR_PATH.test(Helper.getRegistryName((Item)entry.getKey()), itemName)).findFirst().map(Map.Entry::getValue).orElse(null);
            if (compo != null) {
                return compo;
            }
        }
        return WoodCompo.ANY_WOOD;
    }

    private void initPlanksToLogs(MinecraftServer server) {
        if (!this.plankToLog.isEmpty()) {
            return;
        }
        Helper.fillItemSet(this.logs, (TagKey<Item>)ItemTags.f_13182_);
        ForgeRegistries.ITEMS.getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135815_().endsWith("_log") || ((ResourceKey)entry.getKey()).m_135782_().m_135815_().endsWith("_stem")).map(Map.Entry::getValue).forEach(this.logs::add);
        this.getCraftingRecipes(server, this::isLogToPlankRecipe).forEach(logRecipe -> this.plankToLog.computeIfAbsent(logRecipe.m_8043_().m_41720_(), plank -> {
            ResourceLocation plankName = Helper.getRegistryRL(plank);
            Ingredient ingredient = (Ingredient)logRecipe.m_7527_().get(0);
            Optional<ResourceLocation> tagName = this.getTagForIngredient(ingredient);
            if (tagName.isPresent()) {
                return new WoodCompo(plankName, false, tagName.get(), true);
            }
            ItemStack[] stacks = ingredient.m_43908_();
            Set<ResourceLocation> commonTags = this.getCommonTags(stacks, plankName.m_135827_());
            if (stacks.length == 1) {
                ResourceLocation logName2 = Helper.getRegistryRL(stacks[0]);
                String logPath = logName2.m_135815_().replace("stripped_", "");
                return commonTags.stream().filter(rl -> ALMOSTLY_SIMILAR_PATH.test(logPath, rl.m_135815_())).findFirst().map(rl -> new WoodCompo(plankName, false, (ResourceLocation)rl, true)).orElse(new WoodCompo(plankName, false, logName2, false));
            }
            Set logNames = Arrays.stream(stacks).map(ItemStack::m_41720_).map(Helper::getRegistryRL).collect(Collectors.toSet());
            for (ResourceLocation tagRL : commonTags) {
                if (!logNames.stream().anyMatch(logName -> ALMOSTLY_SIMILAR_PATH.test(logName.m_135815_().replace("stripped_", ""), tagRL.m_135815_()))) continue;
                return new WoodCompo(plankName, false, tagRL, true);
            }
            return new WoodCompo(plankName, false, logNames.stream().min(Comparator.comparingInt(rl -> Levenshtein.distance((CharSequence)rl.m_135815_(), (CharSequence)plankName.m_135815_()))).orElse(null), false);
        }));
        this.plankToLog.put(Items.f_42795_, new WoodCompo(new ResourceLocation("forge", "planks/acacia"), true, ItemTags.f_13186_.f_203868_(), true));
        this.plankToLog.put(Items.f_42753_, new WoodCompo(new ResourceLocation("forge", "planks/birch"), true, ItemTags.f_13185_.f_203868_(), true));
        this.plankToLog.put(Items.f_42796_, new WoodCompo(new ResourceLocation("forge", "planks/dark_oak"), true, ItemTags.f_13183_.f_203868_(), true));
        this.plankToLog.put(Items.f_42794_, new WoodCompo(new ResourceLocation("forge", "planks/jungle"), true, ItemTags.f_13187_.f_203868_(), true));
        this.plankToLog.put(Items.f_42647_, new WoodCompo(new ResourceLocation("forge", "planks/oak"), true, ItemTags.f_13184_.f_203868_(), true));
        this.plankToLog.put(Items.f_42700_, new WoodCompo(new ResourceLocation("forge", "planks/spruce"), true, ItemTags.f_13188_.f_203868_(), true));
        this.plankToLog.put(Items.f_42797_, new WoodCompo(new ResourceLocation("forge", "planks/crimson"), true, ItemTags.f_13189_.f_203868_(), true));
        this.plankToLog.put(Items.f_42798_, new WoodCompo(new ResourceLocation("forge", "planks/warped"), true, ItemTags.f_13190_.f_203868_(), true));
        this.plankToLog.put(Items.f_220174_, new WoodCompo(new ResourceLocation("minecraft", "mangrove_planks"), false, ItemTags.f_215869_.f_203868_(), true));
        Helper.getItems((TagKey<Item>)ItemTags.f_13168_).forEach(key -> this.plankToLog.computeIfAbsent((Item)key.m_203334_(), item -> new WoodCompo(Helper.getRegistryRL(item), false, null, false)));
    }

    private Set<ResourceLocation> getCommonTags(ItemStack[] stacks, String namespace) {
        if (stacks.length == 0) {
            return Collections.emptySet();
        }
        Set<ResourceLocation> commonTags = stacks[0].m_204131_().map(TagKey::f_203868_).collect(Collectors.toSet());
        commonTags.removeIf(rl -> !namespace.equals(rl.m_135827_()));
        if (stacks.length > 1) {
            IntStream.range(1, stacks.length).forEach(i -> commonTags.retainAll(stacks[i].m_204131_().map(TagKey::f_203868_).collect(Collectors.toSet())));
        }
        return commonTags;
    }

    private Optional<ResourceLocation> getTagForIngredient(Ingredient ingredient) {
        return Arrays.stream(ingredient.f_43902_).filter(v -> v instanceof Ingredient.TagValue).findFirst().map(tagValue -> ((Ingredient.TagValue)tagValue).f_43959_).map(TagKey::f_203868_);
    }

    private Set<Recipe<CraftingContainer>> getCraftingRecipes(MinecraftServer server, Predicate<Recipe<CraftingContainer>> recipePredicate) {
        return server.m_129894_().m_44054_(RecipeType.f_44107_).values().stream().filter(recipePredicate).collect(Collectors.toSet());
    }

    private boolean isLogToPlankRecipe(Recipe<CraftingContainer> recipe) {
        if ("minecraft".equals(recipe.m_6423_().m_135827_()) || recipe.m_7527_().size() != 1 || !(recipe instanceof ShapelessRecipe)) {
            return false;
        }
        ItemStack resultItem = recipe.m_8043_();
        if (NOT_VANILLA_ITEM.test(resultItem) && (resultItem.m_204117_(ItemTags.f_13168_) || Helper.getRegistryPath(resultItem.m_41720_()).endsWith("_planks"))) {
            Ingredient ingredient = recipe.m_7527_().stream().filter(ing -> !ing.m_43947_()).findFirst().orElse(Ingredient.f_43901_);
            return NOT_VANILLA_ITEM.test(ingredient.m_43908_()[0]) && this.logs.contains(ingredient.m_43908_()[0].m_41720_()) && Arrays.stream(ingredient.m_43908_()).allMatch(NOT_VANILLA_ITEM);
        }
        return false;
    }

    private String getZipName(String modid) {
        return "corail_woodcutter_" + modid + ".zip";
    }

    private void toZip(Path source, String modid) throws IOException {
        try (final ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(CONFIG_FOLDER.apply(this.getZipName(modid)).toPath(), new OpenOption[0])));){
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path visitedPath, BasicFileAttributes attributes) {
                    if (!visitedPath.toFile().isDirectory()) {
                        String stringPath = visitedPath.toString();
                        ZipEntry zipentry = new ZipEntry(stringPath.endsWith("pack.mcmeta") ? "pack.mcmeta" : stringPath.substring(stringPath.indexOf("data")).replace('\\', '/'));
                        try {
                            outputStream.putNextEntry(zipentry);
                            com.google.common.io.Files.asByteSource((File)visitedPath.toFile()).copyTo((OutputStream)outputStream);
                            outputStream.closeEntry();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private void disableDataPack(CommandSourceStack source, String modid) {
        PackRepository packs = source.m_81377_().m_129891_();
        Pack pack = packs.m_10507_("file/" + this.getZipName(modid));
        if (pack != null && packs.m_10524_().contains(pack)) {
            ArrayList selectedPacks = Lists.newArrayList((Iterable)packs.m_10524_());
            selectedPacks.remove(pack);
            source.m_81377_().m_129861_(selectedPacks.stream().map(Pack::m_10446_).toList());
        }
    }

    private void discoverNewDataPack(MinecraftServer server) {
        PackRepository packs = server.m_129891_();
        ArrayList selectedPackIds = Lists.newArrayList((Iterable)packs.m_10523_());
        packs.m_10506_();
        List disabledPackIds = server.m_129910_().m_6645_().f_244096_().m_45855_();
        for (String packId : packs.m_10514_()) {
            if (disabledPackIds.contains(packId) || selectedPackIds.contains(packId)) continue;
            selectedPackIds.add(packId);
        }
        server.m_129861_((Collection)selectedPackIds);
    }

    private <T> boolean toFile(File file, T object) {
        boolean bl;
        FileWriter fw = new FileWriter(file, StandardCharsets.UTF_8);
        try {
            fw.write(GSON.toJson(object));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        fw.close();
        return bl;
    }

    private boolean addMcMeta(File datapackFolder, String modid) {
        File file = new File(datapackFolder, "pack.mcmeta");
        if (file.exists()) {
            return true;
        }
        JsonObject json = new JsonObject();
        JsonObject pack = new JsonObject();
        json.add("pack", (JsonElement)pack);
        pack.addProperty("description", "Corail Woodcutter: " + StringUtils.capitalize((String)modid) + " Resources");
        pack.addProperty("pack_format", (Number)9);
        return this.toFile(file, json);
    }

    private Map<String, WoodcuttingJsonRecipe> getJsonRecipes(Set<Recipe<CraftingContainer>> recipes) {
        HashMap<String, WoodcuttingJsonRecipe> jsonRecipes = new HashMap<String, WoodcuttingJsonRecipe>();
        for (Recipe<CraftingContainer> recipe : recipes) {
            int count;
            WoodCompo compo;
            ItemStack stack;
            double weight = this.getWeight(recipe);
            if (weight == 0.0) continue;
            ItemStack result = recipe.m_8043_();
            NonNullList ingredients = recipe.m_7527_();
            ResourceLocation outputName = Helper.getRegistryRL(result);
            if (ingredients.size() == 1 && this.logs.contains((stack = ((Ingredient)ingredients.get(0)).m_43908_()[0]).m_41720_()) && (compo = this.plankToLog.get(result.m_41720_())) != null) {
                this.addLogRecipe(jsonRecipes, compo, outputName, result.m_41613_() / stack.m_41613_());
                continue;
            }
            WoodCompo compo2 = this.getWoodCompo((NonNullList<Ingredient>)ingredients);
            int n = count = weight < 1.0 ? Mth.m_14107_((double)(1.0 / weight)) : 1;
            if (weight < 3.1) {
                this.addPlankRecipe(jsonRecipes, compo2, outputName, count);
                this.addLogRecipe(jsonRecipes, compo2, outputName, count * 4);
                continue;
            }
            this.addLogRecipe(jsonRecipes, compo2, outputName, count);
        }
        return jsonRecipes;
    }

    private void addRecipe(Map<String, WoodcuttingJsonRecipe> recipes, ResourceLocation input, ResourceLocation output, int count, boolean isTag) {
        Object inputName = input.m_135827_().equals("forge") && input.m_135815_().startsWith("planks/") ? input.m_135815_().replace("planks/", "") + "_planks" : input.m_135815_().replaceAll("/|\\\\", "_");
        recipes.put(output.m_135815_() + "_from_" + (String)inputName, new WoodcuttingJsonRecipe(input.toString(), output.toString(), count, isTag));
    }

    private void addPlankRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        this.addRecipe(recipes, compo.plankName(), output, count, compo.isPlankTag());
    }

    private void addLogRecipe(Map<String, WoodcuttingJsonRecipe> recipes, WoodCompo compo, ResourceLocation output, int count) {
        Optional.ofNullable(compo.logName()).ifPresent(logName -> this.addRecipe(recipes, (ResourceLocation)logName, output, count, compo.isLogTag()));
    }

    private double getWeight(Recipe<CraftingContainer> recipe) {
        NonNullList ingredients = recipe.m_7527_();
        double weight = 0.0;
        double maxWeight = 5.0 * (double)recipe.m_8043_().m_41613_();
        for (Ingredient ingredient : ingredients) {
            Predicate<Item> predicate;
            if (ingredient.m_43947_()) continue;
            ItemStack[] stacks = ingredient.m_43908_();
            ItemStack stack = stacks[0];
            if (this.logs.contains(stack.m_41720_())) {
                predicate = this.logs::contains;
                weight += 4.0 * (double)stack.m_41613_();
            } else if (this.plankToLog.containsKey(stack.m_41720_())) {
                predicate = this.plankToLog::containsKey;
                weight += 1.0 * (double)stack.m_41613_();
            } else if (stack.m_204117_(Tags.Items.RODS_WOODEN)) {
                predicate = item -> Helper.isInTag(item, (TagKey<Item>)Tags.Items.RODS_WOODEN);
                weight += 0.5 * (double)stack.m_41613_();
            } else if (stack.m_204117_(ItemTags.f_13175_)) {
                predicate = item -> Helper.isInTag(item, (TagKey<Item>)ItemTags.f_13175_);
                weight += 0.5 * (double)stack.m_41613_();
            } else {
                return 0.0;
            }
            if (!(weight > maxWeight) && !Arrays.stream(stacks).anyMatch(s -> !predicate.test(s.m_41720_()))) continue;
            return 0.0;
        }
        return weight / (double)recipe.m_8043_().m_41613_();
    }

    private int testRecipe(CommandContext<CommandSourceStack> context) {
        this.initPlanksToLogs(((CommandSourceStack)context.getSource()).m_81377_());
        ResourceLocation recipeRL = ResourceLocationArgument.m_107011_(context, (String)RECIPE_PARAM);
        Recipe recipe = (Recipe)((CommandSourceStack)context.getSource()).m_81377_().m_129894_().m_44054_(RecipeType.f_44107_).values().stream().filter(r -> r.m_6423_().equals((Object)recipeRL)).findFirst().orElseThrow(() -> new CommandRuntimeException((Component)Component.m_237113_((String)("[" + recipeRL + "] is not a crafting recipe"))));
        Map<String, WoodcuttingJsonRecipe> recipes = this.getJsonRecipes(Collections.singleton(recipe));
        if (recipes.isEmpty()) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)("[" + recipeRL + "] is not a wood recipe")));
        }
        boolean genericTag = false;
        for (Map.Entry<String, WoodcuttingJsonRecipe> entry : recipes.entrySet()) {
            String ingredient = Optional.ofNullable(entry.getValue().ingredient.tag).orElse(entry.getValue().ingredient.item);
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)("name=" + entry.getKey())).m_130946_("\n").m_130946_("ingredient=" + ingredient + " (" + (entry.getValue().ingredient.tag == null ? "item" : "tag") + ")").m_130946_("\n").m_130946_("result=" + entry.getValue().result + "*" + entry.getValue().count), false);
            if (entry.getValue().ingredient.tag == null || !ingredient.equals("minecraft:logs") && !ingredient.equals("minecraft:planks")) continue;
            genericTag = true;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)(genericTag ? "check this recipe as it uses a generic tag that may be incorrect" : "[" + recipeRL + "] is a valid recipe")), false);
        return 1;
    }

    private void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"woodcutter").requires(this::hasPermission)).executes(this::showUsage)).then(BaseAction.INFO.literal().executes(this::showUsage))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)BaseAction.DATAPACK.literal().executes(this::showUsage)).then(((LiteralArgumentBuilder)DataPackAction.GENERATE.literal().executes(this::showUsage)).then(Commands.m_82129_((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::generateDataPack)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataPackAction.APPLY.literal().requires(this::isSinglePlayerOwner)).executes(this::showUsage)).then(Commands.m_82129_((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::applyDataPack)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)DataPackAction.REMOVE.literal().requires(this::isSinglePlayerOwner)).executes(this::showUsage)).then(Commands.m_82129_((String)MODID_PARAM, (ArgumentType)StringArgumentType.word()).suggests(SUGGESTION_MODID).executes(this::removeDataPack))))).then(((LiteralArgumentBuilder)BaseAction.TEST.literal().executes(this::showUsage)).then(Commands.m_82129_((String)RECIPE_PARAM, (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGESTION_CRAFTING_RECIPES).executes(this::testRecipe))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cwc").requires(this::hasPermission)).redirect((CommandNode)command));
    }

    private boolean hasPermission(CommandSourceStack source) {
        return source.m_6761_(2) || this.isSinglePlayerOwner(source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isSinglePlayerOwner(CommandSourceStack source) {
        if (source.m_81377_().m_6982_()) return false;
        if (!source.m_81377_().m_129792_()) return false;
        if (Optional.ofNullable(source.m_81373_()).filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).map(Player::m_36316_).map(profil -> source.m_81377_().m_7779_(profil)).orElse(false) == false) return false;
        return true;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        new CommandWoodcutter().register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private record WoodCompo(ResourceLocation plankName, boolean isPlankTag, @Nullable ResourceLocation logName, boolean isLogTag) {
        private static final WoodCompo ANY_WOOD = new WoodCompo(ItemTags.f_13168_.f_203868_(), true, ItemTags.f_13182_.f_203868_(), true);
    }

    private static enum BaseAction implements IAction
    {
        INFO,
        DATAPACK,
        TEST;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    private static enum DataPackAction implements IAction
    {
        GENERATE,
        APPLY,
        REMOVE;

        private final String name = this.name().toLowerCase(Locale.US);

        public String m_7912_() {
            return this.name;
        }
    }

    private static interface IAction
    extends StringRepresentable {
        default public LiteralArgumentBuilder<CommandSourceStack> literal() {
            return Commands.m_82127_((String)this.m_7912_());
        }
    }
}

