/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.helper;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import ovh.corail.woodcutter.config.ConfigWoodcutter;
import ovh.corail.woodcutter.config.CustomConfig;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

public class Helper {
    public static final Comparator<Recipe<Container>> RECIPE_COMPARATOR = Comparator.comparing(recipe -> {
        String[] name = Helper.getRegistryPath(recipe.m_8043_().m_41720_()).split("_");
        return name[name.length - 1];
    }).thenComparing(recipe -> Helper.getRegistryName(recipe.m_8043_().m_41720_()));

    public static void registerSharedConfig() {
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.getActiveContainer().addConfig((ModConfig)new CustomConfig(ConfigWoodcutter.GENERAL_SPEC, ctx.getActiveContainer()));
    }

    public static List<WoodcuttingRecipe> getSortedMatchingRecipes(Level level, Container inventory) {
        return level.m_7465_().m_44054_(ModRecipeTypes.WOODCUTTING).values().stream().filter(recipe -> recipe.m_5818_(inventory, level)).sorted(RECIPE_COMPARATOR).toList();
    }

    public static ResourceLocation getRegistryRL(ItemStack stack) {
        return Helper.getRegistryRL(stack.m_41720_());
    }

    public static ResourceLocation getRegistryRL(Item item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
    }

    public static ResourceLocation getRegistryRL(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    public static String getRegistryNamespace(Item item) {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((Object)item)).map(ResourceLocation::m_135827_).map(String::toString).orElse("");
    }

    public static String getRegistryPath(Item item) {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((Object)item)).map(ResourceLocation::m_135815_).map(String::toString).orElse("");
    }

    public static String getRegistryName(Item item) {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((Object)item)).map(ResourceLocation::toString).orElse("");
    }

    public static void fillItemSet(Set<Item> items, TagKey<Item> tagKey) {
        BuiltInRegistries.f_257033_.m_206058_(tagKey).forEach(holder -> items.add((Item)holder.m_203334_()));
    }

    public static Iterable<Holder<Item>> getItems(TagKey<Item> tagKey) {
        return BuiltInRegistries.f_257033_.m_206058_(tagKey);
    }

    public static boolean isInTag(Item item, TagKey<Item> tagKey) {
        return StreamSupport.stream(BuiltInRegistries.f_257033_.m_206058_(tagKey).spliterator(), false).anyMatch(holder -> holder.m_203334_() == item);
    }

    public static <T> T unsafeNullCast() {
        return null;
    }
}

