/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrbysco.justaraftmod.client.ClientHandler;
import com.mrbysco.justaraftmod.client.RaftModel;
import com.mrbysco.justaraftmod.entities.Raft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class RaftRenderer
extends EntityRenderer<Raft> {
    private static final ResourceLocation[] RAFT_TEXTURES = new ResourceLocation[]{new ResourceLocation("justaraftmod:textures/entity/raft/oak_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/spruce_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/birch_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/jungle_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/acacia_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/dark_oak_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/bamboo_raft.png"), new ResourceLocation("justaraftmod:textures/entity/raft/mangrove_raft.png")};
    private final RaftModel model;

    public RaftRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new RaftModel(context.m_174023_(ClientHandler.RAFT));
        this.f_114477_ = 0.5f;
    }

    public void render(Raft raft, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        float f2;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float f = (float)raft.m_38385_() - partialTicks;
        float f1 = raft.m_38384_() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)f) * f * f1 / 10.0f * (float)raft.m_38386_()));
        }
        if (!Mth.m_14033_((float)(f2 = raft.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(raft.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        this.model.setupAnim(raft, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(this.model.m_103119_(this.getTextureLocation(raft)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)raft, entityYaw, partialTicks, poseStack, bufferSource, packedLightIn);
    }

    public ResourceLocation getTextureLocation(Raft entity) {
        return RAFT_TEXTURES[entity.getRaftType().ordinal()];
    }
}

