/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.config;

import com.mrbysco.justaraftmod.JustARaftMod;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RaftConfig {
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        JustARaftMod.LOGGER.debug("Loaded JustARaftMod's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        JustARaftMod.LOGGER.debug("JustARaftMod's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.DoubleValue SpeedMultiplier;
        public final ForgeConfigSpec.DoubleValue TurnMultiplier;
        public final ForgeConfigSpec.BooleanValue SlipperyFast;
        public final ForgeConfigSpec.BooleanValue SinkTheRaft;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server settings").push("Server");
            this.SpeedMultiplier = builder.comment("Adjusting this setting changes the speed of the raft. (Default: 1.0) [Lower than 1 = slower | higher than 1 = faster]").defineInRange("SpeedMultiplier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
            this.TurnMultiplier = builder.comment("Adjusting this setting changes the speed of turning the raft. (Default: 1.0) [Lower than 1 = slower | higher than 1 = faster]").defineInRange("TurnMultiplier", 1.0, Double.MIN_VALUE, Double.MAX_VALUE);
            this.SlipperyFast = builder.comment("Changing this to false makes rafts the same speed as on land while on a slippery block. (Default: true)").define("SlipperyFast", true);
            this.SinkTheRaft = builder.comment("Changing this to true makes the raft sink if there's 2 entities on it. (Default: false)").define("SinkTheRaft", false);
            builder.pop();
        }
    }
}

