/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.justaraftmod.entities;

import com.mrbysco.justaraftmod.config.RaftConfig;
import com.mrbysco.justaraftmod.init.RaftRegistry;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class Raft
extends Boat {
    public Raft(EntityType<? extends Raft> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public Raft(Level worldIn, double x, double y, double z) {
        this((EntityType<? extends Raft>)((EntityType)RaftRegistry.RAFT.get()), worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Raft(PlayMessages.SpawnEntity spawnEntity, Level worldIn) {
        this((EntityType<? extends Raft>)((EntityType)RaftRegistry.RAFT.get()), worldIn);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getRaftType().getName());
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setRaftType(Type.byName(tag.m_128461_("Type")));
        }
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (onGround) {
                if (this.f_19789_ > 3.0f) {
                    if (this.f_38279_ != Boat.Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getRaftType().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.m_19998_((ItemLike)Items.f_42398_);
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_) && y < 0.0) {
                this.f_19789_ -= (float)y;
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (((Boolean)RaftConfig.SERVER.SinkTheRaft.get()).booleanValue() && this.m_20197_().size() > 1) {
            Vec3 motion = this.m_20184_();
            double newY = motion.f_82480_ - 0.035;
            this.m_20334_(motion.f_82479_, newY, motion.f_82481_);
        }
    }

    public Boat.Status m_38392_() {
        Boat.Status boatentity$status = this.m_38394_();
        if (boatentity$status != null) {
            this.f_38277_ = this.m_20191_().f_82292_;
            return boatentity$status;
        }
        if (this.m_38393_()) {
            return Boat.Status.IN_WATER;
        }
        float f = this.m_38377_();
        if (f > 0.0f) {
            this.f_38278_ = (Boolean)RaftConfig.SERVER.SlipperyFast.get() != false ? f : 0.0f;
            return Boat.Status.ON_LAND;
        }
        return Boat.Status.IN_AIR;
    }

    public void m_38395_() {
        double d0 = -0.04f;
        double d1 = this.m_20068_() ? 0.0 : d0;
        double d2 = 0.0;
        this.f_38264_ = 0.05f;
        if (this.f_38280_ == Boat.Status.IN_AIR && this.f_38279_ != Boat.Status.IN_AIR && this.f_38279_ != Boat.Status.ON_LAND) {
            this.f_38277_ = this.m_20191_().f_82289_ + (double)this.m_20206_();
            this.m_6034_(this.m_20185_(), (double)(this.m_38371_() - this.m_20206_()) + 0.101, this.m_20189_());
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
            this.f_38281_ = 0.0;
            this.f_38279_ = Boat.Status.IN_WATER;
        } else {
            if (this.f_38279_ == Boat.Status.IN_WATER) {
                d2 = (this.f_38277_ - this.m_20191_().f_82289_ + 0.1) / (double)this.m_20206_();
                this.f_38264_ = 0.9f;
            } else if (this.f_38279_ == Boat.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.f_38264_ = 0.9f;
            } else if (this.f_38279_ == Boat.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.f_38264_ = 0.45f;
            } else if (this.f_38279_ == Boat.Status.IN_AIR) {
                this.f_38264_ = 0.9f;
            } else if (this.f_38279_ == Boat.Status.ON_LAND) {
                this.f_38264_ = this.f_38278_;
                if (this.m_6688_() instanceof Player) {
                    this.f_38278_ /= 2.0f;
                }
            }
            Vec3 Vector3d = this.m_20184_();
            this.m_20334_(Vector3d.f_82479_ * (double)this.f_38264_, Vector3d.f_82480_ + d1, Vector3d.f_82481_ * (double)this.f_38264_);
            this.f_38266_ *= this.f_38264_;
            if (d2 > 0.0) {
                Vec3 Vector3d1 = this.m_20184_();
                this.m_20334_(Vector3d1.f_82479_, (Vector3d1.f_82480_ + d2 * 0.06153846016296973) * 0.75, Vector3d1.f_82481_);
            }
        }
    }

    public void m_38396_() {
        if (this.m_20160_()) {
            float f = 0.0f;
            if (this.f_38273_) {
                this.f_38266_ = (float)((double)this.f_38266_ - 1.0 * (Double)RaftConfig.SERVER.TurnMultiplier.get());
            }
            if (this.f_38274_) {
                this.f_38266_ = (float)((double)this.f_38266_ + 1.0 * (Double)RaftConfig.SERVER.TurnMultiplier.get());
            }
            if (this.f_38274_ != this.f_38273_ && !this.f_38275_ && !this.f_38276_) {
                f += 0.005f;
            }
            this.m_146922_(this.m_146908_() + this.f_38266_);
            if (this.f_38275_) {
                f = (float)((double)f + (double)0.04f * (Double)RaftConfig.SERVER.SpeedMultiplier.get());
            }
            if (this.f_38276_) {
                f = (float)((double)f - (double)0.005f * (Double)RaftConfig.SERVER.SpeedMultiplier.get());
            }
            this.m_20256_(this.m_20184_().m_82520_((double)(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f), 0.0, (double)(Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f)));
            this.m_38339_(this.f_38274_ && !this.f_38273_ || this.f_38275_, this.f_38273_ && !this.f_38274_ || this.f_38275_);
        }
    }

    public double m_6048_() {
        return 0.0;
    }

    public Item m_38369_() {
        return switch (this.getRaftType()) {
            default -> (Item)RaftRegistry.OAK_RAFT.get();
            case Type.SPRUCE -> (Item)RaftRegistry.SPRUCE_RAFT.get();
            case Type.BIRCH -> (Item)RaftRegistry.BIRCH_RAFT.get();
            case Type.JUNGLE -> (Item)RaftRegistry.JUNGLE_RAFT.get();
            case Type.ACACIA -> (Item)RaftRegistry.ACACIA_RAFT.get();
            case Type.DARK_OAK -> (Item)RaftRegistry.DARK_OAK_RAFT.get();
        };
    }

    public void setRaftType(Type type) {
        this.f_19804_.m_135381_(f_38285_, (Object)type.ordinal());
    }

    public Type getRaftType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(f_38285_));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        OAK(Blocks.f_50705_, "oak"),
        SPRUCE(Blocks.f_50741_, "spruce"),
        BIRCH(Blocks.f_50742_, "birch"),
        JUNGLE(Blocks.f_50743_, "jungle"),
        ACACIA(Blocks.f_50744_, "acacia"),
        DARK_OAK(Blocks.f_50745_, "dark_oak"),
        BAMBOO(Blocks.f_50571_, "bamboo"),
        MANGROVE(Blocks.f_220865_, "mangrove");

        private final String name;
        private final Block planks;

        private Type(Block planks, String name) {
            this.name = name;
            this.planks = planks;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int p_38431_) {
            Type[] values = Type.values();
            if (p_38431_ < 0 || p_38431_ >= values.length) {
                p_38431_ = 0;
            }
            return values[p_38431_];
        }

        public static Type byName(String name) {
            Type[] values = Type.values();
            return Arrays.stream(values).filter(type -> type.getName().equals(name)).findFirst().orElse(values[0]);
        }
    }
}

