/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.gui;

import com.chaosthedude.naturescompass.gui.BiomeInfoScreen;
import com.chaosthedude.naturescompass.gui.BiomeSearchList;
import com.chaosthedude.naturescompass.gui.NaturesCompassScreen;
import com.chaosthedude.naturescompass.sorting.NameSorting;
import com.chaosthedude.naturescompass.sorting.SourceSorting;
import com.chaosthedude.naturescompass.sorting.TagsSorting;
import com.chaosthedude.naturescompass.util.BiomeUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeSearchEntry
extends ObjectSelectionList.Entry<BiomeSearchEntry> {
    private final Minecraft mc;
    private final NaturesCompassScreen parentScreen;
    private final Biome biome;
    private final BiomeSearchList biomesList;
    private long lastClickTime;

    public BiomeSearchEntry(BiomeSearchList biomesList, Biome biome) {
        this.biomesList = biomesList;
        this.biome = biome;
        this.parentScreen = biomesList.getParentScreen();
        this.mc = Minecraft.m_91087_();
    }

    public void m_6311_(PoseStack poseStack, int par1, int par2, int par3, int par4, int par5, int par6, int par7, boolean par8, float par9) {
        String tagsLine;
        String title = this.parentScreen.getSortingCategory().getLocalizedName();
        Object value = this.parentScreen.getSortingCategory().getValue(this.biome);
        if (this.parentScreen.getSortingCategory() instanceof NameSorting || this.parentScreen.getSortingCategory() instanceof SourceSorting || this.parentScreen.getSortingCategory() instanceof TagsSorting) {
            title = I18n.m_118938_((String)"string.naturescompass.precipitation", (Object[])new Object[0]);
            value = I18n.m_118938_((String)"string.naturescompass.none", (Object[])new Object[0]);
            if (this.biome.m_47530_() == Biome.Precipitation.SNOW) {
                value = I18n.m_118938_((String)"string.naturescompass.snow", (Object[])new Object[0]);
            } else if (this.biome.m_47530_() == Biome.Precipitation.RAIN) {
                value = I18n.m_118938_((String)"string.naturescompass.rain", (Object[])new Object[0]);
            }
        }
        if (this.mc.f_91062_.m_92895_(tagsLine = I18n.m_118938_((String)"string.naturescompass.tags", (Object[])new Object[0]) + ": " + BiomeUtils.getBiomeTags(this.parentScreen.level, this.biome)) > this.biomesList.m_5759_()) {
            tagsLine = this.mc.f_91062_.m_92834_(tagsLine + "...", this.biomesList.m_5759_()) + "...";
        }
        this.mc.f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome)), (float)(par3 + 1), (float)(par2 + 1), 0xFFFFFF);
        Font font = this.mc.f_91062_;
        MutableComponent mutableComponent = Component.m_237113_((String)(title + ": " + value));
        float f = par3 + 1;
        Objects.requireNonNull(this.mc.f_91062_);
        font.m_92889_(poseStack, (Component)mutableComponent, f, (float)(par2 + 9 + 3), 0x808080);
        Font font2 = this.mc.f_91062_;
        MutableComponent mutableComponent2 = Component.m_237113_((String)tagsLine);
        float f2 = par3 + 1;
        Objects.requireNonNull(this.mc.f_91062_);
        font2.m_92889_(poseStack, (Component)mutableComponent2, f2, (float)(par2 + 9 + 14), 0x808080);
        Font font3 = this.mc.f_91062_;
        MutableComponent mutableComponent3 = Component.m_237115_((String)"string.naturescompass.source").m_7220_((Component)Component.m_237113_((String)(": " + BiomeUtils.getBiomeSource(this.parentScreen.level, this.biome))));
        float f3 = par3 + 1;
        Objects.requireNonNull(this.mc.f_91062_);
        font3.m_92889_(poseStack, (Component)mutableComponent3, f3, (float)(par2 + 9 + 25), 0x808080);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.biomesList.selectBiome(this);
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.searchForBiome();
                return true;
            }
            this.lastClickTime = Util.m_137550_();
            return false;
        }
        return false;
    }

    public void searchForBiome() {
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
        this.parentScreen.searchForBiome(this.biome);
    }

    public void viewInfo() {
        this.mc.m_91152_((Screen)new BiomeInfoScreen(this.parentScreen, this.biome));
    }

    public Component m_142172_() {
        return Component.m_237113_((String)BiomeUtils.getBiomeNameForDisplay(this.parentScreen.level, this.biome));
    }
}

