/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.util;

import com.chaosthedude.naturescompass.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeUtils {
    public static Optional<? extends Registry<Biome>> getBiomeRegistry(Level level) {
        return level.m_8891_().m_6632_(ForgeRegistries.Keys.BIOMES);
    }

    public static Optional<ResourceLocation> getKeyForBiome(Level level, Biome biome) {
        return BiomeUtils.getBiomeRegistry(level).isPresent() ? Optional.of(BiomeUtils.getBiomeRegistry(level).get().m_7981_((Object)biome)) : Optional.empty();
    }

    public static Optional<Biome> getBiomeForKey(Level level, ResourceLocation key) {
        return BiomeUtils.getBiomeRegistry(level).isPresent() ? BiomeUtils.getBiomeRegistry(level).get().m_6612_(key) : Optional.empty();
    }

    public static List<ResourceLocation> getAllowedBiomeKeys(Level level) {
        ArrayList<ResourceLocation> biomeKeys = new ArrayList<ResourceLocation>();
        if (BiomeUtils.getBiomeRegistry(level).isPresent()) {
            for (Map.Entry entry : BiomeUtils.getBiomeRegistry(level).get().m_6579_()) {
                Biome biome = (Biome)entry.getValue();
                if (biome == null) continue;
                Optional<ResourceLocation> optionalBiomeKey = BiomeUtils.getKeyForBiome(level, biome);
                if (biome == null || !optionalBiomeKey.isPresent() || BiomeUtils.biomeKeyIsBlacklisted(level, optionalBiomeKey.get())) continue;
                biomeKeys.add(optionalBiomeKey.get());
            }
        }
        return biomeKeys;
    }

    public static int getBiomeSize(Level world) {
        return 4;
    }

    public static int getDistanceToBiome(Player player, int biomeX, int biomeZ) {
        return BiomeUtils.getDistanceToBiome(player.m_20183_(), biomeX, biomeZ);
    }

    public static int getDistanceToBiome(BlockPos startPos, int biomeX, int biomeZ) {
        return (int)Mth.m_14116_((float)((float)startPos.m_123331_((Vec3i)new BlockPos(biomeX, startPos.m_123342_(), biomeZ))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeTags(Level level, Biome biome) {
        Registry<Biome> biomeRegistry;
        List<String> tagPathsToIgnore = List.of("is_overworld");
        TreeSet<String> biomeCategories = new TreeSet<String>();
        if (BiomeUtils.getBiomeRegistry(level).isPresent() && (biomeRegistry = BiomeUtils.getBiomeRegistry(level).get()).m_7854_((Object)biome).isPresent() && biomeRegistry.m_203636_((ResourceKey)biomeRegistry.m_7854_((Object)biome).get()).isPresent()) {
            Holder biomeHolder = (Holder)biomeRegistry.m_203636_((ResourceKey)biomeRegistry.m_7854_((Object)biome).get()).get();
            List categoryTags = biomeHolder.getTagKeys().filter(tag -> tag.f_203868_().m_135815_().startsWith("is_")).collect(Collectors.toList());
            for (TagKey tag2 : categoryTags) {
                String translatedCategoryKey;
                String translatedBiomeKey;
                String biomeKey;
                if (tagPathsToIgnore.contains(tag2.f_203868_().m_135815_())) continue;
                String fixedPath = tag2.f_203868_().m_135815_().replaceFirst("is_", "");
                if (fixedPath.contains("/")) {
                    fixedPath = fixedPath.substring(0, fixedPath.indexOf("/"));
                }
                if (!(biomeKey = Util.m_137492_((String)"biome", (ResourceLocation)new ResourceLocation(tag2.f_203868_().m_135827_(), fixedPath))).equals(translatedBiomeKey = I18n.m_118938_((String)biomeKey, (Object[])new Object[0]))) {
                    return translatedBiomeKey;
                }
                String categoryKey = Util.m_137492_((String)"category", (ResourceLocation)new ResourceLocation(tag2.f_203868_().m_135827_(), fixedPath));
                if (!categoryKey.equals(translatedCategoryKey = I18n.m_118938_((String)categoryKey, (Object[])new Object[0]))) {
                    return translatedCategoryKey;
                }
                biomeCategories.add(WordUtils.capitalize((String)fixedPath.replace('_', ' ')));
            }
        }
        if (biomeCategories.isEmpty()) {
            biomeCategories.add(I18n.m_118938_((String)"string.naturescompass.none", (Object[])new Object[0]));
        }
        return String.join((CharSequence)", ", biomeCategories);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(Level level, ResourceLocation biome) {
        if (BiomeUtils.getBiomeForKey(level, biome).isPresent()) {
            return BiomeUtils.getBiomeNameForDisplay(level, BiomeUtils.getBiomeForKey(level, biome).get());
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeNameForDisplay(Level level, Biome biome) {
        if (biome != null) {
            if (((Boolean)ConfigHandler.CLIENT.fixBiomeNames.get()).booleanValue()) {
                String original = BiomeUtils.getBiomeName(level, biome);
                Object fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = (String)fixed + " ";
                    }
                    fixed = (String)fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            if (BiomeUtils.getKeyForBiome(level, biome) != null) {
                return I18n.m_118938_((String)BiomeUtils.getKeyForBiome(level, biome).toString(), (Object[])new Object[0]);
            }
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(Level level, Biome biome) {
        return BiomeUtils.getKeyForBiome(level, biome).isPresent() ? I18n.m_118938_((String)Util.m_137492_((String)"biome", (ResourceLocation)BiomeUtils.getKeyForBiome(level, biome).get()), (Object[])new Object[0]) : "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeName(Level level, ResourceLocation key) {
        if (BiomeUtils.getBiomeForKey(level, key).isPresent()) {
            return BiomeUtils.getBiomeName(level, BiomeUtils.getBiomeForKey(level, key).get());
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getBiomeSource(Level level, Biome biome) {
        if (BiomeUtils.getKeyForBiome(level, biome).isEmpty()) {
            return "";
        }
        String modid = BiomeUtils.getKeyForBiome(level, biome).get().m_135827_();
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static boolean biomeKeyIsBlacklisted(Level level, ResourceLocation biomeKey) {
        List biomeBlacklist = (List)ConfigHandler.GENERAL.biomeBlacklist.get();
        for (String key : biomeBlacklist) {
            if (!biomeKey.toString().matches(BiomeUtils.convertToRegex(key))) continue;
            return true;
        }
        return false;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

