/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.eatinganimation.datagen;

import com.google.common.collect.Lists;
import com.matyrobbrt.eatinganimation.EatingAnimation;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

class ItemModelsProvider
extends ItemModelProvider {
    private final ModelFile itemGenerated = this.getExistingFile(this.mcLoc("item/generated"));
    private static final List<Item> DRINKABLES = Lists.newArrayList((Object[])new Item[]{Items.f_42455_, Items.f_42787_});

    public ItemModelsProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "minecraft", existingFileHelper);
    }

    protected void registerModels() {
        EatingAnimation.ANIMATED_FOOD.stream().filter(i -> i != Items.f_42437_).forEach(this::buildModel);
        this.buildModel(Items.f_42437_, "golden_apple", 0.35f, 0.7f, 0.9f);
    }

    private ItemModelBuilder buildModel(Item item) {
        return this.buildModel(item, 0.35f, 0.7f, 0.9f);
    }

    private ItemModelBuilder buildModel(Item item, float ... eatProgress) {
        return this.buildModel(item, BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_(), eatProgress);
    }

    private ItemModelBuilder buildModel(Item item, String initialTexture, float ... eatProgress) {
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.f_257033_.m_7981_((Object)item).toString())).parent(this.itemGenerated)).texture("layer0", "item/" + initialTexture);
        for (int i = 0; i < eatProgress.length; ++i) {
            String modelName = String.format("%s_%s_%s", item == Items.f_42437_ ? "golden_apple" : BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_(), DRINKABLES.contains(item) ? "drinking" : "eating", i);
            ItemModelBuilder overrideModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("eatinganimation:" + modelName)).parent(this.itemGenerated)).texture("layer0", new ResourceLocation("eatinganimation", "item/" + modelName));
            builder.override().predicate(new ResourceLocation("eatinganimation", "eating"), 1.0f).predicate(new ResourceLocation("eatinganimation", "eat"), eatProgress[i]).model((ModelFile)overrideModel);
        }
        return builder;
    }
}

