/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.energy;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.setup.Config;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class EnergyConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_RATE = "rate";
    public static final String TAG_MINMAX = "minmax";
    public static final String TAG_PRIORITY = "priority";
    private EnergyMode energyMode = EnergyMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority"});

    public EnergyConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public EnergyMode getEnergyMode() {
        return this.energyMode;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.energyMode) {
            default -> throw new IncompatibleClassChangeError();
            case EnergyMode.INS -> new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            case EnergyMode.EXT -> new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", (Enum)this.energyMode, (Enum[])EnergyMode.values()).nl().label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 30).nl().label("Rate").integer(TAG_RATE, (this.energyMode == EnergyMode.EXT ? "Max energy extraction rate" : "Max energy insertion rate") + "|(limited to " + (this.advanced ? (Integer)Config.maxRfRateAdvanced.get() : (Integer)Config.maxRfRateNormal.get()) + " per tick)", this.rate, 40).shift(10).label(this.energyMode == EnergyMode.EXT ? "Min" : "Max").integer(TAG_MINMAX, this.energyMode == EnergyMode.EXT ? "Disable extraction if energy|is too low" : "Disable insertion if energy|is too high", this.minmax, 50);
    }

    public boolean isEnabled(String tag) {
        if (this.energyMode == EnergyMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return false;
        }
        return EXTRACT_TAGS.contains(tag);
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getRate() {
        return this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.energyMode = EnergyMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.rate = (Integer)data.get(TAG_RATE);
        this.minmax = (Integer)data.get(TAG_MINMAX);
        this.priority = (Integer)data.get(TAG_PRIORITY);
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        EnergyConnectorSettings.setEnumSafe((JsonObject)object, (String)"energymode", (Enum)this.energyMode);
        EnergyConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_PRIORITY, (Integer)this.priority);
        EnergyConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_RATE, (Integer)this.rate);
        EnergyConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_MINMAX, (Integer)this.minmax);
        if (this.rate != null && this.rate > (Integer)Config.maxRfRateNormal.get()) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.energyMode = (EnergyMode)EnergyConnectorSettings.getEnumSafe((JsonObject)object, (String)"energymode", EnumStringTranslators::getEnergyMode);
        this.priority = EnergyConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_PRIORITY);
        this.rate = EnergyConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_RATE);
        this.minmax = EnergyConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_MINMAX);
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.energyMode = EnergyMode.values()[tag.m_128445_("itemMode")];
        this.priority = tag.m_128441_(TAG_PRIORITY) ? Integer.valueOf(tag.m_128451_(TAG_PRIORITY)) : null;
        this.rate = tag.m_128441_(TAG_RATE) ? Integer.valueOf(tag.m_128451_(TAG_RATE)) : null;
        this.minmax = tag.m_128441_(TAG_MINMAX) ? Integer.valueOf(tag.m_128451_(TAG_MINMAX)) : null;
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("itemMode", (byte)this.energyMode.ordinal());
        if (this.priority != null) {
            tag.m_128405_(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.rate != null) {
            tag.m_128405_(TAG_RATE, this.rate.intValue());
        }
        if (this.minmax != null) {
            tag.m_128405_(TAG_MINMAX, this.minmax.intValue());
        }
    }

    public static enum EnergyMode {
        INS,
        EXT;

    }
}

