/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.logic.ConnectorIterator;
import mcjty.xnet.logic.RouterIterator;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LogicTools {
    @Nullable
    public static TileEntityController getControllerForConnector(@Nonnull Level world, @Nonnull BlockPos connectorPos) {
        BlockPos controllerPos = LogicTools.getControllerPosForConnector(world, connectorPos);
        if (controllerPos == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)controllerPos)) {
            return null;
        }
        BlockEntity te = world.m_7702_(controllerPos);
        if (te instanceof TileEntityController) {
            return (TileEntityController)te;
        }
        return null;
    }

    @Nullable
    public static BlockPos getControllerPosForConnector(@Nonnull Level world, @Nonnull BlockPos connectorPos) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        NetworkId networkId = worldBlob.getNetworkAt(connectorPos);
        if (networkId == null) {
            return null;
        }
        return worldBlob.getProviderPosition(networkId);
    }

    public static Stream<BlockPos> consumers(@Nonnull Level world, @Nonnull NetworkId networkId) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        return worldBlob.getConsumers(networkId).stream();
    }

    public static Stream<BlockPos> connectors(@Nonnull Level world, @Nonnull BlockPos pos) {
        return new ConnectorIterator(world, pos, false).stream();
    }

    public static Stream<BlockPos> routingConnectors(@Nonnull Level world, @Nonnull BlockPos pos) {
        return new ConnectorIterator(world, pos, true).stream();
    }

    public static Stream<TileEntityRouter> routers(@Nonnull Level world, @Nonnull BlockPos pos) {
        return new RouterIterator<TileEntityRouter>(world, pos, TileEntityRouter.class).stream();
    }

    public static Stream<TileEntityWirelessRouter> wirelessRouters(@Nonnull Level world, @Nonnull BlockPos pos) {
        return new RouterIterator<TileEntityWirelessRouter>(world, pos, TileEntityWirelessRouter.class).stream();
    }

    public static Stream<BlockPos> connectedBlocks(@Nonnull Level world, @Nonnull NetworkId networkId, @Nonnull Set<SidedConsumer> consumers) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        return consumers.stream().map(sidedConsumer -> {
            BlockPos consumerPos = LogicTools.findConsumerPosition(networkId, worldBlob, sidedConsumer.consumerId());
            if (consumerPos != null) {
                return consumerPos.m_121945_(sidedConsumer.side());
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public static Stream<TileEntityController> controllers(@Nonnull Level world, @Nonnull NetworkId networkId) {
        return LogicTools.connectedBlocks(world, networkId).filter(pos -> world.m_7702_(pos) instanceof TileEntityController).map(pos -> (TileEntityController)world.m_7702_(pos));
    }

    public static Stream<TileEntityRouter> routers(@Nonnull Level world, @Nonnull NetworkId networkId) {
        return LogicTools.connectedBlocks(world, networkId).filter(pos -> world.m_7702_(pos) instanceof TileEntityRouter).map(pos -> (TileEntityRouter)world.m_7702_(pos));
    }

    public static Stream<BlockPos> connectedBlocks(@Nonnull Level world, @Nonnull NetworkId networkId) {
        return LogicTools.consumers(world, networkId).flatMap(blockPos -> Arrays.stream(OrientationTools.DIRECTION_VALUES).filter(facing -> ConnectorBlock.isConnectable((BlockGetter)world, blockPos, facing)).map(arg_0 -> ((BlockPos)blockPos).m_121945_(arg_0)));
    }

    @Nullable
    public static BlockPos findConsumerPosition(@Nonnull NetworkId networkId, @Nonnull WorldBlob worldBlob, @Nonnull ConsumerId consumerId) {
        Set<BlockPos> consumers = worldBlob.getConsumers(networkId);
        for (BlockPos pos : consumers) {
            ConsumerId c = worldBlob.getConsumerAt(pos);
            if (!consumerId.equals((Object)c)) continue;
            return pos;
        }
        return null;
    }
}

