/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.api.IMarketOverrideData;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MarketRegistry {
    public static final MarketRegistry INSTANCE = new MarketRegistry();
    private final Map<ResourceLocation, IMarketCategory> indexedCategories = new HashMap<ResourceLocation, IMarketCategory>();
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entries = ArrayListMultimap.create();
    private final Map<UUID, IMarketEntry> entriesById = new HashMap<UUID, IMarketEntry>();
    private final Map<String, IMarketOverrideData> groupOverrides = new HashMap<String, IMarketOverrideData>();
    private final Map<String, IMarketOverrideData> entryOverrides = new HashMap<String, IMarketOverrideData>();
    private final Map<String, IMarketRegistryDefaultHandler> defaultHandlers = new HashMap<String, IMarketRegistryDefaultHandler>();

    public static void resetCategories() {
        MarketRegistry.INSTANCE.indexedCategories.clear();
    }

    public void registerCategory(IMarketCategory category) {
        if (this.indexedCategories.containsKey(category.getRegistryName())) {
            throw new RuntimeException("Attempted to register duplicate market category " + category.getRegistryName());
        }
        this.indexedCategories.put(category.getRegistryName(), category);
    }

    public void registerGroupOverride(String key, IMarketOverrideData override) {
        this.groupOverrides.put(key, override);
    }

    public void registerEntryOverride(String key, IMarketOverrideData override) {
        this.entryOverrides.put(key, override);
    }

    public void registerEntry(ItemStack outputItem, ItemStack costItem, @Nullable IMarketCategory category) {
        String registryName = Objects.toString(Balm.getRegistries().getKey(outputItem.m_41720_()));
        IMarketOverrideData override = this.entryOverrides.get(registryName);
        if (category == null) {
            category = MarketRegistry.determineCategory(outputItem);
        }
        if (override == null || override.isEnabled()) {
            ItemStack payment = override != null && override.getPayment() != null ? override.getPayment() : costItem;
            ItemStack alteredOutputItem = ContainerUtils.copyStackWithSize((ItemStack)outputItem, (int)(override != null ? override.getCount() : Math.min(outputItem.m_41613_(), outputItem.m_41741_())));
            MarketEntry entry = new MarketEntry(UUID.randomUUID(), alteredOutputItem, payment, category);
            this.entries.put((Object)category, (Object)entry);
            this.entriesById.put(entry.getEntryId(), entry);
        }
    }

    public void registerDefaults() {
        for (Map.Entry<String, IMarketRegistryDefaultHandler> entry : this.defaultHandlers.entrySet()) {
            IMarketOverrideData override = this.groupOverrides.get(entry.getKey());
            IMarketRegistryDefaultHandler defaultHandler = entry.getValue();
            boolean enabled = defaultHandler.isEnabledByDefault();
            if (override != null) {
                enabled = override.isEnabled();
            }
            if (!enabled) continue;
            defaultHandler.register(override != null ? override.getPayment() : null, override != null ? Integer.valueOf(override.getCount()) : null);
        }
    }

    @Nullable
    public static IMarketEntry getEntryById(UUID entryId) {
        return MarketRegistry.INSTANCE.entriesById.get(entryId);
    }

    @Nullable
    public static IMarketEntry getEntryFor(ItemStack outputItem) {
        for (IMarketEntry entry : MarketRegistry.INSTANCE.entries.values()) {
            if (!entry.getOutputItem().m_41656_(outputItem) || !ItemStack.m_150942_((ItemStack)entry.getOutputItem(), (ItemStack)outputItem) || outputItem.m_41613_() != entry.getOutputItem().m_41613_()) continue;
            return entry;
        }
        return null;
    }

    public static ArrayListMultimap<IMarketCategory, IMarketEntry> getGroupedEntries() {
        return MarketRegistry.INSTANCE.entries;
    }

    public static Collection<IMarketEntry> getEntries() {
        return MarketRegistry.INSTANCE.entries.values();
    }

    private static IMarketCategory determineCategory(ItemStack outputStack) {
        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategoryOther();
        ResourceLocation registryName = Balm.getRegistries().getKey(outputStack.m_41720_());
        if (registryName != null) {
            if (registryName.m_135815_().contains("sapling")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySaplings();
            } else if (registryName.m_135815_().contains("seed")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySeeds();
            } else if (registryName.m_135815_().contains("flower")) {
                category = FarmingForBlockheadsAPI.getMarketCategoryFlowers();
            }
        }
        return category;
    }

    public static void registerDefaultHandler(String defaultKey, IMarketRegistryDefaultHandler handler) {
        if (MarketRegistry.INSTANCE.defaultHandlers.containsKey(defaultKey)) {
            throw new RuntimeException("Attempted to register duplicate default handler " + defaultKey);
        }
        MarketRegistry.INSTANCE.defaultHandlers.put(defaultKey, handler);
    }

    public static Collection<IMarketCategory> getCategories() {
        return MarketRegistry.INSTANCE.indexedCategories.values();
    }

    @Nullable
    public static IMarketCategory getCategory(ResourceLocation id) {
        return MarketRegistry.INSTANCE.indexedCategories.get(id);
    }

    public void reset() {
        this.entryOverrides.clear();
        this.groupOverrides.clear();
        this.defaultHandlers.clear();
        this.indexedCategories.clear();
        this.entries.clear();
        this.entriesById.clear();
    }
}

