/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_forge.events;

import com.google.gson.JsonSyntaxException;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.JsonFunctions;
import com.natamus.villagernames_common_forge.config.ConfigHandler;
import com.natamus.villagernames_common_forge.util.Names;
import java.util.HashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class VillagerEvent {
    public static void onSpawn(Level level, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof Villager)) {
            boolean goname = false;
            if (ConfigHandler.nameModdedVillagers && EntityFunctions.isModdedVillager((Entity)entity)) {
                goname = true;
            }
            if (!goname) {
                return;
            }
        }
        if (!entity.m_8077_()) {
            EntityFunctions.nameEntity((Entity)entity, (String)Names.getRandomName());
        }
    }

    public static InteractionResult onVillagerInteract(Player player, Level level, InteractionHand hand, Entity entity, EntityHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.PASS;
        }
        if (!entity.getClass().equals(Villager.class)) {
            return InteractionResult.PASS;
        }
        if (!entity.m_8077_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        Villager villager = (Villager)entity;
        VillagerData d = villager.m_7141_();
        String profession = d.m_35571_().toString();
        if (profession.equals("none") || profession.equals("nitwit")) {
            return InteractionResult.PASS;
        }
        if (profession.contains(":")) {
            profession = profession.split(":")[1];
        }
        if (profession.contains("-")) {
            profession = profession.split("-")[0].trim();
        }
        Component namecomponent = villager.m_7755_();
        try {
            String json = Component.Serializer.m_130703_((Component)namecomponent);
            HashMap map = JsonFunctions.JsonStringToHashMap((String)json);
            String prevname = (String)map.get("text");
            String upperprofession = profession.substring(0, 1).toUpperCase() + profession.substring(1);
            if (prevname.contains(upperprofession)) {
                return InteractionResult.PASS;
            }
            map.put("text", prevname + " the " + upperprofession);
            villager.m_6593_((Component)Component.Serializer.m_130701_((String)JsonFunctions.HashMapToJsonString((HashMap)map)));
            new Thread(() -> {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                map.put("text", prevname.replace(" the ", "").replace(upperprofession, ""));
                villager.m_6593_((Component)Component.Serializer.m_130701_((String)JsonFunctions.HashMapToJsonString((HashMap)map)));
            }).start();
        }
        catch (JsonSyntaxException ex) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }
}

