/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import snownee.jade.JadeClient;
import snownee.jade.JadeCommonConfig;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.Theme;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.RequestTilePacket;
import snownee.jade.network.ServerPingPacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.PlatformProxy;
import snownee.jade.util.ThemeSerializer;

@Mod(value="jade")
public class Jade {
    public static final String MODID = "jade";
    public static final String NAME = "Jade";
    public static final Logger LOGGER = LogManager.getLogger((String)"Jade");
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("jade", "networking")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public static final Vec2 SMALL_ITEM_SIZE = new Vec2(10.0f, 10.0f);
    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public static final Vec2 SMALL_ITEM_OFFSET = Vec2.f_82467_;
    public static final JsonConfig<WailaConfig> CONFIG = new JsonConfig<WailaConfig>("jade/jade", WailaConfig.class, () -> OverlayRenderer.updateTheme()).withGson(new GsonBuilder().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(Theme.class, (Object)new ThemeSerializer()).create());

    @ApiStatus.ScheduledForRemoval(inVersion="1.20")
    public static IElement smallItem(IElementHelper elements, ItemStack stack) {
        return elements.smallItem(stack);
    }

    public Jade() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        FMLJavaModLoadingContext.get().getModEventBus().register(JadeCommonConfig.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        if (PlatformProxy.isPhysicallyClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.HIGH, this::setupClient);
        }
        MinecraftForge.EVENT_BUS.addListener(this::playerJoin);
        PlatformProxy.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        NETWORK.registerMessage(0, ReceiveDataPacket.class, ReceiveDataPacket::write, ReceiveDataPacket::read, ReceiveDataPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(1, ServerPingPacket.class, ServerPingPacket::write, ServerPingPacket::read, ServerPingPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        NETWORK.registerMessage(2, RequestEntityPacket.class, RequestEntityPacket::write, RequestEntityPacket::read, RequestEntityPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NETWORK.registerMessage(3, RequestTilePacket.class, RequestTilePacket::write, RequestTilePacket::read, RequestTilePacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        NETWORK.registerMessage(4, ShowOverlayPacket.class, ShowOverlayPacket::write, ShowOverlayPacket::read, ShowOverlayPacket.Handler::onMessage, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private void setupClient(RegisterClientReloadListenersEvent event) {
        JadeClient.initClient();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        List classNames = ModList.get().getAllScanData().stream().flatMap($ -> $.getAnnotations().stream()).filter($ -> {
            if ($.annotationType().getClassName().equals(WailaPlugin.class.getName())) {
                String required = $.annotationData().getOrDefault("value", "");
                return required.isEmpty() || ModList.get().isLoaded(required);
            }
            return false;
        }).map(ModFileScanData.AnnotationData::memberName).collect(Collectors.toList());
        for (String className : classNames) {
            LOGGER.info("Start loading plugin at {}", (Object)className);
            try {
                Class<?> clazz = Class.forName(className);
                if (!IWailaPlugin.class.isAssignableFrom(clazz)) continue;
                IWailaPlugin plugin = (IWailaPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.register(WailaCommonRegistration.INSTANCE);
                if (!PlatformProxy.isPhysicallyClient()) continue;
                plugin.registerClient(WailaClientRegistration.INSTANCE);
            }
            catch (Throwable e) {
                LOGGER.error("Error loading plugin at {}", (Object)className, (Object)e);
            }
        }
        WailaCommonRegistration.INSTANCE.priorities.sort(PluginConfig.INSTANCE.getKeys());
        WailaCommonRegistration.INSTANCE.loadComplete();
        if (PlatformProxy.isPhysicallyClient()) {
            WailaClientRegistration.INSTANCE.loadComplete();
            WailaConfig.ConfigGeneral.init();
        }
        PluginConfig.INSTANCE.reload();
    }

    private void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        LOGGER.info("Syncing config to {} ({})", (Object)event.getEntity().m_36316_().getName(), (Object)event.getEntity().m_36316_().getId());
        NETWORK.sendTo((Object)new ServerPingPacket(PluginConfig.INSTANCE), ((ServerPlayer)event.getEntity()).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

