/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum ChiseledBookshelfProvider implements IBlockComponentProvider,
IServerDataProvider<BlockEntity>
{
    INSTANCE;


    @Override
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.showDetails()) {
            return null;
        }
        ItemStack item = ChiseledBookshelfProvider.getHitBook(accessor);
        return item.m_41619_() ? null : IElementHelper.get().item(item);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.showDetails()) {
            return;
        }
        ItemStack item = ChiseledBookshelfProvider.getHitBook(accessor);
        if (item.m_41619_()) {
            return;
        }
        tooltip.remove(Identifiers.UNIVERSAL_ITEM_STORAGE);
        tooltip.add((Component)IDisplayHelper.get().stripColor(item.m_41786_()));
        if (item.m_41782_() && item.m_41783_().m_128441_("StoredEnchantments")) {
            ArrayList list = Lists.newArrayList();
            ItemStack.m_41709_((List)list, (ListTag)EnchantedBookItem.m_41163_((ItemStack)item));
            tooltip.addAll(list);
        }
    }

    private static ItemStack getHitBook(BlockAccessor accessor) {
        if (!(accessor.getBlockEntity() instanceof ChiseledBookShelfBlockEntity)) {
            return ItemStack.f_41583_;
        }
        if (!accessor.getServerData().m_128441_("Bookshelf")) {
            return ItemStack.f_41583_;
        }
        Optional optional = ChiseledBookShelfBlock.m_260871_((BlockHitResult)((BlockHitResult)accessor.getHitResult()), (Direction)((Direction)accessor.getBlockState().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
        if (optional.isEmpty()) {
            return ItemStack.f_41583_;
        }
        int i = ChiseledBookShelfBlock.m_261279_((Vec2)((Vec2)optional.get()));
        NonNullList items = NonNullList.m_122780_((int)((ChiseledBookShelfBlockEntity)accessor.getBlockEntity()).m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)accessor.getServerData().m_128469_("Bookshelf"), (NonNullList)items);
        if (i >= items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)items.get(i);
    }

    @Override
    public void appendServerData(CompoundTag data, ServerPlayer player, Level world, BlockEntity t, boolean showDetails) {
        ChiseledBookShelfBlockEntity be = (ChiseledBookShelfBlockEntity)t;
        if (!be.m_7983_()) {
            data.m_128365_("Bookshelf", (Tag)be.m_187482_());
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_CHISELED_BOOKSHELF;
    }

    @Override
    public int getDefaultPriority() {
        return ItemStorageProvider.INSTANCE.getDefaultPriority() + 1;
    }
}

