/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config.entry;

import java.util.Locale;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import snownee.jade.gui.config.WailaOptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.entry.ConfigEntry;

public class EnumConfigEntry<E extends Enum<E>>
extends ConfigEntry<E> {
    public EnumConfigEntry(ResourceLocation id, E defaultValue) {
        super(id, defaultValue);
    }

    @Override
    public boolean isValidValue(Object value) {
        if (value.getClass() == String.class) {
            try {
                Enum.valueOf(((Enum)this.getDefaultValue()).getClass(), (String)value);
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return value.getClass() == ((Enum)this.getDefaultValue()).getClass();
    }

    @Override
    public void setValue(Object value) {
        if (value.getClass() == String.class) {
            value = Enum.valueOf(((Enum)this.getDefaultValue()).getClass(), (String)value);
        }
        super.setValue(value);
    }

    @Override
    public OptionValue<?> createUI(WailaOptionsList options, String optionName) {
        return options.choices(optionName, (Enum)this.getValue(), e -> PluginConfig.INSTANCE.set(this.id, e), builder -> builder.m_232498_(e -> {
            String key = WailaOptionsList.Entry.makeKey(optionName + "_" + e.name().toLowerCase(Locale.ENGLISH) + "_desc");
            if (!I18n.m_118936_((String)key)) {
                return null;
            }
            return Tooltip.m_257550_((Component)Component.m_237115_((String)key));
        }));
    }
}

