/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import java.util.Objects;
import java.util.UUID;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Waystone
implements IWaystone,
IMutableWaystone {
    private final ResourceLocation waystoneType;
    private final UUID waystoneUid;
    private final boolean wasGenerated;
    private ResourceKey<Level> dimension;
    private BlockPos pos;
    private String name = "";
    private boolean isGlobal;
    private UUID ownerUid;

    public Waystone(ResourceLocation waystoneType, UUID waystoneUid, ResourceKey<Level> dimension, BlockPos pos, boolean wasGenerated, @Nullable UUID ownerUid) {
        this.waystoneType = waystoneType;
        this.waystoneUid = waystoneUid;
        this.dimension = dimension;
        this.pos = pos;
        this.wasGenerated = wasGenerated;
        this.ownerUid = ownerUid;
    }

    @Override
    public UUID getWaystoneUid() {
        return this.waystoneUid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public boolean wasGenerated() {
        return this.wasGenerated;
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    @Override
    public boolean isOwner(Player player) {
        return this.ownerUid == null || player.m_36316_().getId().equals(this.ownerUid) || player.m_150110_().f_35937_;
    }

    @Override
    public void setOwnerUid(@Nullable UUID ownerUid) {
        this.ownerUid = ownerUid;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public UUID getOwnerUid() {
        return this.ownerUid;
    }

    @Override
    public void setDimension(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    @Override
    public void setPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public ResourceLocation getWaystoneType() {
        return this.waystoneType;
    }

    public static IWaystone read(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.m_130259_();
        ResourceLocation waystoneType = buf.m_130281_();
        String name = buf.m_130277_();
        boolean isGlobal = buf.readBoolean();
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(250)));
        BlockPos pos = buf.m_130135_();
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (ResourceKey<Level>)dimension, pos, false, null);
        waystone.setName(name);
        waystone.setGlobal(isGlobal);
        return waystone;
    }

    public static IWaystone read(CompoundTag compound) {
        UUID waystoneUid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(compound.m_128423_("WaystoneUid")));
        String name = compound.m_128461_("Name");
        ResourceKey dimensionType = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(compound.m_128461_("World")));
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("BlockPos"));
        boolean wasGenerated = compound.m_128471_("WasGenerated");
        UUID ownerUid = compound.m_128441_("OwnerUid") ? NbtUtils.m_129233_((Tag)Objects.requireNonNull(compound.m_128423_("OwnerUid"))) : null;
        ResourceLocation waystoneType = compound.m_128441_("Type") ? new ResourceLocation(compound.m_128461_("Type")) : WaystoneTypes.WAYSTONE;
        Waystone waystone = new Waystone(waystoneType, waystoneUid, (ResourceKey<Level>)dimensionType, pos, wasGenerated, ownerUid);
        waystone.setName(name);
        waystone.setGlobal(compound.m_128471_("IsGlobal"));
        return waystone;
    }

    public static void write(FriendlyByteBuf buf, IWaystone waystone) {
        buf.m_130077_(waystone.getWaystoneUid());
        buf.m_130085_(waystone.getWaystoneType());
        buf.m_130070_(waystone.getName());
        buf.writeBoolean(waystone.isGlobal());
        buf.m_130085_(waystone.getDimension().m_135782_());
        buf.m_130064_(waystone.getPos());
    }

    public static CompoundTag write(IWaystone waystone, CompoundTag compound) {
        compound.m_128365_("WaystoneUid", (Tag)NbtUtils.m_129226_((UUID)waystone.getWaystoneUid()));
        compound.m_128359_("Type", waystone.getWaystoneType().toString());
        compound.m_128359_("Name", waystone.getName());
        compound.m_128359_("World", waystone.getDimension().m_135782_().toString());
        compound.m_128365_("BlockPos", (Tag)NbtUtils.m_129224_((BlockPos)waystone.getPos()));
        compound.m_128379_("WasGenerated", waystone.wasGenerated());
        if (waystone.getOwnerUid() != null) {
            compound.m_128365_("OwnerUid", (Tag)NbtUtils.m_129226_((UUID)waystone.getOwnerUid()));
        }
        compound.m_128379_("IsGlobal", waystone.isGlobal());
        return compound;
    }
}

