/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.renderer.CheckedBufferSource;
import com.anthonyhilyard.iceberg.renderer.VertexCollector;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.MatrixUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class CustomItemRenderer
extends ItemRenderer {
    private static RenderTarget iconFrameBuffer = null;
    private static ArmorStand armorStand = null;
    private static AbstractMinecart minecart = null;
    private static Boat boat = null;
    private static Horse horse = null;
    private static Pair<Item, CompoundTag> cachedArmorStandItem = null;
    private static Pair<Item, CompoundTag> cachedHorseArmorItem = null;
    private static Map<Item, ModelBounds> modelBoundsCache = Maps.newHashMap();
    private static final List<Direction> quadDirections = new ArrayList<Direction>(Arrays.asList(Direction.values()));
    private Minecraft mc;
    private final ModelManager modelManager;
    private final BlockEntityWithoutLevelRenderer blockEntityRenderer;

    public CustomItemRenderer(TextureManager textureManagerIn, ModelManager modelManagerIn, ItemColors itemColorsIn, BlockEntityWithoutLevelRenderer blockEntityRendererIn, Minecraft mcIn) {
        super(textureManagerIn, modelManagerIn, itemColorsIn, blockEntityRendererIn);
        this.mc = mcIn;
        this.modelManager = modelManagerIn;
        this.blockEntityRenderer = blockEntityRendererIn;
        if (iconFrameBuffer == null) {
            iconFrameBuffer = new MainTarget(96, 96);
            iconFrameBuffer.m_83931_(0.0f, 0.0f, 0.0f, 0.0f);
            iconFrameBuffer.m_83954_(Minecraft.f_91002_);
        }
    }

    private void renderGuiModel(ItemStack itemStack, int x, int y, Quaternionf rotation, BakedModel bakedModel) {
        boolean flatLighting;
        this.mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_252880_((float)x, (float)y, 100.0f + this.f_115093_);
        modelViewStack.m_252880_(8.0f, 8.0f, 0.0f);
        modelViewStack.m_85841_(1.0f, -1.0f, 1.0f);
        modelViewStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flatLighting = !bakedModel.m_7547_();
        if (flatLighting) {
            Lighting.m_84930_();
        }
        PoseStack poseStack = new PoseStack();
        this.renderModel(itemStack, ItemTransforms.TransformType.GUI, false, poseStack, rotation, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        poseStack.m_85849_();
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (flatLighting) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void renderEntityModel(Entity entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Minecraft minecraft = Minecraft.m_91087_();
        EntityRenderDispatcher entityRenderDispatcher = minecraft.m_91290_();
        Lighting.m_166384_();
        RenderSystem.m_69482_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entityRenderDispatcher.m_114468_(false);
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, bufferSource, packedLight));
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
        }
        entityRenderDispatcher.m_114468_(true);
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private <T extends MultiBufferSource> void renderModelInternal(ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHanded, PoseStack poseStack, Quaternionf rotation, T bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel, Predicate<T> bufferSourceReady) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (Player.m_147233_((ItemStack)itemStack).m_254934_() && this.updateArmorStand(itemStack)) {
            this.renderEntityModel((Entity)armorStand, poseStack, bufferSource, packedLight);
        }
        if (!bakedModel.m_7521_() && !itemStack.m_150930_(Items.f_42713_)) {
            BoatItem boatItem;
            MinecartItem minecartItem;
            Item item;
            Block block;
            boolean fabulous = transformType != ItemTransforms.TransformType.GUI && !transformType.m_111841_() && itemStack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)itemStack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
            if (bufferSourceReady.test(bufferSource) && (item = itemStack.m_41720_()) instanceof BlockItem) {
                Block block2;
                BlockItem blockItem = (BlockItem)item;
                BakedModel blockModel = null;
                boolean isBlockEntity = false;
                blockModel = minecraft.m_91289_().m_110907_().m_110893_(blockItem.m_40614_().m_49966_());
                if (blockModel != this.modelManager.m_119409_()) {
                    this.blockEntityRenderer.m_108829_(itemStack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
                } else {
                    blockModel = null;
                }
                if (blockItem.m_40614_().m_49966_().m_61138_((Property)BlockStateProperties.f_61401_)) {
                    BlockState bottomState = (BlockState)blockItem.m_40614_().m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER);
                    BakedModel bottomModel = minecraft.m_91289_().m_110907_().m_110893_(bottomState);
                    this.renderBakedModel(itemStack, transformType, poseStack, bufferSource, packedLight, packedOverlay, bottomModel, fabulous);
                    poseStack.m_85836_();
                    poseStack.m_252880_(0.0f, 1.0f, 0.0f);
                    BlockState topState = (BlockState)blockItem.m_40614_().m_49966_().m_61124_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.UPPER);
                    BakedModel topModel = minecraft.m_91289_().m_110907_().m_110893_(topState);
                    this.renderBakedModel(itemStack, transformType, poseStack, bufferSource, packedLight, packedOverlay, topModel, fabulous);
                    poseStack.m_85849_();
                }
                if ((block2 = blockItem.m_40614_()) instanceof EntityBlock) {
                    EntityBlock entityBlock = (EntityBlock)block2;
                    isBlockEntity = true;
                    try {
                        this.renderBlockEntity(itemStack, poseStack, bufferSource, packedLight, packedOverlay, minecraft, entityBlock, blockItem.m_40614_().m_49966_());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (blockModel != null && (bufferSourceReady.test(bufferSource) || isBlockEntity)) {
                    this.renderBakedModel(itemStack, transformType, poseStack, bufferSource, packedLight, packedOverlay, blockModel, fabulous);
                }
            }
            if (bufferSourceReady.test(bufferSource) && (item = itemStack.m_41720_()) instanceof MinecartItem && this.updateMinecart(minecartItem = (MinecartItem)item)) {
                this.renderEntityModel((Entity)minecart, poseStack, bufferSource, packedLight);
            }
            if (bufferSourceReady.test(bufferSource) && (item = itemStack.m_41720_()) instanceof BoatItem && this.updateBoat(boatItem = (BoatItem)item)) {
                this.renderEntityModel((Entity)boat, poseStack, bufferSource, packedLight);
            }
            if (bufferSourceReady.test(bufferSource) && itemStack.m_41720_() instanceof HorseArmorItem && this.updateHorse(itemStack)) {
                this.renderEntityModel((Entity)horse, poseStack, bufferSource, packedLight);
            }
            if (bufferSourceReady.test(bufferSource)) {
                this.renderBakedModel(itemStack, transformType, poseStack, bufferSource, packedLight, packedOverlay, bakedModel, fabulous);
            }
        } else if (bufferSourceReady.test(bufferSource)) {
            IClientItemExtensions.of((ItemStack)itemStack).getCustomRenderer().m_108829_(itemStack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
        }
    }

    private void renderModel(ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHanded, PoseStack poseStack, Quaternionf rotation, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel) {
        if (!itemStack.m_41619_()) {
            boolean isBlockItem = false;
            boolean spawnsEntity = false;
            boolean isArmor = false;
            Item item = itemStack.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                isBlockItem = true;
            } else if (itemStack.m_41720_() instanceof MinecartItem || itemStack.m_41720_() instanceof BoatItem) {
                spawnsEntity = true;
            }
            if (Player.m_147233_((ItemStack)itemStack).m_254934_()) {
                isArmor = true;
            }
            poseStack.m_85836_();
            if (isBlockItem || spawnsEntity) {
                poseStack.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)bakedModel, (ItemTransforms.TransformType)transformType, (boolean)leftHanded);
            }
            ModelBounds modelBounds = this.getModelBounds(itemStack, transformType, leftHanded, poseStack, rotation, bufferSource, packedLight, packedOverlay, bakedModel);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_252781_(rotation);
            float scale = 1.0f / Math.max(modelBounds.height, modelBounds.radius * 2.0f);
            scale *= isBlockItem ? 0.8f : 1.0f;
            if (isArmor) {
                switch (Player.m_147233_((ItemStack)itemStack)) {
                    case HEAD: {
                        scale *= 0.75f;
                        break;
                    }
                    case LEGS: {
                        scale *= 1.1f;
                        break;
                    }
                }
            }
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252880_(-modelBounds.center.x(), -modelBounds.center.y(), -modelBounds.center.z());
            if (isBlockItem || spawnsEntity) {
                poseStack.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(225.0), 0.0f));
            } else {
                bakedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)bakedModel, (ItemTransforms.TransformType)transformType, (boolean)leftHanded);
            }
            CheckedBufferSource checkedBufferSource = new CheckedBufferSource(bufferSource);
            this.renderModelInternal(itemStack, transformType, leftHanded, poseStack, rotation, checkedBufferSource, packedLight, packedOverlay, bakedModel, b -> !b.hasRendered());
            poseStack.m_85849_();
        }
    }

    private void renderBlockEntity(ItemStack itemStack, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Minecraft minecraft, EntityBlock entityBlock, BlockState blockState) throws Exception {
        BlockEntity blockEntity = entityBlock.m_142194_(BlockPos.f_121853_, blockState);
        if (blockEntity != null) {
            BlockEntityRenderer renderer;
            if (itemStack.m_41783_() != null) {
                blockEntity.m_142466_(itemStack.m_41783_());
            }
            if ((renderer = minecraft.m_167982_().m_112265_(blockEntity)) != null) {
                renderer.m_6922_(blockEntity, minecraft.m_91296_(), poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
    }

    private void renderBakedModel(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel, boolean fabulous) {
        for (BakedModel model : bakedModel.getRenderPasses(itemStack, fabulous)) {
            for (RenderType rendertype : model.getRenderTypes(itemStack, fabulous)) {
                VertexConsumer vertexconsumer;
                if (itemStack.m_204117_(ItemTags.f_215866_) && itemStack.m_41790_()) {
                    poseStack.m_85836_();
                    PoseStack.Pose posestack$pose = poseStack.m_85850_();
                    if (transformType == ItemTransforms.TransformType.GUI) {
                        MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.5f);
                    } else if (transformType.m_111841_()) {
                        MatrixUtil.m_253023_((Matrix4f)posestack$pose.m_252922_(), (float)0.75f);
                    }
                    vertexconsumer = fabulous ? CustomItemRenderer.m_115207_((MultiBufferSource)bufferSource, (RenderType)rendertype, (PoseStack.Pose)posestack$pose) : CustomItemRenderer.m_115180_((MultiBufferSource)bufferSource, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                    poseStack.m_85849_();
                } else {
                    vertexconsumer = fabulous ? CustomItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.m_41790_()) : CustomItemRenderer.m_115211_((MultiBufferSource)bufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.m_41790_());
                }
                this.m_115189_(model, itemStack, packedLight, packedOverlay, poseStack, vertexconsumer);
            }
        }
    }

    private boolean updateArmorStand(ItemStack itemStack) {
        EquipmentSlot equipmentSlot = Player.m_147233_((ItemStack)itemStack);
        if (!equipmentSlot.m_254934_()) {
            return false;
        }
        if (armorStand == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            armorStand = (ArmorStand)EntityType.f_20529_.m_20615_((Level)minecraft.f_91073_);
            armorStand.m_6842_(true);
        }
        if (armorStand == null) {
            return false;
        }
        if (cachedArmorStandItem != Pair.of((Object)itemStack.m_41720_(), (Object)itemStack.m_41783_())) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                armorStand.m_8061_(slot, ItemStack.f_41583_);
            }
            armorStand.m_8061_(equipmentSlot, itemStack);
            cachedArmorStandItem = Pair.of((Object)itemStack.m_41720_(), (Object)itemStack.m_41783_());
        }
        return true;
    }

    private boolean updateMinecart(MinecartItem item) {
        if (minecart == null || minecart.m_6064_() != item.f_42935_) {
            Minecraft minecraft = Minecraft.m_91087_();
            minecart = AbstractMinecart.m_38119_((Level)minecraft.f_91073_, (double)0.0, (double)0.0, (double)0.0, (AbstractMinecart.Type)item.f_42935_);
        }
        return minecart != null;
    }

    private boolean updateBoat(BoatItem item) {
        if (boat == null || boat.m_262365_() != item.f_40616_ || boat instanceof ChestBoat != item.f_220011_) {
            Minecraft minecraft = Minecraft.m_91087_();
            boat = item.f_220011_ ? new ChestBoat((Level)minecraft.f_91073_, 0.0, 0.0, 0.0) : new Boat((Level)minecraft.f_91073_, 0.0, 0.0, 0.0);
            boat.m_262362_(item.f_40616_);
        }
        return boat != null;
    }

    private boolean updateHorse(ItemStack horseArmorItem) {
        if (!(horseArmorItem.m_41720_() instanceof HorseArmorItem)) {
            return false;
        }
        if (horse == null) {
            Minecraft minecraft = Minecraft.m_91087_();
            horse = (Horse)EntityType.f_20457_.m_20615_((Level)minecraft.f_91073_);
            horse.m_6842_(true);
            horse.canUpdate(false);
        }
        if (horse == null) {
            return false;
        }
        if (cachedHorseArmorItem != Pair.of((Object)horseArmorItem.m_41720_(), (Object)horseArmorItem.m_41783_())) {
            horse.m_8061_(EquipmentSlot.CHEST, horseArmorItem);
            cachedHorseArmorItem = Pair.of((Object)horseArmorItem.m_41720_(), (Object)horseArmorItem.m_41783_());
        }
        return true;
    }

    private ModelBounds boundsFromVertices(List<Vector3f> vertices) {
        Vector3f center = new Vector3f();
        float radius = 0.0f;
        float height = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float minZ = Float.MAX_VALUE;
        float maxX = Float.MIN_VALUE;
        float maxY = Float.MIN_VALUE;
        float maxZ = Float.MIN_VALUE;
        for (Vector3f vertex : vertices) {
            minX = Math.min(minX, vertex.x);
            minY = Math.min(minY, vertex.y);
            minZ = Math.min(minZ, vertex.z);
            maxX = Math.max(maxX, vertex.x);
            maxY = Math.max(maxY, vertex.y);
            maxZ = Math.max(maxZ, vertex.z);
        }
        center = new Vector3f((minX + maxX) / 2.0f, (minY + maxY) / 2.0f, (minZ + maxZ) / 2.0f);
        height = maxY - minY;
        for (Vector3f vertex : vertices) {
            radius = Math.max(radius, (float)Math.sqrt((vertex.x - center.x) * (vertex.x - center.x) + (vertex.y - center.y) * (vertex.y - center.y)));
        }
        return new ModelBounds(center, height, radius);
    }

    private ModelBounds getModelBounds(ItemStack itemStack, ItemTransforms.TransformType transformType, boolean leftHanded, PoseStack poseStack, Quaternionf rotation, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel bakedModel) {
        if (!modelBoundsCache.containsKey(itemStack.m_41720_())) {
            VertexCollector vertexCollector = new VertexCollector();
            this.renderModelInternal(itemStack, transformType, leftHanded, poseStack, rotation, vertexCollector, packedLight, packedOverlay, bakedModel, b -> b.getVertices().isEmpty());
            modelBoundsCache.put(itemStack.m_41720_(), this.boundsFromVertices(vertexCollector.getVertices()));
        }
        return modelBoundsCache.get(itemStack.m_41720_());
    }

    public void renderDetailModelIntoGUI(ItemStack stack, int x, int y, Quaternionf rotation) {
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedModel = minecraft.m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        this.f_115093_ += 50.0f;
        try {
            this.renderGuiModel(stack, x, y, rotation, bakedModel);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Rendering item");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Item being rendered");
            crashreportcategory.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashreportcategory.m_128165_("Registry Name", () -> String.valueOf(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())));
            crashreportcategory.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
            crashreportcategory.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
            crashreportcategory.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
            throw new ReportedException(crashreport);
        }
        this.f_115093_ -= 50.0f;
    }

    public void renderItemModelIntoGUIWithAlpha(ItemStack stack, int x, int y, float alpha) {
        boolean flatLighting;
        BakedModel bakedModel = this.mc.m_91291_().m_174264_(stack, null, null, 0);
        RenderTarget lastFrameBuffer = this.mc.m_91385_();
        iconFrameBuffer.m_83954_(Minecraft.f_91002_);
        iconFrameBuffer.m_83947_(true);
        Matrix4f matrix = new Matrix4f();
        matrix.setOrtho(0.0f, (float)CustomItemRenderer.iconFrameBuffer.f_83915_, (float)CustomItemRenderer.iconFrameBuffer.f_83916_, 0.0f, 1000.0f, 3000.0f);
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.m_157183_();
        RenderSystem.m_252934_((Matrix4f)matrix);
        this.mc.m_91097_().m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69464_();
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_252880_(48.0f, 48.0f, -2000.0f);
        modelViewStack.m_85841_(96.0f, 96.0f, 96.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = this.mc.m_91269_().m_110104_();
        boolean bl = flatLighting = !bakedModel.m_7547_();
        if (flatLighting) {
            Lighting.m_84930_();
        }
        this.m_115143_(stack, ItemTransforms.TransformType.GUI, false, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
        bufferSource.m_109911_();
        RenderSystem.m_69482_();
        if (flatLighting) {
            Lighting.m_84931_();
        }
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157424_();
        if (lastFrameBuffer != null) {
            lastFrameBuffer.m_83947_(true);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_69464_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            modelViewStack.m_85836_();
            modelViewStack.m_252880_(0.0f, 0.0f, 50.0f + this.f_115093_);
            RenderSystem.m_157182_();
            RenderSystem.m_157453_((int)0, (int)iconFrameBuffer.m_83975_());
            GuiComponent.m_93160_((PoseStack)new PoseStack(), (int)x, (int)y, (int)16, (int)16, (float)0.0f, (float)0.0f, (int)CustomItemRenderer.iconFrameBuffer.f_83915_, (int)CustomItemRenderer.iconFrameBuffer.f_83916_, (int)CustomItemRenderer.iconFrameBuffer.f_83915_, (int)CustomItemRenderer.iconFrameBuffer.f_83916_);
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
            iconFrameBuffer.m_83963_();
        } else {
            iconFrameBuffer.m_83970_();
        }
    }

    static {
        quadDirections.add(null);
    }

    private record ModelBounds(Vector3f center, float height, float radius) {
    }
}

