/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.network.client.OpenSRATScreen;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.network.client.SendTip;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.network.client.SetTrophySystemTarget;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.ClearLoggerServer;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.GiveNightVision;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.OpenBriefcaseInventory;
import net.geforcemods.securitycraft.network.server.RemoteControlMine;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.network.server.RemoveMineFromMRAT;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetBriefcaseOwner;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetGhostSlot;
import net.geforcemods.securitycraft.network.server.SetKeycardUses;
import net.geforcemods.securitycraft.network.server.SetListModuleData;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.network.server.SetStateOnDisguiseModule;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.SyncIMSTargetingOption;
import net.geforcemods.securitycraft.network.server.SyncKeycardSettings;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.network.server.SyncTrophySystem;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.util.RegisterItemBlock;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.SCItemGroup;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegistrationHandler {
    public static final Map<SCItemGroup, List<ItemStack>> STACKS_FOR_ITEM_GROUPS = (Map)Util.m_137469_(new EnumMap(SCItemGroup.class), map -> Arrays.stream(SCItemGroup.values()).forEach(key -> map.put(key, new ArrayList())));

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.ITEMS, helper -> {
            for (Field field : SCContent.class.getFields()) {
                try {
                    BlockItem blockItem;
                    Block block;
                    SCItemGroup group;
                    if (field.isAnnotationPresent(Reinforced.class) && field.getAnnotation(Reinforced.class).registerBlockItem()) {
                        group = field.getAnnotation(Reinforced.class).itemGroup();
                        block = (Block)((RegistryObject)field.get(null)).get();
                        blockItem = new BlockItem(block, new Item.Properties().m_41486_());
                        helper.register(Utils.getRegistryName(block), (Object)blockItem);
                        if (group == SCItemGroup.MANUAL) continue;
                        STACKS_FOR_ITEM_GROUPS.get((Object)group).add(new ItemStack((ItemLike)blockItem));
                        continue;
                    }
                    if (!field.isAnnotationPresent(RegisterItemBlock.class)) continue;
                    group = field.getAnnotation(RegisterItemBlock.class).value();
                    block = (Block)((RegistryObject)field.get(null)).get();
                    blockItem = new BlockItem(block, new Item.Properties());
                    helper.register(Utils.getRegistryName(block), (Object)blockItem);
                    if (group == SCItemGroup.MANUAL) continue;
                    STACKS_FOR_ITEM_GROUPS.get((Object)group).add(new ItemStack((ItemLike)blockItem));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> {
            for (int i = 0; i < SCSounds.values().length; ++i) {
                SCSounds sound = SCSounds.values()[i];
                helper.register(sound.location, (Object)sound.event);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityAttributeCreation(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCContent.SENTRY_ENTITY.get(), Mob.m_21552_().m_22265_());
    }

    public static void registerPackets() {
        int index = 0;
        SecurityCraft.channel.registerMessage(index++, InitSentryAnimation.class, InitSentryAnimation::encode, InitSentryAnimation::decode, InitSentryAnimation::onMessage);
        SecurityCraft.channel.registerMessage(index++, OpenScreen.class, OpenScreen::encode, OpenScreen::decode, OpenScreen::onMessage);
        SecurityCraft.channel.registerMessage(index++, OpenSRATScreen.class, OpenSRATScreen::encode, OpenSRATScreen::decode, OpenSRATScreen::onMessage);
        SecurityCraft.channel.registerMessage(index++, RefreshDisguisableModel.class, RefreshDisguisableModel::encode, RefreshDisguisableModel::decode, RefreshDisguisableModel::onMessage);
        SecurityCraft.channel.registerMessage(index++, SendTip.class, SendTip::encode, SendTip::decode, SendTip::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetCameraView.class, SetCameraView::encode, SetCameraView::decode, SetCameraView::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetTrophySystemTarget.class, SetTrophySystemTarget::encode, SetTrophySystemTarget::decode, SetTrophySystemTarget::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateLogger.class, UpdateLogger::encode, UpdateLogger::decode, UpdateLogger::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateNBTTagOnClient.class, UpdateNBTTagOnClient::encode, UpdateNBTTagOnClient::decode, UpdateNBTTagOnClient::onMessage);
        SecurityCraft.channel.registerMessage(index++, AssembleBlockPocket.class, AssembleBlockPocket::encode, AssembleBlockPocket::decode, AssembleBlockPocket::onMessage);
        SecurityCraft.channel.registerMessage(index++, CheckPassword.class, CheckPassword::encode, CheckPassword::decode, CheckPassword::onMessage);
        SecurityCraft.channel.registerMessage(index++, ClearChangeDetectorServer.class, ClearChangeDetectorServer::encode, ClearChangeDetectorServer::decode, ClearChangeDetectorServer::onMessage);
        SecurityCraft.channel.registerMessage(index++, ClearLoggerServer.class, ClearLoggerServer::encode, ClearLoggerServer::decode, ClearLoggerServer::onMessage);
        SecurityCraft.channel.registerMessage(index++, DismountCamera.class, DismountCamera::encode, DismountCamera::decode, DismountCamera::onMessage);
        SecurityCraft.channel.registerMessage(index++, GiveNightVision.class, GiveNightVision::encode, GiveNightVision::decode, GiveNightVision::onMessage);
        SecurityCraft.channel.registerMessage(index++, MountCamera.class, MountCamera::encode, MountCamera::decode, MountCamera::onMessage);
        SecurityCraft.channel.registerMessage(index++, OpenBriefcaseInventory.class, OpenBriefcaseInventory::encode, OpenBriefcaseInventory::decode, OpenBriefcaseInventory::onMessage);
        SecurityCraft.channel.registerMessage(index++, RemoteControlMine.class, RemoteControlMine::encode, RemoteControlMine::decode, RemoteControlMine::onMessage);
        SecurityCraft.channel.registerMessage(index++, RemoveCameraTag.class, RemoveCameraTag::encode, RemoveCameraTag::decode, RemoveCameraTag::onMessage);
        SecurityCraft.channel.registerMessage(index++, RemoveMineFromMRAT.class, RemoveMineFromMRAT::encode, RemoveMineFromMRAT::decode, RemoveMineFromMRAT::onMessage);
        SecurityCraft.channel.registerMessage(index++, RemovePositionFromSSS.class, RemovePositionFromSSS::encode, RemovePositionFromSSS::decode, RemovePositionFromSSS::onMessage);
        SecurityCraft.channel.registerMessage(index++, RemoveSentryFromSRAT.class, RemoveSentryFromSRAT::encode, RemoveSentryFromSRAT::decode, RemoveSentryFromSRAT::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetBriefcaseOwner.class, SetBriefcaseOwner::encode, SetBriefcaseOwner::decode, SetBriefcaseOwner::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetCameraPowered.class, SetCameraPowered::encode, SetCameraPowered::decode, SetCameraPowered::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetGhostSlot.class, SetGhostSlot::encode, SetGhostSlot::decode, SetGhostSlot::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetKeycardUses.class, SetKeycardUses::encode, SetKeycardUses::decode, SetKeycardUses::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetListModuleData.class, SetListModuleData::encode, SetListModuleData::decode, SetListModuleData::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetPassword.class, SetPassword::encode, SetPassword::decode, SetPassword::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetSentryMode.class, SetSentryMode::encode, SetSentryMode::decode, SetSentryMode::onMessage);
        SecurityCraft.channel.registerMessage(index++, SetStateOnDisguiseModule.class, SetStateOnDisguiseModule::encode, SetStateOnDisguiseModule::decode, SetStateOnDisguiseModule::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncBlockChangeDetector.class, SyncBlockChangeDetector::encode, SyncBlockChangeDetector::decode, SyncBlockChangeDetector::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncBlockPocketManager.class, SyncBlockPocketManager::encode, SyncBlockPocketManager::decode, SyncBlockPocketManager::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncIMSTargetingOption.class, SyncIMSTargetingOption::encode, SyncIMSTargetingOption::decode, SyncIMSTargetingOption::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncKeycardSettings.class, SyncKeycardSettings::encode, SyncKeycardSettings::decode, SyncKeycardSettings::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncProjector.class, SyncProjector::encode, SyncProjector::decode, SyncProjector::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncRiftStabilizer.class, SyncRiftStabilizer::encode, SyncRiftStabilizer::decode, SyncRiftStabilizer::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncSSSSettingsOnServer.class, SyncSSSSettingsOnServer::encode, SyncSSSSettingsOnServer::decode, SyncSSSSettingsOnServer::onMessage);
        SecurityCraft.channel.registerMessage(index++, SyncTrophySystem.class, SyncTrophySystem::encode, SyncTrophySystem::decode, SyncTrophySystem::onMessage);
        SecurityCraft.channel.registerMessage(index++, ToggleBlockPocketManager.class, ToggleBlockPocketManager::encode, ToggleBlockPocketManager::decode, ToggleBlockPocketManager::onMessage);
        SecurityCraft.channel.registerMessage(index++, ToggleModule.class, ToggleModule::encode, ToggleModule::decode, ToggleModule::onMessage);
        SecurityCraft.channel.registerMessage(index++, ToggleOption.class, ToggleOption::encode, ToggleOption::decode, ToggleOption::onMessage);
        SecurityCraft.channel.registerMessage(index++, UpdateSliderValue.class, UpdateSliderValue::encode, UpdateSliderValue::decode, UpdateSliderValue::onMessage);
    }

    @SubscribeEvent
    public static void onCreativeModeTabRegister(CreativeModeTabEvent.Register event) {
        SecurityCraft.technicalTab = event.registerCreativeModeTab(new ResourceLocation("securitycraft", "technical"), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)SCContent.USERNAME_LOGGER.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.securitycraft.technical")).m_257501_((features, output, hasPermissions) -> {
            output.m_246601_(List.of(new ItemStack((ItemLike)SCContent.SC_MANUAL.get()), new ItemStack((ItemLike)SCContent.FRAME.get()), new ItemStack((ItemLike)SCContent.KEY_PANEL.get()), new ItemStack((ItemLike)SCContent.KEYPAD.get()), new ItemStack((ItemLike)SCContent.KEYPAD_CHEST.get()), new ItemStack((ItemLike)SCContent.KEYPAD_FURNACE.get()), new ItemStack((ItemLike)SCContent.KEYPAD_SMOKER.get()), new ItemStack((ItemLike)SCContent.KEYPAD_BLAST_FURNACE.get()), new ItemStack((ItemLike)SCContent.DISPLAY_CASE.get()), new ItemStack((ItemLike)SCContent.GLOW_DISPLAY_CASE.get()), new ItemStack((ItemLike)SCContent.KEYCARD_READER.get()), new ItemStack((ItemLike)SCContent.KEYCARD_LVL_1.get()), new ItemStack((ItemLike)SCContent.KEYCARD_LVL_2.get()), new ItemStack((ItemLike)SCContent.KEYCARD_LVL_3.get()), new ItemStack((ItemLike)SCContent.KEYCARD_LVL_4.get()), new ItemStack((ItemLike)SCContent.KEYCARD_LVL_5.get()), new ItemStack((ItemLike)SCContent.LIMITED_USE_KEYCARD.get()), new ItemStack((ItemLike)SCContent.CODEBREAKER.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_KEY_CHANGER.get()), new ItemStack((ItemLike)SCContent.RETINAL_SCANNER.get()), new ItemStack((ItemLike)SCContent.LASER_BLOCK.get()), new ItemStack((ItemLike)SCContent.INVENTORY_SCANNER.get()), new ItemStack((ItemLike)SCContent.USERNAME_LOGGER.get()), new ItemStack((ItemLike)SCContent.PORTABLE_RADAR.get()), new ItemStack((ItemLike)SCContent.TROPHY_SYSTEM.get()), new ItemStack((ItemLike)SCContent.RIFT_STABILIZER.get()), new ItemStack((ItemLike)SCContent.BLOCK_CHANGE_DETECTOR.get()), new ItemStack((ItemLike)SCContent.PROJECTOR.get()), new ItemStack((ItemLike)SCContent.PROTECTO.get()), new ItemStack((ItemLike)SCContent.MOTION_ACTIVATED_LIGHT.get()), new ItemStack((ItemLike)SCContent.SECURITY_CAMERA.get()), new ItemStack((ItemLike)SCContent.CAMERA_MONITOR.get()), new ItemStack((ItemLike)SCContent.ALARM.get()), new ItemStack((ItemLike)SCContent.PANIC_BUTTON.get()), new ItemStack((ItemLike)SCContent.SENTRY.get()), new ItemStack((ItemLike)SCContent.REMOTE_ACCESS_SENTRY.get()), new ItemStack((ItemLike)SCContent.REMOTE_ACCESS_MINE.get()), new ItemStack((ItemLike)SCContent.CAGE_TRAP.get()), new ItemStack((ItemLike)SCContent.WIRE_CUTTERS.get()), new ItemStack((ItemLike)SCContent.IRON_FENCE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_FENCE_GATE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_IRON_TRAPDOOR.get()), new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get()), new ItemStack((ItemLike)SCContent.SCANNER_DOOR_ITEM.get()), new ItemStack((ItemLike)SCContent.KEYPAD_DOOR_ITEM.get()), new ItemStack((ItemLike)SCContent.BLOCK_POCKET_MANAGER.get()), new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get()), new ItemStack((ItemLike)SCContent.SONIC_SECURITY_SYSTEM.get()), new ItemStack((ItemLike)SCContent.PORTABLE_TUNE_PLAYER.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), new ItemStack((ItemLike)SCContent.REINFORCED_STICKY_PISTON.get()), new ItemStack((ItemLike)SCContent.REINFORCED_OBSERVER.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CAULDRON.get()), new ItemStack((ItemLike)SCContent.REINFORCED_HOPPER.get()), new ItemStack((ItemLike)SCContent.ALLOWLIST_MODULE.get()), new ItemStack((ItemLike)SCContent.DENYLIST_MODULE.get()), new ItemStack((ItemLike)SCContent.DISGUISE_MODULE.get()), new ItemStack((ItemLike)SCContent.REDSTONE_MODULE.get()), new ItemStack((ItemLike)SCContent.SPEED_MODULE.get()), new ItemStack((ItemLike)SCContent.SMART_MODULE.get()), new ItemStack((ItemLike)SCContent.STORAGE_MODULE.get()), new ItemStack((ItemLike)SCContent.HARMING_MODULE.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_MODIFIER.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_OWNER_CHANGER.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()), new ItemStack((ItemLike)SCContent.UNIVERSAL_BLOCK_REMOVER.get()), new ItemStack((ItemLike)SCContent.TASER.get()), new ItemStack((ItemLike)SCContent.BRIEFCASE.get()), new ItemStack((ItemLike)SCContent.FAKE_WATER_BUCKET.get()), new ItemStack((ItemLike)SCContent.FAKE_LAVA_BUCKET.get()), new ItemStack((ItemLike)SCContent.ADMIN_TOOL.get())));
            output.m_246601_((Collection)STACKS_FOR_ITEM_GROUPS.get((Object)SCItemGroup.TECHNICAL));
        }));
        SecurityCraft.mineTab = event.registerCreativeModeTab(new ResourceLocation("securitycraft", "explosives"), List.of(), List.of(SecurityCraft.technicalTab), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)SCContent.MINE.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.securitycraft.explosives")).m_257501_((features, output, hasPermissions) -> {
            List<Item> vanillaOrderedItems = RegistrationHandler.getVanillaOrderedItems();
            List<ItemStack> mineGroupItems = STACKS_FOR_ITEM_GROUPS.get((Object)SCItemGroup.EXPLOSIVES);
            mineGroupItems.sort((a, b) -> {
                BlockItem blockItemB;
                Block patt19462$temp;
                BlockItem blockItemA;
                Block patt19297$temp;
                Item patt19240$temp = a.m_41720_();
                if (!(patt19240$temp instanceof BlockItem) || !((patt19297$temp = (blockItemA = (BlockItem)patt19240$temp).m_40614_()) instanceof BaseFullMineBlock)) {
                    return -1;
                }
                BaseFullMineBlock blockMineA = (BaseFullMineBlock)patt19297$temp;
                Item patt19405$temp = b.m_41720_();
                if (!(patt19405$temp instanceof BlockItem) || !((patt19462$temp = (blockItemB = (BlockItem)patt19405$temp).m_40614_()) instanceof BaseFullMineBlock)) {
                    return 1;
                }
                BaseFullMineBlock blockMineB = (BaseFullMineBlock)patt19462$temp;
                return Integer.compare(vanillaOrderedItems.indexOf(blockMineA.getBlockDisguisedAs().m_5456_()), vanillaOrderedItems.indexOf(blockMineB.getBlockDisguisedAs().m_5456_()));
            });
            output.m_246326_((ItemLike)SCContent.REMOTE_ACCESS_MINE.get());
            output.m_246326_((ItemLike)SCContent.WIRE_CUTTERS.get());
            output.m_246326_((ItemLike)Items.f_42409_);
            output.m_246326_((ItemLike)SCContent.MINE.get());
            output.m_246601_(mineGroupItems);
            output.m_246601_(List.of(new ItemStack((ItemLike)SCContent.ANCIENT_DEBRIS_MINE_ITEM.get()), new ItemStack((ItemLike)SCContent.FURNACE_MINE.get()), new ItemStack((ItemLike)SCContent.SMOKER_MINE.get()), new ItemStack((ItemLike)SCContent.BLAST_FURNACE_MINE.get())));
        }));
        SecurityCraft.decorationTab = event.registerCreativeModeTab(new ResourceLocation("securitycraft", "decoration"), List.of(), List.of(SecurityCraft.mineTab), builder -> builder.m_257737_(() -> new ItemStack((ItemLike)SCContent.REINFORCED_OAK_STAIRS.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.securitycraft.decoration")).m_257501_((features, output, hasPermissions) -> {
            List<Item> vanillaOrderedItems = RegistrationHandler.getVanillaOrderedItems();
            List<ItemStack> decorationGroupItems = STACKS_FOR_ITEM_GROUPS.get((Object)SCItemGroup.DECORATION);
            decorationGroupItems.sort((a, b) -> {
                BlockItem blockItemB;
                Block patt21187$temp;
                BlockItem blockItemA;
                Block patt21018$temp;
                Item patt20961$temp = a.m_41720_();
                if (!(patt20961$temp instanceof BlockItem) || !((patt21018$temp = (blockItemA = (BlockItem)patt20961$temp).m_40614_()) instanceof IReinforcedBlock)) {
                    return 1;
                }
                IReinforcedBlock reinforcedBlockA = (IReinforcedBlock)patt21018$temp;
                Item patt21130$temp = b.m_41720_();
                if (!(patt21130$temp instanceof BlockItem) || !((patt21187$temp = (blockItemB = (BlockItem)patt21130$temp).m_40614_()) instanceof IReinforcedBlock)) {
                    return -1;
                }
                IReinforcedBlock reinforcedBlockB = (IReinforcedBlock)patt21187$temp;
                int indexA = vanillaOrderedItems.indexOf(reinforcedBlockA.getVanillaBlock().m_5456_());
                if (indexA == -1) {
                    return 1;
                }
                int indexB = vanillaOrderedItems.indexOf(reinforcedBlockB.getVanillaBlock().m_5456_());
                if (indexB == -1) {
                    return -1;
                }
                return Integer.compare(indexA, indexB);
            });
            for (int i = decorationGroupItems.size() - 1; i >= 0; --i) {
                if (decorationGroupItems.get(i).m_41720_() != ((Block)SCContent.REINFORCED_BOOKSHELF.get()).m_5456_()) continue;
                decorationGroupItems.addAll(i + 1, List.of(new ItemStack((ItemLike)SCContent.SECRET_OAK_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_SPRUCE_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_BIRCH_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_JUNGLE_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_ACACIA_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_DARK_OAK_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_MANGROVE_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_CRIMSON_SIGN_ITEM.get()), new ItemStack((ItemLike)SCContent.SECRET_WARPED_SIGN_ITEM.get())));
                break;
            }
            decorationGroupItems.addAll(List.of(new ItemStack((ItemLike)SCContent.CRYSTAL_QUARTZ_BLOCK.get()), new ItemStack((ItemLike)SCContent.CRYSTAL_QUARTZ_STAIRS.get()), new ItemStack((ItemLike)SCContent.CRYSTAL_QUARTZ_SLAB.get()), new ItemStack((ItemLike)SCContent.CHISELED_CRYSTAL_QUARTZ.get()), new ItemStack((ItemLike)SCContent.CRYSTAL_QUARTZ_BRICKS.get()), new ItemStack((ItemLike)SCContent.CRYSTAL_QUARTZ_PILLAR.get()), new ItemStack((ItemLike)SCContent.SMOOTH_CRYSTAL_QUARTZ.get()), new ItemStack((ItemLike)SCContent.SMOOTH_CRYSTAL_QUARTZ_STAIRS.get()), new ItemStack((ItemLike)SCContent.SMOOTH_CRYSTAL_QUARTZ_SLAB.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_BLOCK.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_STAIRS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_SLAB.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_BRICKS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()), new ItemStack((ItemLike)SCContent.REINFORCED_SMOOTH_CRYSTAL_QUARTZ.get()), new ItemStack((ItemLike)SCContent.REINFORCED_SMOOTH_CRYSTAL_QUARTZ_STAIRS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_SMOOTH_CRYSTAL_QUARTZ_SLAB.get()), new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get()), new ItemStack((ItemLike)SCContent.IRON_FENCE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_FENCE_GATE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_IRON_TRAPDOOR.get()), new ItemStack((ItemLike)SCContent.REINFORCED_DOOR_ITEM.get()), new ItemStack((ItemLike)SCContent.SCANNER_DOOR_ITEM.get()), new ItemStack((ItemLike)SCContent.KEYPAD_DOOR_ITEM.get()), new ItemStack((ItemLike)SCContent.DISPLAY_CASE.get()), new ItemStack((ItemLike)SCContent.GLOW_DISPLAY_CASE.get())));
            output.m_246326_((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
            output.m_246326_((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get());
            output.m_246326_((ItemLike)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get());
            output.m_246326_((ItemLike)SCContent.UNIVERSAL_BLOCK_REMOVER.get());
            output.m_246601_(decorationGroupItems);
        }));
    }

    @SubscribeEvent
    public static void onCreativeModeTabBuildContents(CreativeModeTabEvent.BuildContents event) {
        if (event.getTab() == CreativeModeTabs.f_257028_) {
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_41966_), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_LEVER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42083_), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_BUTTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_BUTTON.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_STONE_BUTTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_STONE_BUTTON.get()), (Object)new ItemStack((ItemLike)SCContent.PANIC_BUTTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_41967_), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_STONE_PRESSURE_PLATE.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_41862_), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)SCContent.REINFORCED_PISTON.get()), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_STICKY_PISTON.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)new ItemStack((ItemLike)Items.f_42155_), (Object)new ItemStack((ItemLike)SCContent.REINFORCED_HOPPER.get()), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        } else if (event.getTab() == CreativeModeTabs.f_256725_) {
            event.m_246601_(List.of(new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_WOOL.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_CARPET.get()), new ItemStack((ItemLike)SCContent.REINFORCED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_CONCRETE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_GLAZED_TERRACOTTA.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_TINTED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), new ItemStack((ItemLike)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get())));
        }
    }

    public static void registerFakeLiquidRecipes() {
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}), (Ingredient)RegistrationHandler.getPotionIngredient(Potions.f_43582_, Potions.f_43583_), (ItemStack)new ItemStack((ItemLike)SCContent.FAKE_WATER_BUCKET.get()));
        BrewingRecipeRegistry.addRecipe((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42448_}), (Ingredient)RegistrationHandler.getPotionIngredient(Potions.f_43623_, Potions.f_43581_), (ItemStack)new ItemStack((ItemLike)SCContent.FAKE_LAVA_BUCKET.get()));
    }

    private static Ingredient getPotionIngredient(Potion normalPotion, Potion strongPotion) {
        ItemStack normalPotionStack = new ItemStack((ItemLike)Items.f_42589_);
        ItemStack strongPotionStack = new ItemStack((ItemLike)Items.f_42589_);
        ItemStack normalSplashPotionStack = new ItemStack((ItemLike)Items.f_42736_);
        ItemStack strongSplashPotionStack = new ItemStack((ItemLike)Items.f_42736_);
        ItemStack normalLingeringPotionStack = new ItemStack((ItemLike)Items.f_42739_);
        ItemStack strongLingeringPotionStack = new ItemStack((ItemLike)Items.f_42739_);
        CompoundTag normalNBT = new CompoundTag();
        CompoundTag strongNBT = new CompoundTag();
        normalNBT.m_128359_("Potion", Utils.getRegistryName(normalPotion).toString());
        strongNBT.m_128359_("Potion", Utils.getRegistryName(strongPotion).toString());
        normalPotionStack.m_41751_(normalNBT.m_6426_());
        strongPotionStack.m_41751_(strongNBT.m_6426_());
        normalSplashPotionStack.m_41751_(normalNBT.m_6426_());
        strongSplashPotionStack.m_41751_(strongNBT.m_6426_());
        normalLingeringPotionStack.m_41751_(normalNBT.m_6426_());
        strongLingeringPotionStack.m_41751_(strongNBT.m_6426_());
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{normalPotionStack, strongPotionStack, normalSplashPotionStack, strongSplashPotionStack, normalLingeringPotionStack, strongLingeringPotionStack});
    }

    private static List<Item> getVanillaOrderedItems() {
        ArrayList<Item> vanillaOrderedItems = new ArrayList<Item>();
        vanillaOrderedItems.addAll(RegistrationHandler.getCreativeTabItems(CreativeModeTabs.f_256788_));
        vanillaOrderedItems.addAll(RegistrationHandler.getCreativeTabItems(CreativeModeTabs.f_256725_));
        vanillaOrderedItems.addAll(RegistrationHandler.getCreativeTabItems(CreativeModeTabs.f_256776_));
        vanillaOrderedItems.addAll(RegistrationHandler.getCreativeTabItems(CreativeModeTabs.f_256791_));
        vanillaOrderedItems.addAll(RegistrationHandler.getCreativeTabItems(CreativeModeTabs.f_257028_));
        return vanillaOrderedItems;
    }

    private static List<Item> getCreativeTabItems(CreativeModeTab tab) {
        return tab.m_260957_().stream().map(ItemStack::m_41720_).toList();
    }
}

