/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("textures/mob_effect/night_vision.png");
    private static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.f_42451_);
    private static final Component REDSTONE_NOTE = Utils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]);
    private static final int USE_CHECKMARK = 88;
    private static final int USE_CROSS = 110;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            Vec3 camPos = event.getCamera().m_90583_();
            PoseStack pose = event.getPoseStack();
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            for (BlockPos bcdPos : BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getTrackedBlockEntities((Level)level)) {
                BlockChangeDetectorBlockEntity bcd;
                BlockEntity be = level.m_7702_(bcdPos);
                if (!(be instanceof BlockChangeDetectorBlockEntity) || !(bcd = (BlockChangeDetectorBlockEntity)be).isShowingHighlights() || !bcd.isOwnedBy((Player)mc.f_91074_)) continue;
                for (BlockChangeDetectorBlockEntity.ChangeEntry changeEntry : bcd.getFilteredEntries()) {
                    BlockPos pos = changeEntry.pos();
                    pose.m_85836_();
                    pose.m_85837_((double)pos.m_123341_() - camPos.f_82479_, (double)pos.m_123342_() - camPos.f_82480_, (double)pos.m_123343_() - camPos.f_82481_);
                    ClientUtils.renderBoxInLevel(BCDBuffer.INSTANCE, pose.m_85850_().m_252922_(), 0, 1, 0, 1, 1, bcd.getColor());
                    pose.m_85849_();
                }
            }
            mc.m_91269_().m_110104_().m_109911_();
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCamera camera = (SecurityCamera)Minecraft.m_91087_().f_91075_;
            if (camera.screenshotSoundCooldown == 0) {
                camera.screenshotSoundCooldown = 7;
                Minecraft.m_91087_().f_91073_.m_245747_(player.m_20183_(), SCSounds.CAMERASNAP.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
            }
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            Minecraft mc = Minecraft.m_91087_();
            InteractionHand hand = event.getHand();
            if (mc.f_91074_.m_21120_(hand).m_150930_((Item)SCContent.CAMERA_MONITOR.get())) {
                ((Item)SCContent.CAMERA_MONITOR.get()).m_7203_((Level)mc.f_91073_, (Player)mc.f_91074_, hand);
            }
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    public static void cameraOverlay(ForgeGui gui, PoseStack pose, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        BlockPos pos = mc.f_91075_.m_20183_();
        Window window = mc.m_91268_();
        if (mc.f_91066_.f_92063_) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            return;
        }
        SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)blockEntity;
        Font font = Minecraft.m_91087_().f_91062_;
        Options settings = Minecraft.m_91087_().f_91066_;
        boolean hasRedstoneModule = be.isModuleEnabled(ModuleType.REDSTONE);
        BlockState state = level.m_8055_(pos);
        MutableComponent lookAround = Utils.localize("gui.securitycraft:camera.lookAround", settings.f_92085_.m_90863_(), settings.f_92086_.m_90863_(), settings.f_92087_.m_90863_(), settings.f_92088_.m_90863_());
        MutableComponent exit = Utils.localize("gui.securitycraft:camera.exit", settings.f_92090_.m_90863_());
        MutableComponent zoom = Utils.localize("gui.securitycraft:camera.zoom", KeyBindings.cameraZoomIn.m_90863_(), KeyBindings.cameraZoomOut.m_90863_());
        MutableComponent nightVision = Utils.localize("gui.securitycraft:camera.activateNightVision", KeyBindings.cameraActivateNightVision.m_90863_());
        MutableComponent redstone = Utils.localize("gui.securitycraft:camera.toggleRedstone", KeyBindings.cameraEmitRedstone.m_90863_());
        String time = ClientUtils.getFormattedMinecraftTime();
        int timeY = 25;
        if (be.m_8077_()) {
            Component cameraName = be.m_7770_();
            font.m_92763_(pose, cameraName, (float)(window.m_85445_() - font.m_92852_((FormattedText)cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        font.m_92750_(pose, time, (float)(window.m_85445_() - font.m_92895_(time) - 4), (float)timeY, 0xFFFFFF);
        font.m_92763_(pose, (Component)lookAround, (float)(window.m_85445_() - font.m_92852_((FormattedText)lookAround) - 8), (float)(window.m_85446_() - 80), 0xFFFFFF);
        font.m_92763_(pose, (Component)exit, (float)(window.m_85445_() - font.m_92852_((FormattedText)exit) - 8), (float)(window.m_85446_() - 70), 0xFFFFFF);
        font.m_92763_(pose, (Component)zoom, (float)(window.m_85445_() - font.m_92852_((FormattedText)zoom) - 8), (float)(window.m_85446_() - 60), 0xFFFFFF);
        font.m_92763_(pose, (Component)nightVision, (float)(window.m_85445_() - font.m_92852_((FormattedText)nightVision) - 8), (float)(window.m_85446_() - 50), 0xFFFFFF);
        font.m_92763_(pose, (Component)redstone, (float)(window.m_85445_() - font.m_92852_((FormattedText)redstone) - 8), (float)(window.m_85446_() - 40), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        font.m_92763_(pose, REDSTONE_NOTE, (float)(window.m_85445_() - font.m_92852_((FormattedText)REDSTONE_NOTE) - 8), (float)(window.m_85446_() - 30), hasRedstoneModule ? 0xFFFFFF : 0xFF3377);
        RenderSystem.m_157179_((int)0, (ResourceLocation)CAMERA_DASHBOARD);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.m_93228_(pose, 5, 0, 0, 0, 90, 20);
        gui.m_93228_(pose, window.m_85445_() - 70, 5, 190, 0, 65, 30);
        if (!mc.f_91074_.m_21023_(MobEffects.f_19611_)) {
            gui.m_93228_(pose, 28, 4, 90, 12, 16, 11);
        } else {
            RenderSystem.m_157179_((int)0, (ResourceLocation)NIGHT_VISION);
            GuiComponent.m_93133_((PoseStack)pose, (int)27, (int)-1, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            RenderSystem.m_157179_((int)0, (ResourceLocation)CAMERA_DASHBOARD);
        }
        if (state.m_60746_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)SecurityCameraBlock.FACING)) == 0) {
            if (!hasRedstoneModule) {
                gui.m_93228_(pose, 12, 2, 104, 0, 12, 12);
            } else {
                gui.m_93228_(pose, 12, 3, 90, 0, 12, 11);
            }
        } else {
            Minecraft.m_91087_().m_91291_().m_115203_(REDSTONE, 10, 0);
        }
    }

    public static void hotbarBindOverlay(ForgeGui gui, PoseStack pose, float partialTicks, int width, int height) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Level level = player.m_20193_();
        for (InteractionHand hand : InteractionHand.values()) {
            int uCoord = 0;
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == SCContent.CAMERA_MONITOR.get()) {
                uCoord = SCClientEventHandler.getUCoord(level, (Player)player, stack, bhr -> level.m_7702_(bhr.m_82425_()) instanceof SecurityCameraBlockEntity, 30, (tag, i) -> {
                    if (!tag.m_128441_("Camera" + i)) {
                        return null;
                    }
                    String camera = tag.m_128461_("Camera" + i);
                    return (Integer[])Arrays.stream(camera.substring(0, camera.lastIndexOf(32)).split(" ")).map(Integer::parseInt).toArray(Integer[]::new);
                });
            } else if (stack.m_41720_() == SCContent.REMOTE_ACCESS_MINE.get()) {
                uCoord = SCClientEventHandler.getUCoord(level, (Player)player, stack, bhr -> level.m_8055_(bhr.m_82425_()).m_60734_() instanceof IExplosive, 30, (tag, i) -> {
                    if (tag.m_128465_("mine" + i).length > 0) {
                        return (Integer[])Arrays.stream(tag.m_128465_("mine" + i)).boxed().toArray(Integer[]::new);
                    }
                    return null;
                });
            } else if (stack.m_41720_() == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                Entity entity = Minecraft.m_91087_().f_91076_;
                if (entity instanceof Sentry) {
                    Sentry sentry = (Sentry)entity;
                    uCoord = SCClientEventHandler.loop(12, (tag, i) -> (Integer[])Arrays.stream(tag.m_128465_("sentry" + i)).boxed().toArray(Integer[]::new), stack.m_41784_(), sentry.m_20183_());
                }
            } else if (stack.m_41720_() == SCContent.SONIC_SECURITY_SYSTEM_ITEM.get()) {
                uCoord = SCClientEventHandler.getUCoord(level, (Player)player, stack, bhr -> {
                    IOwnable ownable;
                    BlockEntity patt11494$temp = level.m_7702_(bhr.m_82425_());
                    if (!(patt11494$temp instanceof ILockable)) {
                        return false;
                    }
                    ILockable lockable = (ILockable)patt11494$temp;
                    return lockable instanceof IOwnable && (ownable = (IOwnable)((Object)lockable)).isOwnedBy((Player)player) || !DisguisableBlock.getDisguisedBlockState((LevelReader)level, bhr.m_82425_()).isPresent();
                }, 0, null, false, SonicSecuritySystemItem::isAdded);
            }
            if (uCoord == 0) continue;
            RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
            GuiComponent.m_93133_((PoseStack)pose, (int)(Minecraft.m_91087_().m_91268_().m_85445_() / 2 - 90 + (hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ * 20 : (mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.LEFT ? 189 : -29))), (int)(Minecraft.m_91087_().m_91268_().m_85446_() - 22), (float)uCoord, (float)219.0f, (int)21, (int)22, (int)256, (int)256);
        }
    }

    private static int getUCoord(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult, int tagSize, BiFunction<CompoundTag, Integer, Integer[]> getCoords) {
        return SCClientEventHandler.getUCoord(level, player, stackInHand, isValidHitResult, tagSize, getCoords, true, null);
    }

    private static int getUCoord(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult, int tagSize, BiFunction<CompoundTag, Integer, Integer[]> getCoords, boolean loop, BiFunction<CompoundTag, BlockPos, Boolean> useCheckmark) {
        double reachDistance = player.getReachDistance();
        double eyeHeight = player.m_20192_();
        Vec3 lookVec = new Vec3(player.m_20185_() + player.m_20154_().f_82479_ * reachDistance, eyeHeight + player.m_20186_() + player.m_20154_().f_82480_ * reachDistance, player.m_20189_() + player.m_20154_().f_82481_ * reachDistance);
        BlockHitResult hitResult = level.m_45547_(new ClipContext(new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.BLOCK && isValidHitResult.test(hitResult)) {
            if (loop) {
                return SCClientEventHandler.loop(tagSize, getCoords, stackInHand.m_41784_(), hitResult.m_82425_());
            }
            return useCheckmark.apply(stackInHand.m_41784_(), hitResult.m_82425_()) != false ? 88 : 110;
        }
        return 0;
    }

    private static int loop(int tagSize, BiFunction<CompoundTag, Integer, Integer[]> getCoords, CompoundTag tag, BlockPos pos) {
        for (int i = 1; i <= tagSize; ++i) {
            Integer[] coords = getCoords.apply(tag, i);
            if (coords == null || coords.length != 3 || coords[0].intValue() != pos.m_123341_() || coords[1].intValue() != pos.m_123342_() || coords[2].intValue() != pos.m_123343_()) continue;
            return 88;
        }
        return 110;
    }

    private static enum BCDBuffer implements MultiBufferSource
    {
        INSTANCE;

        private final RenderType overlayLines = new OverlayLines(RenderType.m_110504_());

        public VertexConsumer m_6299_(RenderType renderType) {
            return Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(this.overlayLines);
        }

        private static class OverlayLines
        extends RenderType {
            private final RenderType normalLines;

            private OverlayLines(RenderType normalLines) {
                super("overlay_lines", normalLines.m_110508_(), normalLines.m_173186_(), normalLines.m_110507_(), normalLines.m_110405_(), normalLines.f_110393_, () -> ((RenderType)normalLines).m_110185_(), () -> ((RenderType)normalLines).m_110188_());
                this.normalLines = normalLines;
            }

            public void m_110185_() {
                this.normalLines.m_110185_();
                RenderTarget renderTarget = Minecraft.m_91087_().f_91060_.m_109827_();
                if (renderTarget != null) {
                    renderTarget.m_83947_(false);
                }
            }

            public void m_110188_() {
                Minecraft.m_91087_().m_91385_().m_83947_(false);
                this.normalLines.m_110188_();
            }
        }
    }
}

