/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IEMPAffected;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameSetter;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordConvertible;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blockentities.PortableRadarBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedCarpetBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.SendTip;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.MutablePair;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    private static final Integer NOTE_DELAY = 9;
    public static final Map<Player, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>> PLAYING_TUNES = new HashMap<Player, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>>();

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            PLAYING_TUNES.forEach((player, pair) -> {
                int ticksRemaining = (Integer)pair.getLeft();
                if (ticksRemaining == 0) {
                    if (PlayerUtils.getSelectedItemStack(player, (Item)SCContent.PORTABLE_TUNE_PLAYER.get()).m_41619_()) {
                        pair.setLeft((Object)-1);
                        return;
                    }
                    SonicSecuritySystemBlockEntity.NoteWrapper note = (SonicSecuritySystemBlockEntity.NoteWrapper)((Deque)pair.getRight()).poll();
                    if (note != null) {
                        SoundEvent sound = (SoundEvent)NoteBlockInstrument.valueOf((String)note.instrumentName().toUpperCase()).m_263188_().get();
                        float pitch = (float)Math.pow(2.0, (double)(note.noteID() - 12) / 12.0);
                        player.f_19853_.m_5594_(null, player.m_20183_(), sound, SoundSource.RECORDS, 3.0f, pitch);
                        SCEventHandler.handlePlayedNote(player.f_19853_, player.m_20183_(), note.noteID(), note.instrumentName());
                        player.m_146850_(GameEvent.f_223699_);
                        pair.setLeft((Object)NOTE_DELAY);
                    } else {
                        pair.setLeft((Object)-1);
                    }
                } else {
                    pair.setLeft((Object)(ticksRemaining - 1));
                }
            });
            if (PLAYING_TUNES.size() > 0) {
                Iterator<Map.Entry<Player, MutablePair<Integer, Deque<SonicSecuritySystemBlockEntity.NoteWrapper>>>> entries = PLAYING_TUNES.entrySet().iterator();
                while (entries.hasNext()) {
                    if ((Integer)entries.next().getValue().left != -1) continue;
                    entries.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!((Boolean)ConfigHandler.SERVER.disableThanksMessage.get()).booleanValue()) {
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SendTip());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        Entity entity = player.m_8954_();
        if (entity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)entity;
            BlockEntity blockEntity = player.f_19853_.m_7702_(cam.m_20183_());
            if (blockEntity instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity camBe = (SecurityCameraBlockEntity)blockEntity;
                camBe.stopViewing();
            }
            cam.m_146870_();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            level.m_5594_(null, entity.m_20183_(), SCSounds.ELECTRIFIED.event, SoundSource.BLOCKS, 0.25f, 1.0f);
        }
        if (!level.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (PlayerUtils.isPlayerMountedOnCamera(entity)) {
                ((SecurityCamera)player.m_8954_()).stopViewing(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void highestPriorityOnRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (!stack.m_41619_() && !stack.m_204117_(SCTags.Items.CAN_INTERACT_WITH_DOORS)) {
            Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
            if (block == SCContent.KEYPAD_DOOR.get()) {
                event.setUseItem(Event.Result.DENY);
            } else if (block == SCContent.REINFORCED_DOOR.get() || block == SCContent.REINFORCED_IRON_TRAPDOOR.get() || block == SCContent.SCANNER_DOOR.get()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ILockable lockable;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        Level level = event.getLevel();
        BlockEntity be = level.m_7702_(event.getPos());
        BlockState state = level.m_8055_(event.getPos());
        Block block = state.m_60734_();
        if (be instanceof ILockable && (lockable = (ILockable)be).isLocked() && lockable.disableInteractionWhenLocked(level, event.getPos(), event.getEntity()) && !event.getEntity().m_6144_()) {
            if (event.getHand() == InteractionHand.MAIN_HAND) {
                MutableComponent blockName = Utils.localize(block.m_7705_(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(event.getEntity(), blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            }
            event.setCanceled(true);
            return;
        }
        if (!level.f_46443_) {
            Object empAffected;
            if (event.getItemStack().m_41720_() == Items.f_42451_ && be instanceof IEMPAffected && (empAffected = (IEMPAffected)be).isShutDown()) {
                empAffected.reactivate();
                if (!event.getEntity().m_7500_()) {
                    event.getItemStack().m_41774_(1);
                }
                event.getEntity().m_6674_(event.getHand());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                return;
            }
            if (PlayerUtils.isHoldingItem(event.getEntity(), SCContent.KEY_PANEL, event.getHand())) {
                for (IPasswordConvertible pc : SecurityCraftAPI.getRegisteredPasswordConvertibles()) {
                    if (!pc.isValidStateForConversion(state)) continue;
                    event.setUseBlock(Event.Result.DENY);
                    event.setUseItem(Event.Result.ALLOW);
                }
                return;
            }
            if (PlayerUtils.isHoldingItem(event.getEntity(), SCContent.CODEBREAKER, event.getHand()) && SCEventHandler.handleCodebreaking(event)) {
                event.setCanceled(true);
                return;
            }
            if (be instanceof INameSetter) {
                INameSetter nameable = (INameSetter)be;
                if ((be instanceof SecurityCameraBlockEntity || be instanceof PortableRadarBlockEntity) && PlayerUtils.isHoldingItem(event.getEntity(), Items.f_42656_, event.getHand()) && event.getEntity().m_21120_(event.getHand()).m_41788_()) {
                    ItemStack nametag = event.getEntity().m_21120_(event.getHand());
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    if (nameable.m_7770_().equals(nametag.m_41786_())) {
                        PlayerUtils.sendMessageToPlayer(event.getEntity(), Component.m_237115_((String)be.m_58900_().m_60734_().m_7705_()), Utils.localize("messages.securitycraft:naming.alreadyMatches", nameable.m_7770_()), ChatFormatting.RED);
                        return;
                    }
                    if (!event.getEntity().m_7500_()) {
                        nametag.m_41774_(1);
                    }
                    nameable.setCustomName(nametag.m_41786_());
                    PlayerUtils.sendMessageToPlayer(event.getEntity(), Component.m_237115_((String)be.m_58900_().m_60734_().m_7705_()), Utils.localize("messages.securitycraft:naming.named", nameable.m_7770_()), ChatFormatting.RED);
                    return;
                }
            }
        }
        if (block instanceof DisplayCaseBlock && event.getEntity().m_6144_() && event.getEntity().m_21205_().m_41619_() && !event.getEntity().m_21206_().m_41619_()) {
            event.setUseBlock(Event.Result.ALLOW);
            event.setUseItem(Event.Result.DENY);
            return;
        }
        List sentries = level.m_45976_(Sentry.class, new AABB(event.getPos()));
        if (!sentries.isEmpty()) {
            event.setCanceled(((Sentry)sentries.get(0)).m_6071_(event.getEntity(), event.getHand()) == InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
            return;
        }
        ItemStack stack = event.getEntity().m_21205_();
        Item held = stack.m_41720_();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) {
            UniversalBlockReinforcerItem.convertBlock(level.m_8055_(pos), level, stack, pos, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        List sentries;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (event.getPlayer().m_7500_() && !(sentries = level.m_45976_(Sentry.class, new AABB(event.getPos()))).isEmpty()) {
            event.setCanceled(true);
            return;
        }
        if (!level.m_5776_()) {
            BlockPos pos = event.getPos();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof IModuleInventory) {
                IModuleInventory be = (IModuleInventory)blockEntity;
                for (int i = 0; i < be.getMaxNumberOfModules(); ++i) {
                    if (((ItemStack)be.getInventory().get(i)).m_41619_()) continue;
                    ItemStack stack = (ItemStack)be.getInventory().get(i);
                    ItemEntity item = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
                    LevelUtils.addScheduledTask((LevelAccessor)level, () -> level.m_7967_((Entity)item));
                    be.onModuleRemoved(stack, ((ModuleItem)stack.m_41720_()).getModuleType(), false);
                    if (be instanceof LinkableBlockEntity) {
                        LinkableBlockEntity lbe = (LinkableBlockEntity)be;
                        lbe.createLinkedBlockAction((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)stack.m_41720_()).getModuleType(), false), lbe);
                    }
                    if (!(be instanceof SecurityCameraBlockEntity)) continue;
                    SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)be;
                    BlockPos camPos = cam.m_58899_();
                    BlockState camState = level.m_8055_(camPos);
                    level.m_46672_(camPos.m_5484_((Direction)camState.m_61143_((Property)SecurityCameraBlock.FACING), -1), camState.m_60734_());
                }
            }
            Player player = event.getPlayer();
            BlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getBlockEntitiesInRange(level, pos).forEach(detector -> detector.log(player, BlockChangeDetectorBlockEntity.DetectionMode.BREAK, pos, state));
        }
    }

    @SubscribeEvent
    public static void onBlockEventPlace(BlockEvent.EntityPlaceEvent event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level) || (level = (Level)levelAccessor).m_5776_()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockPos pos = event.getPos();
            BlockState state = event.getState();
            BlockEntityTracker.BLOCK_CHANGE_DETECTOR.getBlockEntitiesInRange(level, pos).forEach(detector -> detector.log(player, BlockChangeDetectorBlockEntity.DetectionMode.PLACE, pos, state));
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        BlockEntity blockEntity = event.getLevel().m_7702_(event.getPos());
        if (blockEntity instanceof IOwnable) {
            IOwnable ownable = (IOwnable)blockEntity;
            String name = event.getPlayer().m_7755_().getString();
            String uuid = event.getPlayer().m_36316_().getId().toString();
            ownable.setOwner(uuid, name);
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingChangeTargetEvent event) {
        if (event.getNewTarget() instanceof Sentry) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block;
        Item held;
        if (event.getEntity() != null && ((held = event.getEntity().m_21205_().m_41720_()) == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) && (block = IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(event.getState().m_60734_())) != null) {
            event.setNewSpeed(10000.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof WitherBoss && event.getState().m_60734_() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity()) && event.getItemStack().m_41720_() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        BlockItem blockItem;
        Item item = event.getItemStack().m_41720_();
        if (item instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_() instanceof ReinforcedCarpetBlock) {
            event.setBurnTime(0);
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.m_9236_();
        List<RiftStabilizerBlockEntity> targetPosBlockEntities = BlockEntityTracker.RIFT_STABILIZER.getBlockEntitiesInRange(level, event.getTarget());
        List<RiftStabilizerBlockEntity> sourcePosBlockEntities = BlockEntityTracker.RIFT_STABILIZER.getBlockEntitiesInRange(level, event.getPrev());
        List<Object> blockEntities = new ArrayList<RiftStabilizerBlockEntity>();
        RiftStabilizerBlockEntity.TeleportationType type = RiftStabilizerBlockEntity.TeleportationType.getTypeFromEvent(event);
        RiftStabilizerBlockEntity riftStabilizer = null;
        boolean targetPosProhibited = false;
        blockEntities.addAll(targetPosBlockEntities);
        blockEntities.addAll(sourcePosBlockEntities);
        blockEntities = blockEntities.stream().distinct().sorted(Comparator.comparingDouble(b -> Math.min(b.m_58899_().m_203193_((Position)event.getTarget()), b.m_58899_().m_203193_((Position)event.getPrev())))).toList();
        for (RiftStabilizerBlockEntity riftStabilizerBlockEntity : blockEntities) {
            Player player;
            if (riftStabilizerBlockEntity.isDisabled() || !riftStabilizerBlockEntity.getFilter(type) || entity instanceof Player && (riftStabilizerBlockEntity.isOwnedBy(player = (Player)entity) && riftStabilizerBlockEntity.ignoresOwner() || riftStabilizerBlockEntity.isAllowed((Entity)player))) continue;
            riftStabilizer = riftStabilizerBlockEntity;
            targetPosProhibited = riftStabilizerBlockEntity.m_58899_().m_203193_((Position)event.getTarget()) < riftStabilizerBlockEntity.m_58899_().m_203193_((Position)event.getPrev());
            break;
        }
        if (riftStabilizer != null) {
            BlockPos pos = riftStabilizer.m_58899_();
            Vec3 vec3 = new AABB(pos).m_82399_();
            Vec3 from = targetPosProhibited ? event.getTarget() : event.getPrev();
            Vec3 distance = from.m_82546_(vec3);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                level.m_6263_(null, event.getPrevX(), event.getPrevY(), event.getPrevZ(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.5f);
                PlayerUtils.sendMessageToPlayer(player, ((Block)SCContent.RIFT_STABILIZER.get()).m_49954_(), Component.m_237115_((String)(targetPosProhibited ? "messages.securitycraft:rift_stabilizer.no_teleport_to" : "messages.securitycraft:rift_stabilizer.no_teleport_from")), ChatFormatting.RED);
                if (riftStabilizer.isModuleEnabled(ModuleType.HARMING)) {
                    player.m_6469_(DamageSource.f_19315_, 5.0f);
                }
            }
            riftStabilizer.setLastTeleport(Math.max(Math.abs(distance.f_82479_), Math.max(Math.abs(distance.f_82480_), Math.abs(distance.f_82481_))) - 0.5, type);
            if (riftStabilizer.isModuleEnabled(ModuleType.REDSTONE)) {
                level.m_46597_(pos, (BlockState)riftStabilizer.m_58900_().m_61124_((Property)RiftStabilizerBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(level, pos, (Block)SCContent.RIFT_STABILIZER.get());
                level.m_186460_(pos, (Block)SCContent.RIFT_STABILIZER.get(), riftStabilizer.getSignalLength());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onNoteBlockPlayed(NoteBlockEvent.Play event) {
        SCEventHandler.handlePlayedNote((Level)event.getLevel(), event.getPos(), event.getVanillaNoteId(), event.getInstrument().m_7912_());
    }

    private static void handlePlayedNote(Level level, BlockPos pos, int vanillaNoteId, String instrumentName) {
        List<SonicSecuritySystemBlockEntity> sonicSecuritySystems = BlockEntityTracker.SONIC_SECURITY_SYSTEM.getBlockEntitiesInRange(level, pos);
        for (SonicSecuritySystemBlockEntity be : sonicSecuritySystems) {
            if (!be.isActive()) continue;
            if (be.isRecording()) {
                be.recordNote(vanillaNoteId, instrumentName);
                continue;
            }
            if (!be.listenToNote(vanillaNoteId, instrumentName)) continue;
            be.correctTuneWasPlayed = true;
            be.powerCooldown = (Integer)be.signalLength.get();
            if (!be.isModuleEnabled(ModuleType.REDSTONE)) continue;
            level.m_46597_(be.m_58899_(), (BlockState)be.m_58904_().m_8055_(be.m_58899_()).m_61124_((Property)SonicSecuritySystemBlock.POWERED, (Comparable)Boolean.valueOf(true)));
            BlockUtils.updateIndirectNeighbors(be.m_58904_(), be.m_58899_(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), Direction.DOWN);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean handleCodebreaking(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = player.f_19853_;
        BlockPos pos = event.getPos();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof ICodebreakable)) return false;
        ICodebreakable codebreakable = (ICodebreakable)blockEntity;
        double chance = (Double)ConfigHandler.SERVER.codebreakerChance.get();
        if (chance < 0.0) {
            Block block = level.m_8055_(pos).m_60734_();
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(block.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            return true;
        }
        ItemStack stackInHand = player.m_21120_(event.getHand());
        BlockState state = level.m_8055_(pos);
        if (!codebreakable.shouldAttemptCodebreak(state, player)) {
            return true;
        }
        if (stackInHand.m_150930_((Item)SCContent.CODEBREAKER.get())) {
            stackInHand.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(event.getHand()));
        }
        if (!player.m_7500_()) {
            if (!(new Random().nextDouble() < chance)) {
                PlayerUtils.sendMessageToPlayer(player, Component.m_237115_((String)((Item)SCContent.CODEBREAKER.get()).m_5524_()), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                return true;
            }
        }
        codebreakable.useCodebreaker(state, player);
        return true;
    }
}

