/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IOwnable {
    public Owner getOwner();

    public void setOwner(String var1, String var2);

    default public boolean needsValidation() {
        return false;
    }

    default public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity be;
        if (this.needsValidation()) {
            this.getOwner().setValidated(false);
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:universalOwnerChanger.ownerInvalidated", new Object[0]), ChatFormatting.GREEN);
        }
        if ((be = (BlockEntity)this) instanceof LinkableBlockEntity) {
            LinkableBlockEntity linkable = (LinkableBlockEntity)be;
            linkable.createLinkedBlockAction((ILinkedAction)new ILinkedAction.OwnerChanged(this.getOwner()), linkable);
        }
        be.m_6596_();
    }

    default public boolean isOwnedBy(Player player) {
        if (player == null) {
            return false;
        }
        return this.isOwnedBy(new Owner(player));
    }

    default public boolean isOwnedBy(Owner owner) {
        String thisUUID = this.getOwner().getUUID();
        String thisName = this.getOwner().getName();
        String otherUUID = owner.getUUID();
        String otherName = owner.getName();
        if (((Boolean)ConfigHandler.SERVER.enableTeamOwnership.get()).booleanValue() && PlayerUtils.areOnSameTeam(thisName, otherName)) {
            return true;
        }
        if (otherUUID != null && otherUUID.equals(thisUUID)) {
            return true;
        }
        return otherName != null && thisUUID.equals("ownerUUID") && otherName.equals(thisName);
    }
}

