/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.network.PacketDistributor;

public class DisguisableBlockEntity
extends CustomizableBlockEntity {
    public DisguisableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), pos, state);
    }

    public DisguisableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            BlockState state = this.m_58900_();
            if (!this.f_58857_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack, toggled));
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                    this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                }
            } else {
                ClientHandler.putDisguisedBeRenderer(this, stack);
                if (state.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                    this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            if (!this.f_58857_.f_46443_) {
                BlockState state = this.m_58900_();
                SecurityCraft.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack, toggled));
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                    this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                }
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
                DisguisableBlock.getDisguisedBlockStateFromStack(this.f_58857_, stack).ifPresent(disguisedState -> {
                    if (disguisedState.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                        this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
                    }
                });
            }
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ItemStack stack = this.getModule(ModuleType.DISGUISE);
            if (!stack.m_41619_()) {
                ClientHandler.putDisguisedBeRenderer(this, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
            }
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public ModelData getModelData() {
        BlockState disguisedState = DisguisableBlock.getDisguisedStateOrDefault(Blocks.f_50016_.m_49966_(), (BlockGetter)this.f_58857_, this.f_58858_);
        return ModelData.builder().with(DisguisableDynamicBakedModel.DISGUISED_STATE, (Object)disguisedState).build();
    }
}

