/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.inventory.ExtractOnlyItemStackHandler;
import net.geforcemods.securitycraft.inventory.InventoryScannerMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryScannerBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider,
ITickingBlockEntity,
ILockable {
    private Option.BooleanOption horizontal = new Option.BooleanOption("horizontal", false);
    private Option.BooleanOption solidifyField = new Option.BooleanOption("solidifyField", false);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> EmptyHandler.INSTANCE);
    private LazyOptional<IItemHandler> storageHandler;
    private NonNullList<ItemStack> inventoryContents = NonNullList.m_122780_((int)37, (Object)ItemStack.f_41583_);
    private boolean isProvidingPower;
    private int cooldown;

    public InventoryScannerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else if (this.isProvidingPower) {
            this.isProvidingPower = false;
            BlockUtils.updateAndNotify(level, pos, state.m_60734_(), 1, true);
            BlockUtils.updateIndirectNeighbors(level, pos, (Block)SCContent.INVENTORY_SCANNER.get());
            this.m_6596_();
        }
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos, this.m_58900_(), be -> be.setOwner(this.getOwner().getUUID(), this.getOwner().getName()));
        if (connectedScanner != null) {
            connectedScanner.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.f_46443_) {
                level.m_7654_().m_6846_().m_11268_((Packet)connectedScanner.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        ListTag list = tag.m_128437_("Items", 10);
        super.m_142466_(tag);
        this.inventoryContents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag stackTag = list.m_128728_(i);
            int slot = stackTag.m_128445_("Slot") & 0xFF;
            if (slot < 0 || slot >= this.inventoryContents.size()) continue;
            this.inventoryContents.set(slot, (Object)ItemStack.m_41712_((CompoundTag)stackTag));
        }
        this.cooldown = tag.m_128451_("cooldown");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        for (int i = 0; i < this.inventoryContents.size(); ++i) {
            if (((ItemStack)this.inventoryContents.get(i)).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128344_("Slot", (byte)i);
            ((ItemStack)this.inventoryContents.get(i)).m_41739_(stackTag);
            list.add((Object)stackTag);
        }
        tag.m_128365_("Items", (Tag)list);
        tag.m_128405_("cooldown", this.cooldown);
    }

    public int m_6643_() {
        return 37;
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.inventoryContents.get(index)).m_41619_()) {
            if (((ItemStack)this.inventoryContents.get(index)).m_41613_() <= count) {
                ItemStack stack = (ItemStack)this.inventoryContents.get(index);
                this.inventoryContents.set(index, (Object)ItemStack.f_41583_);
                this.m_6596_();
                return stack;
            }
            ItemStack stack = ((ItemStack)this.inventoryContents.get(index)).m_41620_(count);
            if (((ItemStack)this.inventoryContents.get(index)).m_41613_() == 0) {
                this.inventoryContents.set(index, (Object)ItemStack.f_41583_);
            }
            this.m_6596_();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.inventoryContents.get(slot);
    }

    public ItemStack m_8020_(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack getStackInSlotCopy(int index) {
        return (ItemStack)this.inventoryContents.get(index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.inventoryContents.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void addItemToStorage(ItemStack stack) {
        ItemStack remainder = stack;
        for (int i = 10; i < this.getContents().size() && !(remainder = this.insertItem(i, remainder)).m_41619_(); ++i) {
        }
    }

    public ItemStack insertItem(int slot, ItemStack stackToInsert) {
        if (stackToInsert.m_41619_() || slot < 0 || slot >= this.getContents().size()) {
            return stackToInsert;
        }
        ItemStack slotStack = this.getStackInSlot(slot);
        int limit = stackToInsert.m_41720_().getMaxStackSize(stackToInsert);
        if (slotStack.m_41619_()) {
            this.m_6836_(slot, stackToInsert);
            this.m_6596_();
            return ItemStack.f_41583_;
        }
        if (InventoryScannerFieldBlock.areItemStacksEqual(slotStack, stackToInsert) && slotStack.m_41613_() < limit) {
            if (limit - slotStack.m_41613_() >= stackToInsert.m_41613_()) {
                slotStack.m_41764_(slotStack.m_41613_() + stackToInsert.m_41613_());
                this.m_6596_();
                return ItemStack.f_41583_;
            }
            ItemStack toInsert = stackToInsert.m_41777_();
            ItemStack toReturn = toInsert.m_41620_(slotStack.m_41613_() + stackToInsert.m_41613_() - limit);
            slotStack.m_41764_(slotStack.m_41613_() + toInsert.m_41613_());
            this.m_6596_();
            return toReturn;
        }
        return stackToInsert;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return BlockUtils.getProtectedCapability(side, this, () -> this.getExtractionHandler(), () -> EMPTY_INVENTORY).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        if (this.storageHandler != null) {
            this.storageHandler.invalidate();
        }
        super.invalidateCaps();
    }

    public void reviveCaps() {
        this.storageHandler = null;
        super.reviveCaps();
    }

    public LazyOptional<IItemHandler> getExtractionHandler() {
        if (this.storageHandler == null) {
            this.storageHandler = LazyOptional.of(() -> new ExtractOnlyItemStackHandler(this.inventoryContents){

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return slot < 10 ? ItemStack.f_41583_ : super.extractItem(slot, amount, simulate);
                }
            });
        }
        return this.storageHandler;
    }

    public int m_6893_() {
        return 64;
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public boolean shouldProvidePower() {
        return this.isModuleEnabled(ModuleType.REDSTONE) && this.isProvidingPower;
    }

    public void setShouldProvidePower(boolean isProvidingPower) {
        this.isProvidingPower = isProvidingPower;
        this.m_6596_();
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.m_6596_();
    }

    public NonNullList<ItemStack> getContents() {
        return this.inventoryContents;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.inventoryContents = contents;
        this.m_6596_();
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
        if (connectedScanner != null && (toggled ? !connectedScanner.isModuleEnabled(module) : !connectedScanner.hasModule(module))) {
            connectedScanner.insertModule(stack, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(this, stack);
            if (connectedScanner != null) {
                this.onInsertDisguiseModule(connectedScanner, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
        if (connectedScanner != null && (toggled ? connectedScanner.isModuleEnabled(module) : connectedScanner.hasModule(module))) {
            connectedScanner.removeModule(module, toggled);
        }
        if (module == ModuleType.STORAGE) {
            int i;
            for (i = 10; i < this.m_6643_(); ++i) {
                Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)((ItemStack)this.getContents().get(i)));
            }
            if (connectedScanner != null) {
                for (i = 10; i < connectedScanner.m_6643_(); ++i) {
                    connectedScanner.getContents().set(i, (Object)ItemStack.f_41583_);
                }
            }
        } else if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(this, stack);
            if (connectedScanner != null) {
                this.onRemoveDisguiseModule(connectedScanner, stack);
            }
        }
    }

    private void onInsertDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.m_58904_().f_46443_) {
            be.m_58904_().m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
        }
    }

    private void onRemoveDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.m_58904_().f_46443_) {
            be.m_58904_().m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.STORAGE, ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        InventoryScannerBlockEntity connectedScanner2;
        if (option.getName().equals("horizontal")) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            this.modifyFields((offsetPos, state) -> this.f_58857_.m_46597_(offsetPos, (BlockState)state.m_61124_((Property)InventoryScannerFieldBlock.HORIZONTAL, (Comparable)((Boolean)bo.get()))), connectedScanner -> connectedScanner.setHorizontal((Boolean)bo.get()));
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)((Boolean)bo.get())));
        } else if (option.getName().equals("solidifyField")) {
            InventoryScannerBlockEntity connectedScanner3 = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
            if (connectedScanner3 != null) {
                connectedScanner3.setSolidifyField((Boolean)((Option.BooleanOption)option).get());
            }
        } else if (option.getName().equals("disabled")) {
            Option.BooleanOption bo = (Option.BooleanOption)option;
            if (!((Boolean)bo.get()).booleanValue()) {
                InventoryScannerBlock.checkAndPlaceAppropriately(this.f_58857_, this.f_58858_, true);
            } else {
                this.modifyFields((offsetPos, state) -> this.f_58857_.m_46961_(offsetPos, false), connectedScanner -> connectedScanner.setDisabled(true));
            }
        } else if (option.getName().equals("ignoreOwner") && (connectedScanner2 = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_)) != null) {
            connectedScanner2.setIgnoresOwner((Boolean)((Option.BooleanOption)option).get());
        }
        super.onOptionChanged(option);
    }

    private void modifyFields(BiConsumer<BlockPos, BlockState> blockSetter, Consumer<InventoryScannerBlockEntity> connectedScannerModifier) {
        InventoryScannerBlockEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(this.f_58857_, this.f_58858_);
        if (connectedScanner != null) {
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)InventoryScannerBlock.FACING);
            connectedScannerModifier.accept(connectedScanner);
            for (int i = 0; i <= (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(); ++i) {
                BlockPos offsetPos = this.f_58858_.m_5484_(facing, i);
                BlockState state = this.f_58857_.m_8055_(offsetPos);
                Block block = state.m_60734_();
                if (block == SCContent.INVENTORY_SCANNER_FIELD.get()) {
                    blockSetter.accept(offsetPos, state);
                    continue;
                }
                if (!state.m_60795_() && block != SCContent.INVENTORY_SCANNER_FIELD.get() && block != SCContent.INVENTORY_SCANNER.get() || block == SCContent.INVENTORY_SCANNER.get() && state.m_61143_((Property)InventoryScannerBlock.FACING) == facing.m_122424_()) break;
            }
        }
    }

    public void setHorizontal(boolean isHorizontal) {
        if ((Boolean)this.horizontal.get() != isHorizontal) {
            this.horizontal.setValue(isHorizontal);
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)InventoryScannerBlock.HORIZONTAL, (Comparable)Boolean.valueOf(isHorizontal)));
            this.m_6596_();
        }
    }

    public boolean isHorizontal() {
        return (Boolean)this.horizontal.get();
    }

    public boolean doesFieldSolidify() {
        return (Boolean)this.solidifyField.get();
    }

    public void setSolidifyField(boolean shouldSolidify) {
        if (this.doesFieldSolidify() != shouldSolidify) {
            this.solidifyField.setValue(shouldSolidify);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            this.disabled.setValue(disabled);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    public void setIgnoresOwner(boolean ignoresOwner) {
        if (this.ignoresOwner() != ignoresOwner) {
            this.ignoreOwner.setValue(ignoresOwner);
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.horizontal, this.solidifyField, this.disabled, this.ignoreOwner};
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new InventoryScannerMenu(windowId, this.f_58857_, this.f_58858_, inv);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }

    public void m_6211_() {
        this.inventoryContents.clear();
    }

    public boolean m_7983_() {
        return this.inventoryContents.isEmpty();
    }

    public ItemStack m_8016_(int index) {
        return (ItemStack)this.inventoryContents.remove(index);
    }
}

