/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements MenuProvider,
ILockable,
ICodebreakable {
    private boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    private int signature = 0;
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(() -> ((KeycardReaderBlockEntity)this).m_58899_(), "signalLength", 60, 5, 400, 5, true);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);

    public KeycardReaderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag acceptedLevelsTag = new CompoundTag();
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.m_128379_("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.m_128365_("acceptedLevels", (Tag)acceptedLevelsTag);
        tag.m_128405_("signature", this.signature);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("passLV")) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.m_128451_("passLV") - 1;
            if (tag.m_128441_("requiresExactKeycard")) {
                oldRequiresExactKeycard = tag.m_128471_("requiresExactKeycard");
            }
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.m_128425_("acceptedLevels", 10)) {
            CompoundTag acceptedLevelsTag = tag.m_128469_("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.m_128471_("lvl" + i);
            }
        }
        this.signature = tag.m_128451_("signature");
    }

    @Override
    public boolean shouldAttemptCodebreak(BlockState state, Player player) {
        if (this.isDisabled()) {
            player.m_5661_((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)state.m_61143_((Property)KeycardReaderBlock.POWERED) == false;
    }

    @Override
    public void useCodebreaker(BlockState state, Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeycardReaderBlock) {
            KeycardReaderBlock block2 = (KeycardReaderBlock)block;
            block2.activate(this.f_58857_, this.f_58858_, (Integer)this.signalLength.get());
        }
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
        this.m_6596_();
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
        this.m_6596_();
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new KeycardReaderMenu(windowId, inv, this.f_58857_, this.f_58858_);
    }

    public Component m_5446_() {
        return super.m_5446_();
    }
}

