/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.ArrayList;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.client.RefreshDisguisableModel;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.network.PacketDistributor;

public class LaserBlockBlockEntity
extends LinkableBlockEntity {
    private Option.DisabledOption disabled = new Option.DisabledOption((Boolean)false){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockBlockEntity.this.setLasersAccordingToDisabledOption();
        }
    };
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);

    public LaserBlockBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), pos, state);
    }

    private void setLasersAccordingToDisabledOption() {
        if (this.isEnabled()) {
            ((LaserBlock)this.m_58900_().m_60734_()).setLaser(this.f_58857_, this.f_58858_);
        } else {
            LaserBlock.destroyAdjacentLasers((LevelAccessor)this.f_58857_, this.f_58858_);
        }
    }

    @Override
    protected void onLinkedBlockAction(ILinkedAction action, ArrayList<LinkableBlockEntity> excludedBEs) {
        if (action instanceof ILinkedAction.OptionChanged) {
            ILinkedAction.OptionChanged optionChanged = (ILinkedAction.OptionChanged)action;
            Option option = optionChanged.option();
            if (option.getName().equals("disabled")) {
                this.disabled.copy(option);
                this.setLasersAccordingToDisabledOption();
            } else if (option.getName().equals("ignoreOwner")) {
                this.ignoreOwner.copy(option);
            }
        } else if (action instanceof ILinkedAction.ModuleInserted) {
            ILinkedAction.ModuleInserted moduleInserted = (ILinkedAction.ModuleInserted)action;
            this.insertModule(moduleInserted.stack(), moduleInserted.wasModuleToggled());
        } else if (action instanceof ILinkedAction.ModuleRemoved) {
            ILinkedAction.ModuleRemoved moduleRemoved = (ILinkedAction.ModuleRemoved)action;
            this.removeModule(moduleRemoved.moduleType(), moduleRemoved.wasModuleToggled());
        } else if (action instanceof ILinkedAction.OwnerChanged) {
            ILinkedAction.OwnerChanged ownerChanged = (ILinkedAction.OwnerChanged)action;
            Owner owner = ownerChanged.newOwner();
            this.setOwner(owner.getUUID(), owner.getName());
        } else if (action instanceof ILinkedAction.StateChanged) {
            ILinkedAction.StateChanged stateChanged = (ILinkedAction.StateChanged)action;
            BlockState state = this.m_58900_();
            if (stateChanged.property() == LaserBlock.POWERED && !((Boolean)state.m_61143_((Property)LaserBlock.POWERED)).booleanValue()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.LASER_BLOCK.get());
                this.f_58857_.m_186460_(this.f_58858_, (Block)SCContent.LASER_BLOCK.get(), 50);
            }
        }
        excludedBEs.add(this);
        this.createLinkedBlockAction(action, excludedBEs);
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            BlockState state = this.m_58900_();
            if (!this.f_58857_.f_46443_) {
                SecurityCraft.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new RefreshDisguisableModel(this.f_58858_, true, stack, toggled));
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                    this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                }
            } else {
                ClientHandler.putDisguisedBeRenderer(this, stack);
                if (state.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                    this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            if (!this.f_58857_.f_46443_) {
                BlockState state = this.m_58900_();
                SecurityCraft.channel.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new RefreshDisguisableModel(this.f_58858_, false, stack, toggled));
                if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    this.f_58857_.m_186469_(this.f_58858_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)this.f_58857_));
                    this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
                }
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
                DisguisableBlock.getDisguisedBlockStateFromStack(this.f_58857_, stack).ifPresent(disguisedState -> {
                    if (disguisedState.getLightEmission((BlockGetter)this.f_58857_, this.f_58858_) > 0) {
                        this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
                    }
                });
            }
        } else if (module == ModuleType.REDSTONE && ((Boolean)this.m_58900_().m_61143_((Property)LaserBlock.POWERED)).booleanValue()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)LaserBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.f_58857_, this.f_58858_, (Block)SCContent.LASER_BLOCK.get());
        }
    }

    @Override
    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            ItemStack stack = this.getModule(ModuleType.DISGUISE);
            if (!stack.m_41619_()) {
                ClientHandler.putDisguisedBeRenderer(this, stack);
            } else {
                ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
            }
        }
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.m_128441_("enabled")) {
            tag.m_128379_("disabled", !tag.m_128471_("enabled"));
        }
        for (Option<?> option : this.customOptions()) {
            option.readFromNBT(tag);
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_.f_46443_) {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.disabled, this.ignoreOwner};
    }

    public ModelData getModelData() {
        BlockState disguisedState = DisguisableBlock.getDisguisedStateOrDefault(Blocks.f_50016_.m_49966_(), (BlockGetter)this.f_58857_, this.f_58858_);
        return ModelData.builder().with(DisguisableDynamicBakedModel.DISGUISED_STATE, (Object)disguisedState).build();
    }

    public boolean isEnabled() {
        return (Boolean)this.disabled.get() == false;
    }

    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }
}

